/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.deliverables;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.pnc.coordinator.notifications.buildTask.MessageSenderProvider;
import org.jboss.pnc.facade.deliverables.AnalysisStatusChangedEvent;
import org.jboss.pnc.messaging.spi.AnalysisStatusMessage;
import org.jboss.pnc.messaging.spi.Message;
import org.jboss.pnc.messaging.spi.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class AnalysisStatusMQNotifications {
    private final String ATTRIBUTE_NAME = "analysis-state-change";
    private final Logger logger = LoggerFactory.getLogger(AnalysisStatusMQNotifications.class);
    private final Optional<MessageSender> messageSender;

    @Inject
    public AnalysisStatusMQNotifications(MessageSenderProvider messageSenderProvider) {
        this.messageSender = messageSenderProvider.getMessageSender();
    }

    public void observeEvent(@Observes AnalysisStatusChangedEvent event) {
        this.logger.debug("Observed new analysis status changed event {}.", (Object)event);
        this.messageSender.ifPresent(ms -> this.send((MessageSender)ms, event));
        this.logger.debug("Analysis status changed event processed {}.", (Object)event);
    }

    private void send(MessageSender ms, AnalysisStatusChangedEvent event) {
        AnalysisStatusMessage message = new AnalysisStatusMessage("analysis-state-change", event.getMilestoneId(), event.getStatus().toString(), event.getSourcesLinks());
        ms.sendToTopic((Message)message, this.prepareHeaders(event));
    }

    private Map<String, String> prepareHeaders(AnalysisStatusChangedEvent event) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("type", "AnalysisStateChange");
        headers.put("attribute", "analysis-state-change");
        headers.put("milestoneId", event.getMilestoneId());
        headers.put("status", event.getStatus().toString());
        return headers;
    }
}

