/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.deliverables;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jboss.pnc.api.deliverablesanalyzer.dto.ArtifactType;
import org.jboss.pnc.api.deliverablesanalyzer.dto.Build;
import org.jboss.pnc.api.deliverablesanalyzer.dto.MavenArtifact;
import org.jboss.pnc.api.deliverablesanalyzer.dto.NPMArtifact;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.mapper.api.ArtifactMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.TargetRepository;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.TargetRepositoryRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@Transactional
@ApplicationScoped
public class DeliverableAnalyzerResultProcessor {
    private static final String KOJI_PATH_MAVEN_PREFIX = "/api/content/maven/remote/koji-";
    @Inject
    private ProductMilestoneRepository milestoneRepository;
    @Inject
    private ArtifactRepository artifactRepository;
    @Inject
    private TargetRepositoryRepository targetRepositoryRepository;
    @Inject
    private ArtifactMapper artifactMapper;

    public void processDeliverables(int milestoneId, Collection<Build> builds, String distributionUrl, User user) {
        ProductMilestone milestone = (ProductMilestone)this.milestoneRepository.queryById((Serializable)Integer.valueOf(milestoneId));
        for (Build build : builds) {
            Function<org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact, Artifact> artifactParser;
            if (build.getBuildSystemType() == null) {
                TargetRepository distributionRepository = this.getDistributionRepository(distributionUrl);
                artifactParser = art -> this.findOrCreateArtifact((org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact)art, distributionRepository);
            } else {
                switch (build.getBuildSystemType()) {
                    case PNC: {
                        artifactParser = this::getPncArtifact;
                        break;
                    }
                    case BREW: {
                        TargetRepository brewRepository = this.getBrewRepository(build);
                        artifactParser = art -> this.findOrCreateArtifact(this.assertBrewArtifacts((org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact)art), brewRepository);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unknown build system type " + build.getBuildSystemType());
                    }
                }
            }
            build.getArtifacts().stream().map(artifactParser).forEach(arg_0 -> ((ProductMilestone)milestone).addDeliveredArtifact(arg_0));
        }
        milestone.setDeliveredArtifactsImporter(user);
    }

    private Artifact findOrCreateArtifact(org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact art, TargetRepository targetRepo) {
        Artifact artifact = this.mapArtifact(art);
        Artifact dbArtifact = (Artifact)this.artifactRepository.queryByPredicates(new Predicate[]{ArtifactPredicates.withIdentifierAndSha256((String)artifact.getIdentifier(), (String)artifact.getSha256()), ArtifactPredicates.withTargetRepositoryId((Integer)targetRepo.getId())});
        if (dbArtifact != null) {
            return dbArtifact;
        }
        artifact.setTargetRepository(targetRepo);
        Artifact savedArtifact = (Artifact)this.artifactRepository.save((GenericEntity)artifact);
        targetRepo.getArtifacts().add(savedArtifact);
        return savedArtifact;
    }

    private Artifact getPncArtifact(org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact art) {
        Artifact artifact = (Artifact)this.artifactRepository.queryById((Serializable)((Integer)this.artifactMapper.getIdMapper().toEntity((Object)art.getPncId())));
        if (artifact == null) {
            throw new IllegalArgumentException("PNC artifact with id " + art.getPncId() + " doesn't exist.");
        }
        return artifact;
    }

    private Artifact mapArtifact(org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact art) {
        Artifact.Builder builder = Artifact.builder();
        builder.md5(art.getMd5());
        builder.sha1(art.getSha1());
        builder.sha256(art.getSha256());
        builder.size(Long.valueOf(art.getSize()));
        builder.filename(art.getFilename());
        if (art.getArtifactType() == null) {
            builder.identifier(art.getFilename());
        } else {
            switch (art.getArtifactType()) {
                case MAVEN: {
                    builder.identifier(this.fill((MavenArtifact)art));
                    break;
                }
                case NPM: {
                    builder.identifier(this.fill((NPMArtifact)art));
                }
            }
        }
        if (art.isBuiltFromSource()) {
            builder.artifactQuality(ArtifactQuality.NEW);
        } else {
            builder.artifactQuality(ArtifactQuality.IMPORTED);
        }
        return builder.build();
    }

    private String fill(MavenArtifact mavenArtifact) {
        return Arrays.asList(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getType(), mavenArtifact.getVersion(), mavenArtifact.getClassifier()).stream().filter(Objects::nonNull).collect(Collectors.joining(":"));
    }

    private String fill(NPMArtifact mavenArtifact) {
        return mavenArtifact.getName() + ":" + mavenArtifact.getVersion();
    }

    private TargetRepository getBrewRepository(Build build) {
        String path = KOJI_PATH_MAVEN_PREFIX + build.getBrewNVR();
        TargetRepository tr = this.targetRepositoryRepository.queryByIdentifierAndPath("indy-maven", path);
        if (tr == null) {
            tr = this.createRepository(path, "indy-maven", RepositoryType.MAVEN);
        }
        return tr;
    }

    private TargetRepository getDistributionRepository(String distURL) {
        TargetRepository tr = this.targetRepositoryRepository.queryByIdentifierAndPath("distribution-archive", distURL);
        if (tr == null) {
            tr = this.createRepository(distURL, "distribution-archive", RepositoryType.DISTRIBUTION_ARCHIVE);
        }
        return tr;
    }

    private TargetRepository createRepository(String path, String identifier, RepositoryType type) {
        TargetRepository tr = TargetRepository.newBuilder().temporaryRepo(Boolean.valueOf(false)).identifier(identifier).repositoryPath(path).repositoryType(type).build();
        return (TargetRepository)this.targetRepositoryRepository.save((GenericEntity)tr);
    }

    private org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact assertBrewArtifacts(org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact artifact) {
        if (artifact.getArtifactType() != null && artifact.getArtifactType() != ArtifactType.MAVEN) {
            throw new IllegalArgumentException("Brew artifacts are expected to be either MAVEN or unknown, artifact " + artifact + " is " + artifact.getArtifactType());
        }
        return artifact;
    }
}

