/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.impl;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.pnc.api.constants.MDCHeaderKeys;
import org.jboss.pnc.api.dto.Request;
import org.jboss.pnc.bpm.RestConnector;
import org.jboss.pnc.bpm.model.AnalyzeDeliverablesBpmRequest;
import org.jboss.pnc.bpm.task.AnalyzeDeliverablesTask;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.json.moduleconfig.BpmModuleConfig;
import org.jboss.pnc.dto.requests.DeliverablesAnalysisRequest;
import org.jboss.pnc.enums.AnalysisStatus;
import org.jboss.pnc.facade.DeliverablesAnalyzerInvoker;
import org.jboss.pnc.facade.deliverables.AnalysisStatusChangedEvent;
import org.jboss.pnc.facade.deliverables.DefaultAnalysisStatusChangedEvent;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.spi.exception.ProcessManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@ApplicationScoped
public class DeliverablesAnalyzerInvokerImpl
implements DeliverablesAnalyzerInvoker {
    private static final Logger log = LoggerFactory.getLogger(DeliverablesAnalyzerInvokerImpl.class);
    private UserService userService;
    private GlobalModuleGroup globalConfig;
    private BpmModuleConfig bpmConfig;
    private String callbackUrlTemplate = "%s/deliverable-analysis/complete";
    private final Event<AnalysisStatusChangedEvent> analysisStatusChangedEventNotifier;

    @Inject
    public DeliverablesAnalyzerInvokerImpl(UserService userService, GlobalModuleGroup globalConfig, BpmModuleConfig bpmConfig, Event<AnalysisStatusChangedEvent> analysisStatusChangedEventNotifier) {
        this.userService = userService;
        this.globalConfig = globalConfig;
        this.bpmConfig = bpmConfig;
        this.analysisStatusChangedEventNotifier = analysisStatusChangedEventNotifier;
    }

    @Override
    public void startAnalysis(String milestoneId, DeliverablesAnalysisRequest request) {
        String accessToken = this.userService.currentUserToken();
        String actualEndpoint = String.format(this.callbackUrlTemplate, this.globalConfig.getPncUrl());
        URI callbackURI = URI.create(actualEndpoint);
        ArrayList<Request.Header> headers = new ArrayList<Request.Header>();
        this.addCommonHeaders(headers, accessToken);
        this.addMDCHeaders(headers);
        Request callback = new Request(Request.Method.POST, callbackURI, headers);
        try (RestConnector restConnector = new RestConnector(this.bpmConfig);){
            AnalyzeDeliverablesBpmRequest bpmRequest = new AnalyzeDeliverablesBpmRequest(milestoneId, request.getSourcesLink(), null);
            AnalyzeDeliverablesTask analyzeTask = new AnalyzeDeliverablesTask(bpmRequest, callback, this.globalConfig.getDelAnalUrl());
            restConnector.startProcess(this.bpmConfig.getAnalyzeDeliverablesBpmProcessId(), (Object)analyzeTask, accessToken);
            DefaultAnalysisStatusChangedEvent analysisStatusChanged = new DefaultAnalysisStatusChangedEvent(AnalysisStatus.STARTED, milestoneId, request.getSourcesLink());
            this.analysisStatusChangedEventNotifier.fire((Object)analysisStatusChanged);
        }
        catch (ProcessManagerException e) {
            log.error("Error trying to start analysis of deliverables task for milestone: {}", (Object)milestoneId, (Object)e);
            throw new RuntimeException(e);
        }
    }

    private void addMDCHeaders(List<Request.Header> headers) {
        this.headersFromMdc(headers, MDCHeaderKeys.REQUEST_CONTEXT);
        this.headersFromMdc(headers, MDCHeaderKeys.PROCESS_CONTEXT);
    }

    private void addCommonHeaders(List<Request.Header> headers, String accessToken) {
        headers.add(new Request.Header("Content-Type", "application/json"));
        if (accessToken != null) {
            headers.add(new Request.Header("Authorization", "Bearer " + accessToken));
        }
    }

    private void headersFromMdc(List<Request.Header> headers, MDCHeaderKeys headerKey) {
        String mdcValue = MDC.get((String)headerKey.getMdcKey());
        if (mdcValue != null && mdcValue.isEmpty()) {
            headers.add(new Request.Header(headerKey.getHeaderName(), mdcValue.trim()));
        }
    }
}

