/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.deliverables;

import java.util.List;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.facade.deliverables.DeliverableAnalysisStatusChangedEvent;

public class DefaultDeliverableAnalysisStatusChangedEvent
implements DeliverableAnalysisStatusChangedEvent {
    private final String operationId;
    private final ProgressStatus status;
    private final OperationResult result;
    private final String milestoneId;
    private final List<String> sourcesLinks;

    public DefaultDeliverableAnalysisStatusChangedEvent(String operationId, ProgressStatus status, OperationResult result, String milestoneId, List<String> sourcesLinks) {
        this.operationId = operationId;
        this.status = status;
        this.result = result;
        this.milestoneId = milestoneId;
        this.sourcesLinks = sourcesLinks;
    }

    public static DefaultDeliverableAnalysisStatusChangedEvent started(String operationId, String milestoneId, List<String> sourcesLinks) {
        return new DefaultDeliverableAnalysisStatusChangedEvent(operationId, ProgressStatus.IN_PROGRESS, null, milestoneId, sourcesLinks);
    }

    public static DefaultDeliverableAnalysisStatusChangedEvent finished(String operationId, String milestoneId, OperationResult result, List<String> sourcesLinks) {
        return new DefaultDeliverableAnalysisStatusChangedEvent(operationId, ProgressStatus.FINISHED, result, milestoneId, sourcesLinks);
    }

    public String toString() {
        return "DefaultAnalysisStatusChangedEvent{status=" + this.status + ", milestoneId=" + this.milestoneId + ", sourcesLinks=" + String.join((CharSequence)";", this.sourcesLinks) + '}';
    }

    @Override
    public String getOperationId() {
        return this.operationId;
    }

    @Override
    public ProgressStatus getStatus() {
        return this.status;
    }

    @Override
    public OperationResult getResult() {
        return this.result;
    }

    @Override
    public String getMilestoneId() {
        return this.milestoneId;
    }

    @Override
    public List<String> getSourcesLinks() {
        return this.sourcesLinks;
    }
}

