/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.impl;

import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.jboss.pnc.api.constants.BuildConfigurationParameterKeys;
import org.jboss.pnc.bpm.causeway.BuildPushOperation;
import org.jboss.pnc.bpm.causeway.BuildResultPushManager;
import org.jboss.pnc.bpm.causeway.InProgress;
import org.jboss.pnc.bpm.causeway.Result;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.dto.BuildPushResult;
import org.jboss.pnc.dto.requests.BuildPushParameters;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.BuildPushStatus;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.facade.BrewPusher;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.AlreadyRunningException;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.OperationNotAllowedException;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.BuildPushResultMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildRecordPushResult;
import org.jboss.pnc.spi.coordinator.ProcessException;
import org.jboss.pnc.spi.datastore.InconsistentDataException;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.predicates.BuildRecordPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordPushResultRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class BrewPusherImpl
implements BrewPusher {
    private static final Logger log = LoggerFactory.getLogger(BrewPusherImpl.class);
    @Inject
    private BuildRecordRepository buildRecordRepository;
    @Inject
    private ArtifactRepository artifactRepository;
    @Inject
    private BuildRecordPushResultRepository buildRecordPushResultRepository;
    @Inject
    private BuildResultPushManager buildResultPushManager;
    @Inject
    private GlobalModuleGroup globalModuleGroupConfiguration;
    @Inject
    private BuildPushResultMapper buildPushResultMapper;
    @Inject
    private UserService userService;
    private static final EnumSet<ArtifactQuality> ARTIFACT_BAD_QUALITIES = EnumSet.of(ArtifactQuality.DELETED, ArtifactQuality.BLACKLISTED);
    private static final Logger userLog = LoggerFactory.getLogger((String)"org.jboss.pnc._userlog_.brewpush");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BuildPushResult> pushGroup(int buildGroupId, String tagPrefix) {
        BuildPushParameters buildPushParameters = BuildPushParameters.builder().tagPrefix(tagPrefix).reimport(false).build();
        List buildRecords = this.buildRecordRepository.queryWithPredicates(new Predicate[]{BuildRecordPredicates.withBuildConfigSetRecordId((Integer)buildGroupId)});
        HashSet<BuildPushResult> results = new HashSet<BuildPushResult>();
        for (BuildRecord buildRecord : buildRecords) {
            Long buildPushResultId = Sequence.nextId();
            MDCUtils.addProcessContext((String)buildPushResultId.toString());
            MDCUtils.addCustomContext((String)"buildId", (String)buildRecord.getId().getId());
            try {
                results.add(this.doPushBuild(buildRecord.getId(), buildPushParameters, buildPushResultId));
            }
            catch (AlreadyRunningException | OperationNotAllowedException e) {
                results.add(BuildPushResult.builder().status(BuildPushStatus.REJECTED).id(buildPushResultId.toString()).buildId(BuildMapper.idMapper.toDto(buildRecord.getId())).message(e.getMessage()).build());
            }
            catch (ProcessException | InconsistentDataException e) {
                results.add(BuildPushResult.builder().status(BuildPushStatus.SYSTEM_ERROR).id(buildPushResultId.toString()).buildId(BuildMapper.idMapper.toDto(buildRecord.getId())).message(e.getMessage()).build());
            }
            finally {
                MDCUtils.removeProcessContext();
                MDCUtils.removeCustomContext((String)"buildId");
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildPushResult pushBuild(String buildId, BuildPushParameters buildPushParameters) throws ProcessException {
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        BuildRecord build = (BuildRecord)this.buildRecordRepository.queryById((Serializable)BuildMapper.idMapper.toEntity(buildId));
        if (build.getStatus().equals((Object)BuildStatus.NO_REBUILD_REQUIRED)) {
            throw new OperationNotAllowedException("Build has NO_REBUILD_REQUIRED status, push last successful build or use force-rebuild.");
        }
        Long buildPushResultId = Sequence.nextId();
        MDCUtils.addProcessContext((String)buildPushResultId.toString());
        MDCUtils.addCustomContext((String)"buildId", (String)id.getId());
        try {
            BuildPushResult buildPushResult = this.doPushBuild(id, buildPushParameters, buildPushResultId);
            return buildPushResult;
        }
        finally {
            MDCUtils.removeProcessContext();
            MDCUtils.removeCustomContext((String)"buildId");
        }
    }

    private BuildPushResult doPushBuild(Base32LongID buildId, BuildPushParameters buildPushParameters, Long buildPushResultId) throws ProcessException {
        userLog.info("Push started.");
        BuildRecord buildRecord = this.getLatestSuccessfullyExecutedBuildRecord(buildId);
        if (buildRecord.getExecutionRootName() == null && !buildRecord.getBuildConfigurationAudited().getGenericParameters().containsKey(BuildConfigurationParameterKeys.BREW_BUILD_NAME.name())) {
            throw new InvalidEntityException("Build " + buildId + " cannot be pushed to brew, because it is missing " + "BREW_BUILD_NAME" + " attribute with brew name.");
        }
        List artifacts = this.artifactRepository.queryWithPredicates(new Predicate[]{ArtifactPredicates.withBuildRecordId((Base32LongID)buildRecord.getId())});
        if (this.hasBadArtifactQuality(artifacts)) {
            String message = "Build contains artifacts of insufficient quality: BLACKLISTED/DELETED.";
            log.debug(message);
            BuildPushResult pushResult = BuildPushResult.builder().buildId(BuildMapper.idMapper.toDto(buildId)).status(BuildPushStatus.REJECTED).id(buildPushResultId.toString()).logContext(buildPushResultId.toString()).message(message).build();
            throw new OperationNotAllowedException(message, (Object)pushResult);
        }
        log.debug("Pushing Build.id {}.", (Object)buildRecord.getId());
        BuildPushOperation buildPushOperation = new BuildPushOperation(buildRecord, buildPushResultId, buildPushParameters.getTagPrefix(), buildPushParameters.isReimport(), this.getCompleteCallbackUrlTemplate());
        Result pushResult = this.buildResultPushManager.push(buildPushOperation, this.userService.currentUserToken());
        log.info("Push Result {}.", (Object)pushResult);
        BuildPushResult result = BuildPushResult.builder().id(pushResult.getId()).buildId(pushResult.getBuildId()).status(pushResult.getStatus()).logContext(pushResult.getId()).message(pushResult.getMessage()).build();
        switch (pushResult.getStatus()) {
            case ACCEPTED: {
                userLog.info("Push ACCEPTED.");
                return result;
            }
            case REJECTED: {
                userLog.warn("Push REJECTED.");
                throw new AlreadyRunningException(pushResult.getMessage(), (Object)result);
            }
            case SYSTEM_ERROR: {
                userLog.error("Brew push failed: " + pushResult.getMessage());
                throw new ProcessException(pushResult.getMessage());
            }
        }
        userLog.error("Invalid push result status.");
        throw new ProcessException("Invalid push result status.");
    }

    private boolean hasBadArtifactQuality(Collection<Artifact> builtArtifacts) {
        return builtArtifacts.stream().map(Artifact::getArtifactQuality).anyMatch(ARTIFACT_BAD_QUALITIES::contains);
    }

    private BuildRecord getLatestSuccessfullyExecutedBuildRecord(Base32LongID buildRecordId) {
        BuildRecord buildRecord = this.buildRecordRepository.findByIdFetchProperties(buildRecordId);
        if (buildRecord == null) {
            throw new EmptyEntityException("Build record not found.");
        }
        switch (buildRecord.getStatus()) {
            case SUCCESS: {
                return buildRecord;
            }
            case NO_REBUILD_REQUIRED: {
                BuildRecord noRebuildCause = buildRecord.getNoRebuildCause();
                if (noRebuildCause != null) {
                    return noRebuildCause;
                }
                String message = "There is no SUCCESS build before NO_REBUILD_REQUIRED.";
                log.error(message);
                throw new InconsistentDataException(message);
            }
        }
        throw new OperationNotAllowedException("Not allowed to push failed build.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean brewPushCancel(String buildId) {
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        Optional pushContext = this.buildResultPushManager.getContext(id);
        if (pushContext.isPresent()) {
            MDCUtils.addProcessContext((String)((InProgress.Context)pushContext.get()).getPushResultId());
            MDCUtils.addCustomContext((String)"buildId", (String)id.getId());
            userLog.info("Build push cancel requested.");
            try {
                boolean bl = this.buildResultPushManager.cancelInProgressPush(id);
                return bl;
            }
            finally {
                MDCUtils.removeProcessContext();
                MDCUtils.removeCustomContext((String)"buildId");
            }
        }
        throw new EmptyEntityException("There is no running push operation for build id: " + buildId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BuildPushResult brewPushComplete(String buildId, BuildPushResult buildPushResult) {
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        MDCUtils.addProcessContext((String)buildPushResult.getId());
        MDCUtils.addCustomContext((String)"buildId", (String)id.getId());
        try {
            log.info("Received completion notification for BuildRecord.id: {}. Object received: {}.", (Object)buildId, (Object)buildPushResult);
            this.buildResultPushManager.complete(id, this.buildPushResultMapper.toEntity(buildPushResult));
            userLog.info("Brew push completed.");
            BuildPushResult buildPushResult2 = buildPushResult;
            return buildPushResult2;
        }
        finally {
            MDCUtils.removeProcessContext();
            MDCUtils.removeCustomContext((String)"buildId");
        }
    }

    @Override
    public BuildPushResult getBrewPushResult(String buildId) {
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        BuildPushResult result = null;
        Optional pushContext = this.buildResultPushManager.getContext(id);
        if (pushContext.isPresent()) {
            result = BuildPushResult.builder().buildId(buildId).status(BuildPushStatus.ACCEPTED).logContext(((InProgress.Context)pushContext.get()).getPushResultId()).build();
        } else {
            BuildRecordPushResult latestForBuildRecord = this.buildRecordPushResultRepository.getLatestForBuildRecord(id);
            if (latestForBuildRecord != null) {
                return this.buildPushResultMapper.toDTO(latestForBuildRecord);
            }
        }
        return result;
    }

    private String getCompleteCallbackUrlTemplate() {
        String pncBaseUrl = StringUtils.stripEndingSlash((String)this.globalModuleGroupConfiguration.getPncUrl());
        return pncBaseUrl + "/builds/%s/brew-push/complete";
    }
}

