/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.impl;

import java.io.Serializable;
import java.net.URI;
import java.sql.Date;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jboss.pnc.api.constants.MDCHeaderKeys;
import org.jboss.pnc.api.dto.Request;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.facade.OperationsManager;
import org.jboss.pnc.facade.impl.OperationChangedEvent;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.mapper.api.OperationMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.DeliverableAnalyzerOperation;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.Operation;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.spi.datastore.repositories.OperationRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@ApplicationScoped
@Transactional
public class OperationsManagerImpl
implements OperationsManager {
    private static final Logger log = LoggerFactory.getLogger(OperationsManagerImpl.class);
    private String callbackUrlTemplate = "%s/operations/%s/complete";
    @Inject
    private OperationRepository repository;
    @Inject
    private ProductMilestoneRepository productMilestoneRepository;
    @Inject
    private UserService userService;
    @Inject
    private GlobalModuleGroup globalConfig;
    @Inject
    private Event<OperationChangedEvent> analysisStatusChangedEventNotifier;

    @Override
    public Operation updateProgress(Base32LongID id, ProgressStatus status) {
        Operation operation = (Operation)this.repository.queryById((Serializable)id);
        if (operation.getEndTime() != null) {
            throw new InvalidEntityException("Operation " + operation + " is already finished!");
        }
        log.debug("Updating progress of operation " + operation + " to " + status);
        if (operation.getStartTime() == null && status == ProgressStatus.IN_PROGRESS) {
            operation.setStartTime(Date.from(Instant.now()));
        }
        ProgressStatus previousProgress = operation.getProgressStatus();
        operation.setProgressStatus(status);
        this.analysisStatusChangedEventNotifier.fire((Object)new OperationChangedEvent(operation, previousProgress));
        return operation;
    }

    @Override
    public Operation setResult(Base32LongID id, OperationResult result) {
        Operation operation = (Operation)this.repository.queryById((Serializable)id);
        if (operation.getEndTime() != null) {
            throw new InvalidEntityException("Operation " + operation + " is already finished!");
        }
        log.debug("Updating result of operation " + operation + " to " + result);
        ProgressStatus previousProgress = operation.getProgressStatus();
        operation.setResult(result);
        operation.setEndTime(Date.from(Instant.now()));
        this.analysisStatusChangedEventNotifier.fire((Object)new OperationChangedEvent(operation, previousProgress));
        return operation;
    }

    @Override
    public DeliverableAnalyzerOperation newDeliverableAnalyzerOperation(String milestoneId, Map<String, String> inputParams) {
        ProductMilestone milestone = (ProductMilestone)this.productMilestoneRepository.queryById((Serializable)ProductMilestoneMapper.idMapper.toEntity(milestoneId));
        if (milestone == null) {
            throw new EmptyEntityException("Milestone with id " + milestoneId + " doesn't exist");
        }
        String operationId = Sequence.nextBase32Id();
        MDCUtils.addProcessContext((String)operationId);
        DeliverableAnalyzerOperation operation = DeliverableAnalyzerOperation.Builder.newBuilder().progressStatus(ProgressStatus.NEW).submitTime(Date.from(Instant.now())).productMilestone(milestone).operationParameters(inputParams).user(this.userService.currentUser()).id(operationId).build();
        this.repository.save((GenericEntity)operation);
        this.analysisStatusChangedEventNotifier.fire((Object)new OperationChangedEvent((Operation)operation, null));
        return operation;
    }

    @Override
    public Request getOperationCallback(Base32LongID operationId) {
        String accessToken = this.userService.currentUserToken();
        ArrayList<Request.Header> headers = new ArrayList<Request.Header>();
        this.addCommonHeaders(headers, accessToken);
        this.addMDCHeaders(headers);
        String actualEndpoint = String.format(this.callbackUrlTemplate, this.globalConfig.getPncUrl(), operationId.getId());
        URI callbackURI = URI.create(actualEndpoint);
        return new Request(Request.Method.POST, callbackURI, headers);
    }

    private void addMDCHeaders(List<Request.Header> headers) {
        this.headersFromMdc(headers, MDCHeaderKeys.REQUEST_CONTEXT);
        this.headersFromMdc(headers, MDCHeaderKeys.PROCESS_CONTEXT);
    }

    private void addCommonHeaders(List<Request.Header> headers, String accessToken) {
        headers.add(new Request.Header("Content-Type", "application/json"));
        if (accessToken != null) {
            headers.add(new Request.Header("Authorization", "Bearer " + accessToken));
        }
    }

    private void headersFromMdc(List<Request.Header> headers, MDCHeaderKeys headerKey) {
        String mdcValue = MDC.get((String)headerKey.getMdcKey());
        if (mdcValue != null && mdcValue.isEmpty()) {
            headers.add(new Request.Header(headerKey.getHeaderName(), mdcValue.trim()));
        }
    }

    private Base32LongID parseId(String operationId) {
        return OperationMapper.idMapper.toEntity(operationId);
    }
}

