/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.inject.Inject;
import org.jboss.pnc.dto.Operation;
import org.jboss.pnc.dto.OperationRef;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.OperationProvider;
import org.jboss.pnc.mapper.api.UpdatableEntityMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.spi.datastore.repositories.api.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
public abstract class OperationProviderImpl<DB extends org.jboss.pnc.model.Operation, DTO extends Operation>
extends AbstractUpdatableProvider<Base32LongID, DB, DTO, OperationRef>
implements OperationProvider<DB, DTO> {
    private static final Logger log = LoggerFactory.getLogger(OperationProviderImpl.class);

    @Inject
    public OperationProviderImpl(Repository<DB, Base32LongID> repository, UpdatableEntityMapper<Base32LongID, DB, DTO, OperationRef> mapper, Class<DB> type) {
        super(repository, mapper, type);
    }

    @Override
    @DenyAll
    public DTO store(DTO restEntity) {
        throw new UnsupportedOperationException("Creating operations is prohibited!");
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public DTO update(String operationId, DTO restEntity) {
        return (DTO)((Operation)super.update(operationId, restEntity));
    }

    @Override
    @DenyAll
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting operations is prohibited!");
    }
}

