/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql;

import org.jboss.pnc.facade.rsql.RSQLException;

public class RSQLSelectorPath {
    private final String element;
    private final RSQLSelectorPath next;

    private RSQLSelectorPath(String element, RSQLSelectorPath next) {
        this.element = element;
        this.next = next;
    }

    public static RSQLSelectorPath get(String selector) {
        String[] fields = selector.split("\\.");
        RSQLSelectorPath next = null;
        for (int i = fields.length - 1; i >= 0; --i) {
            next = new RSQLSelectorPath(fields[i], next);
        }
        return next;
    }

    public RSQLSelectorPath next() {
        if (this.next == null) {
            throw new RSQLException("Another element in the RSQL selector expected after " + this.element);
        }
        return this.next;
    }

    public boolean isFinal() {
        return this.next == null;
    }

    public String getElement() {
        return this.element;
    }
}

