/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql;

import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.function.Function;
import org.jboss.pnc.facade.rsql.RSQLException;
import org.jboss.pnc.facade.rsql.RSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.RSQLProducerImpl;
import org.jboss.pnc.facade.rsql.RSQLSelectorPath;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.DefaultSortInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SortRSQLNodeTraveller<DB extends GenericEntity<Integer>>
extends RSQLNodeTraveller<SortInfo> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Function<RSQLSelectorPath, String> toPath;

    public SortRSQLNodeTraveller(Function<RSQLSelectorPath, String> toPath) {
        this.toPath = toPath;
    }

    @Override
    public SortInfo visit(LogicalNode logicalNode) {
        return null;
    }

    @Override
    public SortInfo visit(ComparisonNode node) {
        SortInfo.SortingDirection sortingDirection;
        ArrayList<String> sortingFields = new ArrayList<String>();
        if (node.getOperator().equals((Object)RSQLProducerImpl.ASC)) {
            sortingDirection = SortInfo.SortingDirection.ASC;
        } else if (node.getOperator().equals((Object)RSQLProducerImpl.DESC)) {
            sortingDirection = SortInfo.SortingDirection.DESC;
        } else {
            throw new UnsupportedOperationException("Unsupported sorting: " + node.getOperator());
        }
        logger.trace("Sorting direction - {}, arguments {}", (Object)sortingDirection, (Object)node.getArguments());
        for (String argument : node.getArguments()) {
            if ("id".equals(argument)) {
                throw new RSQLException("Sorting by id is not supported.");
            }
            sortingFields.add(this.toPath.apply(RSQLSelectorPath.get(argument)));
        }
        return new DefaultSortInfo(sortingDirection, sortingFields);
    }
}

