/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql.converter;

import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Date;
import org.jboss.pnc.facade.rsql.RSQLException;
import org.jboss.pnc.facade.rsql.converter.Value;
import org.jboss.pnc.facade.rsql.converter.ValueConverter;
import org.jboss.pnc.model.GenericEntity;

public class CastValueConverter
implements ValueConverter {
    @Override
    public <DB extends GenericEntity<?>, T> Comparable<T> convertComparable(Value<DB, T> value) {
        Class<T> javaType = value.getJavaType();
        String argument = value.getValue();
        if (javaType.isEnum()) {
            Class<T> enumType = javaType;
            return Enum.valueOf(enumType, argument);
        }
        if (javaType == String.class) {
            return argument;
        }
        if (javaType == Integer.class || javaType == Integer.TYPE) {
            return Integer.valueOf(argument);
        }
        if (javaType == Long.class || javaType == Long.TYPE) {
            return Long.valueOf(argument);
        }
        if (javaType == Boolean.class || javaType == Boolean.TYPE) {
            return Boolean.valueOf(argument);
        }
        if (javaType == Date.class) {
            try {
                DateTimeFormatter timeFormatter = DateTimeFormatter.ISO_DATE_TIME;
                OffsetDateTime offsetDateTime = OffsetDateTime.parse(argument, timeFormatter);
                return Date.from(Instant.from(offsetDateTime));
            }
            catch (DateTimeParseException ex) {
                throw new RSQLException("The datetime must be in the ISO-8601 format with timezone, e.g. 1970-01-01T00:00:00Z, was " + argument, ex);
            }
        }
        throw new UnsupportedOperationException("The target type " + javaType + " is not known to the type converter.");
    }

    @Override
    public <DB extends GenericEntity<?>, T> T convert(Value<DB, T> value) {
        return (T)this.convertComparable(value);
    }
}

