/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.util.Objects;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jboss.pnc.dto.BuildConfigurationRevision;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.facade.providers.api.BuildConfigurationProvider;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class BuildConfigRevisionHelper {
    private final Logger logger = LoggerFactory.getLogger(BuildConfigRevisionHelper.class);
    @Inject
    private BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    private BuildConfigurationRevisionMapper buildConfigurationRevisionMapper;
    @Inject
    private BuildConfigurationProvider buildConfigurationProvider;

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void updateBuildConfiguration(String id, org.jboss.pnc.dto.BuildConfiguration bcEntity) {
        this.buildConfigurationProvider.update(id, bcEntity);
    }

    public BuildConfigurationRevision findRevision(Integer id, org.jboss.pnc.dto.BuildConfiguration bcEntity) {
        return this.buildConfigurationAuditedRepository.findAllByIdOrderByRevDesc(id).stream().peek(p -> this.logger.warn("going through: " + p)).filter(bca -> BuildConfigRevisionHelper.equalValues(bca, bcEntity)).findFirst().map(arg_0 -> ((BuildConfigurationRevisionMapper)this.buildConfigurationRevisionMapper).toDTO(arg_0)).orElseThrow(() -> new IllegalStateException("Couldn't find updated BuildConfigurationAudited entity. BuildConfiguration to be stored: " + bcEntity));
    }

    public static boolean equalValues(BuildConfigurationAudited persisted, org.jboss.pnc.dto.BuildConfiguration query) {
        return Objects.equals(persisted.getName(), query.getName()) && Objects.equals(persisted.getBuildScript(), query.getBuildScript()) && BuildConfigRevisionHelper.equalsId((GenericEntity<Integer>)persisted.getRepositoryConfiguration(), (DTOEntity)query.getScmRepository()) && Objects.equals(persisted.getScmRevision(), query.getScmRevision()) && BuildConfigRevisionHelper.equalsId((GenericEntity<Integer>)persisted.getProject(), (DTOEntity)query.getProject()) && BuildConfigRevisionHelper.equalsId((GenericEntity<Integer>)persisted.getBuildEnvironment(), (DTOEntity)query.getEnvironment()) && Objects.equals(persisted.getGenericParameters(), query.getParameters()) && persisted.getBuildType() == query.getBuildType();
    }

    public static boolean equalValues(BuildConfiguration persisted, org.jboss.pnc.dto.BuildConfiguration query) {
        return Objects.equals(persisted.getName(), query.getName()) && Objects.equals(persisted.getBuildScript(), query.getBuildScript()) && BuildConfigRevisionHelper.equalsId((GenericEntity<Integer>)persisted.getRepositoryConfiguration(), (DTOEntity)query.getScmRepository()) && Objects.equals(persisted.getScmRevision(), query.getScmRevision()) && BuildConfigRevisionHelper.equalsId((GenericEntity<Integer>)persisted.getProject(), (DTOEntity)query.getProject()) && BuildConfigRevisionHelper.equalsId((GenericEntity<Integer>)persisted.getBuildEnvironment(), (DTOEntity)query.getEnvironment()) && Objects.equals(persisted.getGenericParameters(), query.getParameters()) && persisted.getBuildType() == query.getBuildType();
    }

    private static boolean equalsId(GenericEntity<Integer> persisted, DTOEntity toUpdate) {
        if (persisted == null && toUpdate == null) {
            return true;
        }
        if (persisted == null || toUpdate == null) {
            return false;
        }
        return ((Integer)persisted.getId()).toString().equals(toUpdate.getId());
    }
}

