/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.util.List;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.EnvironmentProvider;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.predicates.EnvironmentPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildEnvironmentRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@PermitAll
@Stateless
public class EnvironmentProviderImpl
extends AbstractProvider<Integer, BuildEnvironment, Environment, Environment>
implements EnvironmentProvider {
    @Inject
    public EnvironmentProviderImpl(BuildEnvironmentRepository repository, EnvironmentMapper mapper) {
        super(repository, mapper, BuildEnvironment.class);
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public Environment store(Environment restEntity) throws DTOValidationException {
        return super.store(restEntity);
    }

    @Override
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting Environments is prohibited");
    }

    @Override
    protected void validateBeforeSaving(Environment restEntity) {
        super.validateBeforeSaving(restEntity);
        this.deprecateActiveEnvironmentsWithSameName(restEntity);
    }

    private void deprecateActiveEnvironmentsWithSameName(Environment restEntity) throws ConflictedEntryException {
        List buildEnvironments = this.repository.queryWithPredicates(new Predicate[]{EnvironmentPredicates.withEnvironmentNameAndActive((String)restEntity.getName())});
        for (BuildEnvironment env : buildEnvironments) {
            env.setDeprecated(true);
            this.repository.save((GenericEntity)env);
        }
    }
}

