/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.facade.providers.api.HealthCheckProvider;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.GenericSetting;
import org.jboss.pnc.spi.datastore.repositories.GenericSettingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class HealthCheckProviderImpl
implements HealthCheckProvider {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckProviderImpl.class);
    public static final String HEALTH_CHECK_KEY = "HEALTH_CHECK";
    @Inject
    private GenericSettingRepository genericSettingRepository;

    @Override
    public Map<String, Boolean> check() {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        result.put("check-database-read", this.checkDatabaseRead());
        result.put("check-database-write", this.checkDatabaseWrite());
        return result;
    }

    private boolean checkDatabaseRead() {
        try {
            this.genericSettingRepository.queryAll().size();
            return true;
        }
        catch (Exception e) {
            log.error("Error while reading from database", (Throwable)e);
            return false;
        }
    }

    private boolean checkDatabaseWrite() {
        try {
            GenericSetting healthCheck = this.genericSettingRepository.queryByKey(HEALTH_CHECK_KEY);
            if (healthCheck == null) {
                healthCheck = new GenericSetting();
                healthCheck.setKey(HEALTH_CHECK_KEY);
            }
            healthCheck.setValue(new Date().toString());
            this.genericSettingRepository.save((GenericEntity)healthCheck);
            return true;
        }
        catch (Exception e) {
            log.error("Error while writing to database", (Throwable)e);
            return false;
        }
    }
}

