/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql;

import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.NestedNullException;
import org.jboss.pnc.facade.rsql.RSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.RSQLProducerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StreamRSQLNodeTraveller
extends RSQLNodeTraveller<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Object instance;

    public StreamRSQLNodeTraveller(Object instance) {
        this.instance = instance;
    }

    @Override
    public Boolean visit(LogicalNode node) {
        logger.trace("Parsing LogicalNode {}", (Object)node);
        Iterator iterator = node.iterator();
        if (node instanceof AndNode) {
            boolean result = true;
            while (iterator.hasNext()) {
                Node next = (Node)iterator.next();
                result &= ((Boolean)this.visit(next)).booleanValue();
            }
            return result;
        }
        if (node instanceof OrNode) {
            boolean result = false;
            while (iterator.hasNext()) {
                Node next = (Node)iterator.next();
                result |= ((Boolean)this.visit(next)).booleanValue();
            }
            return result;
        }
        throw new UnsupportedOperationException("Logical operation not supported");
    }

    @Override
    public Boolean visit(ComparisonNode node) {
        logger.trace("Parsing ComparisonNode {}", (Object)node);
        String fieldName = node.getSelector();
        String argument = (String)node.getArguments().get(0);
        try {
            String propertyValue = BeanUtils.getProperty((Object)this.instance, (String)fieldName);
            if (node.getOperator().equals((Object)RSQLProducerImpl.IS_NULL)) {
                return Boolean.valueOf(propertyValue == null).equals(Boolean.valueOf(argument));
            }
            if (propertyValue == null) {
                return false;
            }
            if (node.getOperator().equals((Object)RSQLOperators.EQUAL)) {
                return propertyValue.equals(argument);
            }
            if (node.getOperator().equals((Object)RSQLOperators.NOT_EQUAL)) {
                return !propertyValue.equals(argument);
            }
            if (node.getOperator().equals((Object)RSQLOperators.GREATER_THAN)) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                Number argumentNumber = numberFormat.parse(argument);
                return numberFormat.parse(propertyValue).intValue() > argumentNumber.intValue();
            }
            if (node.getOperator().equals((Object)RSQLOperators.GREATER_THAN_OR_EQUAL)) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                Number argumentNumber = numberFormat.parse(argument);
                return numberFormat.parse(propertyValue).intValue() >= argumentNumber.intValue();
            }
            if (node.getOperator().equals((Object)RSQLOperators.LESS_THAN)) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                Number argumentNumber = numberFormat.parse(argument);
                return numberFormat.parse(propertyValue).intValue() < argumentNumber.intValue();
            }
            if (node.getOperator().equals((Object)RSQLOperators.LESS_THAN_OR_EQUAL)) {
                NumberFormat numberFormat = NumberFormat.getInstance();
                Number argumentNumber = numberFormat.parse(argument);
                return numberFormat.parse(propertyValue).intValue() <= argumentNumber.intValue();
            }
            if (node.getOperator().equals((Object)RSQLProducerImpl.LIKE)) {
                return propertyValue.matches(this.preprocessLikeOperatorArgument(argument));
            }
            if (node.getOperator().equals((Object)RSQLProducerImpl.NOT_LIKE)) {
                return !propertyValue.matches(this.preprocessLikeOperatorArgument(argument));
            }
            if (node.getOperator().equals((Object)RSQLOperators.IN)) {
                return node.getArguments().contains(propertyValue);
            }
            if (node.getOperator().equals((Object)RSQLOperators.NOT_IN)) {
                return !node.getArguments().contains(propertyValue);
            }
            throw new UnsupportedOperationException("Not Implemented yet!");
        }
        catch (NestedNullException e) {
            return false;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("Reflections exception", e);
        }
        catch (ParseException e) {
            throw new IllegalStateException("RSQL parse exception", e);
        }
    }

    private String preprocessLikeOperatorArgument(String argument) {
        return argument.replaceAll(Pattern.quote("%"), ".*").replaceAll(Pattern.quote("*"), ".*").replaceAll(Pattern.quote("?"), ".");
    }
}

