/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.deliverables;

import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jboss.pnc.api.deliverablesanalyzer.dto.ArtifactType;
import org.jboss.pnc.api.deliverablesanalyzer.dto.Build;
import org.jboss.pnc.api.deliverablesanalyzer.dto.FinderResult;
import org.jboss.pnc.api.deliverablesanalyzer.dto.MavenArtifact;
import org.jboss.pnc.api.deliverablesanalyzer.dto.NPMArtifact;
import org.jboss.pnc.api.dto.Request;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.bpm.RestConnector;
import org.jboss.pnc.bpm.model.AnalyzeDeliverablesBpmRequest;
import org.jboss.pnc.bpm.task.AnalyzeDeliverablesTask;
import org.jboss.pnc.common.json.moduleconfig.BpmModuleConfig;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.facade.DeliverableAnalyzerManager;
import org.jboss.pnc.facade.OperationsManager;
import org.jboss.pnc.facade.deliverables.DefaultDeliverableAnalysisStatusChangedEvent;
import org.jboss.pnc.facade.deliverables.DeliverableAnalysisStatusChangedEvent;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.mapper.api.ArtifactMapper;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerOperationMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.DeliverableAnalyzerOperation;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.TargetRepository;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerOperationRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.TargetRepositoryRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.events.OperationChangedEvent;
import org.jboss.pnc.spi.exception.ProcessManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@PermitAll
public class DeliverableAnalyzerManagerImpl
implements DeliverableAnalyzerManager {
    private static final Logger log = LoggerFactory.getLogger(DeliverableAnalyzerManagerImpl.class);
    private static final String KOJI_PATH_MAVEN_PREFIX = "/api/content/maven/remote/koji-";
    public static final String URL_PARAMETER_PREFIX = "url-";
    @Inject
    private ProductMilestoneRepository milestoneRepository;
    @Inject
    private ArtifactRepository artifactRepository;
    @Inject
    private TargetRepositoryRepository targetRepositoryRepository;
    @Inject
    private DeliverableAnalyzerOperationRepository deliverableAnalyzerOperationRepository;
    @Inject
    private ArtifactMapper artifactMapper;
    @Inject
    private OperationsManager operationsManager;
    @Inject
    private UserService userService;
    @Inject
    private BpmModuleConfig bpmConfig;
    @Inject
    private DeliverableAnalyzerOperationMapper deliverableAnalyzerOperationMapper;
    @Inject
    private Event<DeliverableAnalysisStatusChangedEvent> analysisStatusChangedEventNotifier;

    @Override
    public org.jboss.pnc.dto.DeliverableAnalyzerOperation analyzeDeliverables(String id, List<String> deliverablesUrls) {
        int i = 1;
        HashMap<String, String> inputParams = new HashMap<String, String>();
        for (String url : deliverablesUrls) {
            inputParams.put(URL_PARAMETER_PREFIX + i++, url);
        }
        Base32LongID operationId = this.operationsManager.newDeliverableAnalyzerOperation(id, inputParams).getId();
        try {
            log.info("Starting analysis of deliverables for milestone {} from urls: {}.", (Object)id, deliverablesUrls);
            this.startAnalysis(id, deliverablesUrls, operationId);
            return this.deliverableAnalyzerOperationMapper.toDTO((DeliverableAnalyzerOperation)this.operationsManager.updateProgress(operationId, ProgressStatus.IN_PROGRESS));
        }
        catch (RuntimeException ex) {
            this.operationsManager.setResult(operationId, OperationResult.SYSTEM_ERROR);
            throw ex;
        }
    }

    private void processDeliverables(int milestoneId, Collection<Build> builds, String distributionUrl, Collection<org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact> notFoundArtifacts) {
        log.debug("Processing deliverables of milestone {} in {} builds. Distribution URL: {}", new Object[]{milestoneId, builds.size(), distributionUrl});
        ProductMilestone milestone = (ProductMilestone)this.milestoneRepository.queryById((Serializable)Integer.valueOf(milestoneId));
        Consumer<Artifact> artifactUpdater = this.artifactUpdater("Added as delivered artifact for milestone " + milestoneId);
        ArtifactStats stats = new ArtifactStats();
        for (Build build : builds) {
            Function<org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact, Artifact> artifactParser;
            Consumer<org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact> statCounter;
            log.debug("Processing build {}", (Object)build);
            if (build.getBuildSystemType() == null) {
                throw new IllegalArgumentException("Build system type not set.");
            }
            switch (build.getBuildSystemType()) {
                case PNC: {
                    statCounter = stats.pncCounter();
                    artifactParser = this::getPncArtifact;
                    break;
                }
                case BREW: {
                    statCounter = stats.brewCounter();
                    TargetRepository brewRepository = this.getBrewRepository(build);
                    artifactParser = art -> this.findOrCreateArtifact(this.assertBrewArtifacts((org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact)art), brewRepository);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown build system type " + build.getBuildSystemType());
                }
            }
            build.getArtifacts().stream().peek(statCounter).map(artifactParser).peek(artifactUpdater).forEach(arg_0 -> ((ProductMilestone)milestone).addDeliveredArtifact(arg_0));
        }
        if (!notFoundArtifacts.isEmpty()) {
            TargetRepository distributionRepository = this.getDistributionRepository(distributionUrl);
            stats.notFoundArtifactsCount = notFoundArtifacts.size();
            notFoundArtifacts.stream().map(art -> this.findOrCreateArtifact((org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact)art, distributionRepository)).peek(artifactUpdater).forEach(arg_0 -> ((ProductMilestone)milestone).addDeliveredArtifact(arg_0));
        }
        stats.log(distributionUrl);
        milestone.setDeliveredArtifactsImporter(this.userService.currentUser());
    }

    public Consumer<Artifact> artifactUpdater(String message) {
        User user = this.userService.currentUser();
        return a -> {
            a.setQualityLevelReason(message);
            a.setModificationUser(user);
            a.setModificationTime(new Date());
        };
    }

    @Override
    @Transactional
    public void completeAnalysis(int milestoneId, List<FinderResult> results) {
        log.info("Processing deliverables of milestone {} in {} results.", (Object)milestoneId, (Object)results.size());
        for (FinderResult finderResult : results) {
            this.processDeliverables(milestoneId, finderResult.getBuilds(), finderResult.getUrl().toString(), finderResult.getNotFoundArtifacts());
        }
    }

    @Override
    @RolesAllowed(value={"system-user"})
    @Transactional
    public void clear(int id) {
        ProductMilestone milestone = (ProductMilestone)this.milestoneRepository.queryById((Serializable)Integer.valueOf(id));
        milestone.getDeliveredArtifacts().forEach(this.artifactUpdater("Removed from deliverables of milestone " + id));
        milestone.getDeliveredArtifacts().clear();
    }

    private Artifact findOrCreateArtifact(org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact art, TargetRepository targetRepo) {
        Artifact artifact = this.mapArtifact(art);
        Artifact dbArtifact = (Artifact)this.artifactRepository.queryByPredicates(new Predicate[]{ArtifactPredicates.withIdentifierAndSha256((String)artifact.getIdentifier(), (String)artifact.getSha256()), ArtifactPredicates.withTargetRepositoryId((Integer)targetRepo.getId())});
        if (dbArtifact != null) {
            return dbArtifact;
        }
        artifact.setTargetRepository(targetRepo);
        Artifact savedArtifact = (Artifact)this.artifactRepository.save((GenericEntity)artifact);
        targetRepo.getArtifacts().add(savedArtifact);
        return savedArtifact;
    }

    private Artifact getPncArtifact(org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact art) {
        Artifact artifact = (Artifact)this.artifactRepository.queryById((Serializable)((Integer)this.artifactMapper.getIdMapper().toEntity((Object)art.getPncId())));
        if (artifact == null) {
            throw new IllegalArgumentException("PNC artifact with id " + art.getPncId() + " doesn't exist.");
        }
        return artifact;
    }

    private Artifact mapArtifact(org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact art) {
        Artifact.Builder builder = Artifact.builder();
        builder.md5(art.getMd5());
        builder.sha1(art.getSha1());
        builder.sha256(art.getSha256());
        builder.size(Long.valueOf(art.getSize()));
        if (art.getArtifactType() == null) {
            Path path = Paths.get(art.getFilename(), new String[0]);
            builder.filename(path.getFileName().toString());
            builder.identifier(art.getFilename());
            Path directory = path.getParent();
            builder.deployPath(directory == null ? null : directory.toString());
        } else {
            builder.filename(art.getFilename());
            switch (art.getArtifactType()) {
                case MAVEN: {
                    builder.identifier(this.fill((MavenArtifact)art));
                    break;
                }
                case NPM: {
                    builder.identifier(this.fill((NPMArtifact)art));
                }
            }
        }
        if (art.isBuiltFromSource()) {
            builder.artifactQuality(ArtifactQuality.NEW);
        } else {
            builder.artifactQuality(ArtifactQuality.IMPORTED);
        }
        return builder.build();
    }

    private String fill(MavenArtifact mavenArtifact) {
        return Arrays.asList(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getType(), mavenArtifact.getVersion(), mavenArtifact.getClassifier()).stream().filter(Objects::nonNull).collect(Collectors.joining(":"));
    }

    private String fill(NPMArtifact mavenArtifact) {
        return mavenArtifact.getName() + ":" + mavenArtifact.getVersion();
    }

    private TargetRepository getBrewRepository(Build build) {
        String path = KOJI_PATH_MAVEN_PREFIX + build.getBrewNVR();
        TargetRepository tr = this.targetRepositoryRepository.queryByIdentifierAndPath("indy-maven", path);
        if (tr == null) {
            tr = this.createRepository(path, "indy-maven", RepositoryType.MAVEN);
        }
        return tr;
    }

    private TargetRepository getDistributionRepository(String distURL) {
        TargetRepository tr = this.targetRepositoryRepository.queryByIdentifierAndPath("distribution-archive", distURL);
        if (tr == null) {
            tr = this.createRepository(distURL, "distribution-archive", RepositoryType.DISTRIBUTION_ARCHIVE);
        }
        return tr;
    }

    private TargetRepository createRepository(String path, String identifier, RepositoryType type) {
        TargetRepository tr = TargetRepository.newBuilder().temporaryRepo(Boolean.valueOf(false)).identifier(identifier).repositoryPath(path).repositoryType(type).build();
        return (TargetRepository)this.targetRepositoryRepository.save((GenericEntity)tr);
    }

    private org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact assertBrewArtifacts(org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact artifact) {
        if (artifact.getArtifactType() != null && artifact.getArtifactType() != ArtifactType.MAVEN) {
            throw new IllegalArgumentException("Brew artifacts are expected to be either MAVEN or unknown, artifact " + artifact + " is " + artifact.getArtifactType());
        }
        return artifact;
    }

    private void startAnalysis(String milestoneId, List<String> deliverablesUrls, Base32LongID operationId) {
        Request callback = this.operationsManager.getOperationCallback(operationId);
        String id = operationId.getId();
        try (RestConnector restConnector = new RestConnector(this.bpmConfig);){
            AnalyzeDeliverablesBpmRequest bpmRequest = new AnalyzeDeliverablesBpmRequest(id, milestoneId, deliverablesUrls);
            AnalyzeDeliverablesTask analyzeTask = new AnalyzeDeliverablesTask(bpmRequest, callback);
            restConnector.startProcess(this.bpmConfig.getAnalyzeDeliverablesBpmProcessId(), (Object)analyzeTask, id, this.userService.currentUserToken());
            DefaultDeliverableAnalysisStatusChangedEvent analysisStatusChanged = DefaultDeliverableAnalysisStatusChangedEvent.started(id, milestoneId, deliverablesUrls);
            this.analysisStatusChangedEventNotifier.fire((Object)analysisStatusChanged);
        }
        catch (ProcessManagerException e) {
            log.error("Error trying to start analysis of deliverables task for milestone: {}", (Object)milestoneId, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void observeEvent(@Observes OperationChangedEvent event) {
        if (event.getOperationClass() != DeliverableAnalyzerOperation.class) {
            return;
        }
        log.debug("Observed deliverable analysis operation status changed event {}.", (Object)event);
        if (event.getStatus() == ProgressStatus.FINISHED && event.getPreviousStatus() != ProgressStatus.FINISHED) {
            DeliverableAnalyzerOperation operation = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.queryById((Serializable)event.getId());
            this.onDeliverableAnalysisFinished(operation);
        }
    }

    private void onDeliverableAnalysisFinished(DeliverableAnalyzerOperation operation) {
        List<String> deliverablesUrls = operation.getOperationParameters().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(URL_PARAMETER_PREFIX)).map(Map.Entry::getValue).collect(Collectors.toList());
        DefaultDeliverableAnalysisStatusChangedEvent analysisStatusChanged = DefaultDeliverableAnalysisStatusChangedEvent.finished(operation.getId().getId(), operation.getProductMilestone().getId().toString(), operation.getResult(), deliverablesUrls);
        this.analysisStatusChangedEventNotifier.fire((Object)analysisStatusChanged);
    }

    private class ArtifactStats {
        int totalArtifacts = 0;
        int pncArtifactsCount = 0;
        int pncNotBuiltArtifactsCount = 0;
        int brewArtifactsCount = 0;
        int brewNotBuiltArtifactsCount = 0;
        int notFoundArtifactsCount = 0;

        private ArtifactStats() {
        }

        public Consumer<org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact> pncCounter() {
            return a -> {
                ++this.totalArtifacts;
                ++this.pncArtifactsCount;
                if (!a.isBuiltFromSource()) {
                    ++this.pncNotBuiltArtifactsCount;
                }
            };
        }

        public Consumer<org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact> brewCounter() {
            return a -> {
                ++this.totalArtifacts;
                ++this.brewArtifactsCount;
                if (!a.isBuiltFromSource()) {
                    ++this.brewNotBuiltArtifactsCount;
                }
            };
        }

        public void log(String distributionUrl) {
            log.info("Processed {} artifacts from deliverables at {}: ", (Object)this.totalArtifacts, (Object)distributionUrl);
            log.info("  PNC artifacts: {} ({} artifacts not built from source), BREW artifacts: {} ({} artifacts not built from source), not found artifacts: {} ", new Object[]{this.pncArtifactsCount, this.pncNotBuiltArtifactsCount, this.brewArtifactsCount, this.brewNotBuiltArtifactsCount, this.notFoundArtifactsCount});
            int totalNotBuild = this.pncNotBuiltArtifactsCount + this.brewNotBuiltArtifactsCount + this.notFoundArtifactsCount;
            if (totalNotBuild > 0) {
                log.info("  There are total {} artifacts not built from source!", (Object)totalNotBuild);
            }
        }
    }
}

