/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.ProductVersionProvider;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.spi.datastore.predicates.ProductVersionPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductVersionRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class ProductVersionProviderImpl
extends AbstractUpdatableProvider<Integer, ProductVersion, org.jboss.pnc.dto.ProductVersion, ProductVersionRef>
implements ProductVersionProvider {
    private static final Logger log = LoggerFactory.getLogger(ProductVersionProviderImpl.class);
    private ProductRepository productRepository;
    private ProductMilestoneRepository milestoneRepository;
    private BuildConfigurationSetRepository groupConfigRepository;
    private SystemConfig systemConfig;
    private BuildConfigurationRepository buildConfigurationRepository;
    private ProductMilestoneMapper milestoneMapper;

    @Inject
    public ProductVersionProviderImpl(ProductVersionRepository repository, ProductVersionMapper mapper, ProductMilestoneMapper milestoneMapper, ProductRepository productRepository, ProductMilestoneRepository milestoneRepository, BuildConfigurationSetRepository groupConfigRepository, BuildConfigurationRepository buildConfigurationRepository, SystemConfig systemConfig) {
        super(repository, mapper, ProductVersion.class);
        this.milestoneMapper = milestoneMapper;
        this.productRepository = productRepository;
        this.groupConfigRepository = groupConfigRepository;
        this.systemConfig = systemConfig;
        this.buildConfigurationRepository = buildConfigurationRepository;
        this.milestoneRepository = milestoneRepository;
    }

    @Override
    public org.jboss.pnc.dto.ProductVersion store(org.jboss.pnc.dto.ProductVersion restEntity) {
        this.validateBeforeSaving(restEntity);
        ProductVersion productVersionRestDb = (ProductVersion)this.mapper.toEntity((DTOEntity)restEntity);
        Product product = (Product)this.productRepository.queryById((Serializable)Integer.valueOf(restEntity.getProduct().getId()));
        productVersionRestDb.generateBrewTagPrefix(product.getAbbreviation(), restEntity.getVersion(), this.systemConfig.getBrewTagPattern());
        ProductVersion productVersion = (ProductVersion)this.repository.save((GenericEntity)productVersionRestDb);
        for (BuildConfiguration bc : productVersionRestDb.getBuildConfigurations()) {
            bc.setProductVersion(productVersion);
        }
        this.repository.flushAndRefresh((GenericEntity)productVersion);
        return (org.jboss.pnc.dto.ProductVersion)this.mapper.toDTO((GenericEntity)productVersion);
    }

    @Override
    protected void validateBeforeSaving(org.jboss.pnc.dto.ProductVersion restEntity) {
        super.validateBeforeSaving(restEntity);
        Product product = (Product)this.productRepository.queryById((Serializable)Integer.valueOf(restEntity.getProduct().getId()));
        if (product == null) {
            throw new InvalidEntityException("Product with id: " + restEntity.getProduct().getId() + " does not exist.");
        }
        Set productVersionList = product.getProductVersions();
        if (productVersionList == null) {
            return;
        }
        productVersionList.stream().filter(pv -> pv.getVersion().equals(restEntity.getVersion())).findFirst().ifPresent(pv -> {
            throw new ConflictedEntryException("Product version with version " + restEntity.getVersion() + " already exists", ProductVersion.class, pv.getId().toString());
        });
    }

    @Override
    protected void validateBeforeUpdating(Integer id, org.jboss.pnc.dto.ProductVersion restEntity) {
        super.validateBeforeUpdating(id, restEntity);
        this.validateVersionChange(id, restEntity);
        this.validateGroupConfigsBeforeUpdating(id, restEntity);
        this.validateMilestone(id, restEntity);
    }

    private void validateVersionChange(Integer id, org.jboss.pnc.dto.ProductVersion restEntity) throws InvalidEntityException {
        boolean hasClosedMilestone;
        boolean changingVersion;
        ProductVersion entityInDb = (ProductVersion)this.findInDB(id);
        boolean bl = changingVersion = !entityInDb.getVersion().equals(restEntity.getVersion());
        if (changingVersion && (hasClosedMilestone = entityInDb.getProductMilestones().stream().anyMatch(milestone -> milestone.getEndDate() != null))) {
            throw new InvalidEntityException("Cannot change version due to having closed milestone. Product version id: " + id);
        }
    }

    private void validateGroupConfigsBeforeUpdating(Integer id, org.jboss.pnc.dto.ProductVersion restEntity) throws InvalidEntityException, NumberFormatException, ConflictedEntryException {
        if (restEntity.getGroupConfigs() != null) {
            for (String groupConfigId : restEntity.getGroupConfigs().keySet()) {
                BuildConfigurationSet set = (BuildConfigurationSet)this.groupConfigRepository.queryById((Serializable)Integer.valueOf(groupConfigId));
                if (set == null) {
                    throw new InvalidEntityException("Group config with id: " + groupConfigId + " does not exist.");
                }
                if (set.getProductVersion() == null || set.getProductVersion().getId().equals(id)) continue;
                throw new ConflictedEntryException("Group config with id: " + groupConfigId + " already belongs to different product version.", ProductVersion.class, set.getProductVersion().getId().toString());
            }
        }
    }

    private void validateMilestone(Integer id, org.jboss.pnc.dto.ProductVersion entity) {
        if (entity.getCurrentProductMilestone() != null) {
            Integer newMilestoneId = (Integer)this.milestoneMapper.getIdMapper().toEntity((Object)entity.getCurrentProductMilestone().getId());
            ProductVersion productVersion = (ProductVersion)this.repository.queryById((Serializable)id);
            ProductMilestone currentMilestone = productVersion.getCurrentProductMilestone();
            if (currentMilestone == null || currentMilestone.getId() != newMilestoneId) {
                ProductMilestone newMilestone = (ProductMilestone)this.milestoneRepository.queryById((Serializable)newMilestoneId);
                if (newMilestone == null) {
                    throw new InvalidEntityException("Milestone with id: " + newMilestoneId + " does not exist.");
                }
                if (newMilestone.getEndDate() != null) {
                    throw new InvalidEntityException("Milestone with id: " + newMilestoneId + " is closed, so cannot be set as current.");
                }
            }
        }
    }

    @Override
    public Page<org.jboss.pnc.dto.ProductVersion> getAllForProduct(int pageIndex, int pageSize, String sortingRsql, String query, String productId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ProductVersionPredicates.withProductId((Integer)Integer.valueOf(productId)));
    }
}

