/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.util.ArrayList;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.dto.ProductMilestoneCloseResult;
import org.jboss.pnc.dto.ProductMilestoneCloseResultRef;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.enums.MilestoneCloseStatus;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.ProductMilestoneCloseResultProvider;
import org.jboss.pnc.mapper.api.ProductMilestoneCloseResultMapper;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductMilestoneRelease;
import org.jboss.pnc.spi.datastore.predicates.ProductMilestoneReleasePredicates;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneReleaseRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class ProductMilestoneCloseResultProviderImpl
extends AbstractProvider<Long, ProductMilestoneRelease, ProductMilestoneCloseResult, ProductMilestoneCloseResultRef>
implements ProductMilestoneCloseResultProvider {
    private static final Logger log = LoggerFactory.getLogger(ProductMilestoneCloseResultProviderImpl.class);
    private ProductMilestoneReleaseRepository repository;

    @Inject
    public ProductMilestoneCloseResultProviderImpl(ProductMilestoneReleaseRepository repository, ProductMilestoneCloseResultMapper mapper) {
        super(repository, mapper, ProductMilestoneRelease.class);
        this.repository = repository;
    }

    @Override
    public ProductMilestoneCloseResult getLatestProductMilestoneCloseResult(int milestoneId) {
        ProductMilestoneRelease entity = this.repository.findLatestByMilestone(ProductMilestone.Builder.newBuilder().id(Integer.valueOf(milestoneId)).build());
        return (ProductMilestoneCloseResult)this.mapper.toDTO((GenericEntity)entity);
    }

    @Override
    public Page<ProductMilestoneCloseResult> getProductMilestoneCloseResults(int pageIndex, int pageSize, String sortingRsql, String query, int milestoneId, boolean latest, boolean runningOnly) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        predicates.add(ProductMilestoneReleasePredicates.withMilestoneId((Integer)milestoneId));
        if (runningOnly) {
            predicates.add(ProductMilestoneReleasePredicates.withStatus((MilestoneCloseStatus)MilestoneCloseStatus.IN_PROGRESS));
        }
        if (StringUtils.isEmpty((String)sortingRsql)) {
            log.debug("No sort provided, using the default 'ASC by startingDate'.");
            sortingRsql = "sort=asc=startingDate";
        }
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, predicates.toArray(new Predicate[predicates.size()]));
    }
}

