/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.util.Collections;
import java.util.Set;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.dto.TargetRepository;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.TargetRepositoryProvider;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.mapper.api.TargetRepositoryMapper;
import org.jboss.pnc.model.TargetRepository;
import org.jboss.pnc.spi.datastore.predicates.TargetRepositoryPredicates;
import org.jboss.pnc.spi.datastore.repositories.TargetRepositoryRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@PermitAll
@Stateless
public class TargetRepositoryProviderImpl
extends AbstractProvider<Integer, org.jboss.pnc.model.TargetRepository, TargetRepository, TargetRepository>
implements TargetRepositoryProvider {
    @Inject
    public TargetRepositoryProviderImpl(TargetRepositoryRepository repository, TargetRepositoryMapper mapper) {
        super(repository, mapper, org.jboss.pnc.model.TargetRepository.class);
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public TargetRepository store(TargetRepository restEntity) throws DTOValidationException {
        return super.store(restEntity);
    }

    @Override
    protected void validateBeforeSaving(TargetRepository projectRest) {
        super.validateBeforeSaving(projectRest);
        this.validateIfNotConflicted(projectRest);
    }

    @Override
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting target repositories is prohibited!");
    }

    private void validateIfNotConflicted(TargetRepository targetRepositoryRest) throws ConflictedEntryException {
        Set<TargetRepository.IdentifierPath> identifierAndPath = Collections.singleton(new TargetRepository.IdentifierPath(targetRepositoryRest.getIdentifier(), targetRepositoryRest.getRepositoryPath()));
        org.jboss.pnc.model.TargetRepository targetRepository = (org.jboss.pnc.model.TargetRepository)this.repository.queryByPredicates(new Predicate[]{TargetRepositoryPredicates.withIdentifierAndPathIn(identifierAndPath)});
        Integer targetRepositoryId = null;
        if (targetRepositoryRest.getId() != null) {
            targetRepositoryId = Integer.valueOf(targetRepositoryRest.getId());
        }
        if (targetRepository != null && !targetRepository.getId().equals(targetRepositoryId)) {
            throw new ConflictedEntryException("Target Repository of that identifier and path already exists", org.jboss.pnc.model.TargetRepository.class, targetRepository.getIdentifierPath().toString());
        }
    }
}

