/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.impl;

import com.google.common.base.Preconditions;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.stream.Collectors;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.common.logging.BuildTaskContext;
import org.jboss.pnc.common.util.StreamHelper;
import org.jboss.pnc.dto.BuildConfigurationRevisionRef;
import org.jboss.pnc.dto.requests.GroupBuildRequest;
import org.jboss.pnc.facade.BuildTriggerer;
import org.jboss.pnc.facade.providers.GenericSettingProvider;
import org.jboss.pnc.facade.util.HibernateLazyInitializer;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.spi.BuildOptions;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.coordinator.BuildSetTask;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.exception.BuildConflictException;
import org.jboss.pnc.spi.exception.BuildRequestException;
import org.jboss.pnc.spi.exception.CoreException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Stateless
public class BuildTriggererImpl
implements BuildTriggerer {
    private static final Logger logger = LoggerFactory.getLogger(BuildTriggererImpl.class);
    @Inject
    private UserService user;
    @Inject
    private BuildCoordinator buildCoordinator;
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    private BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    @Inject
    private BuildConfigurationSetRepository buildConfigurationSetRepository;
    @Inject
    private HibernateLazyInitializer hibernateLazyInitializer;
    @Inject
    GenericSettingProvider genericSettingProvider;

    @Override
    public String triggerBuild(int buildConfigId, OptionalInt buildConfigurationRevision, BuildOptions buildOptions) throws BuildConflictException, CoreException, BuildRequestException {
        this.throwCoreExceptionIfInMaintenanceModeAndNonSystemUser();
        BuildSetTask result = this.doTriggerBuild(buildConfigId, buildConfigurationRevision, buildOptions);
        return this.selectBuildRecordIdOf(result.getBuildTasks(), buildConfigId);
    }

    @Override
    public long triggerGroupBuild(int groupConfigId, Optional<GroupBuildRequest> revs, BuildOptions buildOptions) throws BuildConflictException, CoreException, BuildRequestException {
        this.throwCoreExceptionIfInMaintenanceModeAndNonSystemUser();
        BuildSetTask result = this.doTriggerGroupBuild(groupConfigId, revs, buildOptions);
        return ((BuildConfigSetRecord)result.getBuildConfigSetRecord().get()).getId();
    }

    @Override
    public boolean cancelBuild(String buildId) throws CoreException {
        return this.buildCoordinator.cancel(buildId);
    }

    @Override
    public Optional<BuildTaskContext> getMdcMeta(String buildId) {
        return this.buildCoordinator.getMDCMeta(buildId);
    }

    private BuildSetTask doTriggerBuild(int buildConfigId, OptionalInt buildConfigurationRevision, BuildOptions buildOptions) throws BuildConflictException, CoreException, BuildRequestException {
        BuildSetTask buildSetTask;
        if (buildConfigurationRevision.isPresent()) {
            BuildConfigurationAudited buildConfigurationAudited = this.buildConfigurationAuditedRepository.queryById(new IdRev(Integer.valueOf(buildConfigId), Integer.valueOf(buildConfigurationRevision.getAsInt())));
            Preconditions.checkArgument((buildConfigurationAudited != null ? 1 : 0) != 0, (Object)("Can't find Build Configuration with id=" + buildConfigId + ", rev=" + buildConfigurationRevision.getAsInt()));
            buildSetTask = this.buildCoordinator.buildConfigurationAudited(this.hibernateLazyInitializer.initializeBuildConfigurationAuditedBeforeTriggeringIt(buildConfigurationAudited), this.user.currentUser(), buildOptions);
        } else {
            BuildConfiguration buildConfiguration = (BuildConfiguration)this.buildConfigurationRepository.queryById((Serializable)Integer.valueOf(buildConfigId));
            Preconditions.checkArgument((buildConfiguration != null ? 1 : 0) != 0, (Object)("Can't find Build Configuration with id=" + buildConfigId));
            buildSetTask = this.buildCoordinator.buildConfig(this.hibernateLazyInitializer.initializeBuildConfigurationBeforeTriggeringIt(buildConfiguration), this.user.currentUser(), buildOptions);
        }
        logger.info("Started build of Build Configuration {}. Build Tasks: {}", (Object)buildConfigId, (Object)buildSetTask.getBuildTasks().stream().map(BuildTask::getId).collect(Collectors.joining()));
        return buildSetTask;
    }

    private BuildSetTask doTriggerGroupBuild(int groupConfigId, Optional<GroupBuildRequest> revs, BuildOptions buildOptions) throws CoreException, BuildRequestException, BuildConflictException {
        BuildConfigurationSet buildConfigurationSet = (BuildConfigurationSet)this.buildConfigurationSetRepository.queryById((Serializable)Integer.valueOf(groupConfigId));
        Preconditions.checkArgument((buildConfigurationSet != null ? 1 : 0) != 0, (Object)("Can't find configuration with given id=" + groupConfigId));
        List<BuildConfigurationRevisionRef> revisions = revs.map(GroupBuildRequest::getBuildConfigurationRevisions).orElse(Collections.emptyList());
        BuildSetTask buildSetTask = this.buildCoordinator.buildSet(this.hibernateLazyInitializer.initializeBuildConfigurationSetBeforeTriggeringIt(buildConfigurationSet), this.loadAuditedsFromDB(buildConfigurationSet, revisions), this.user.currentUser(), buildOptions);
        logger.info("Started build of Group Configuration {}. Build Tasks: {}", (Object)groupConfigId, (Object)buildSetTask.getBuildTasks().stream().map(BuildTask::getId).collect(Collectors.joining()));
        return buildSetTask;
    }

    private Map<Integer, BuildConfigurationAudited> loadAuditedsFromDB(BuildConfigurationSet buildConfigurationSet, List<BuildConfigurationRevisionRef> buildConfigurationAuditedRests) throws InvalidEntityException {
        HashMap<Integer, BuildConfigurationAudited> buildConfigurationAuditedsMap = new HashMap<Integer, BuildConfigurationAudited>();
        Set buildConfigurationAuditedRevs = StreamHelper.nullableStreamOf(buildConfigurationAuditedRests).map(bcrRef -> new IdRev(Integer.valueOf(bcrRef.getId()), bcrRef.getRev())).collect(Collectors.toSet());
        if (!buildConfigurationAuditedRevs.isEmpty()) {
            Map buildConfigurationsAuditedMap = this.buildConfigurationAuditedRepository.queryById(buildConfigurationAuditedRevs);
            for (BuildConfigurationRevisionRef bc : buildConfigurationAuditedRests) {
                BuildConfigurationAudited buildConfigurationAudited = (BuildConfigurationAudited)buildConfigurationsAuditedMap.get(new IdRev(Integer.valueOf(bc.getId()), bc.getRev()));
                Preconditions.checkArgument((buildConfigurationAudited != null ? 1 : 0) != 0, (Object)("Can't find Build Configuration with id=" + bc.getId() + ", rev=" + bc.getRev()));
                buildConfigurationAudited = this.hibernateLazyInitializer.initializeBuildConfigurationAuditedBeforeTriggeringIt(buildConfigurationAudited);
                if (!buildConfigurationSet.getBuildConfigurations().contains(buildConfigurationAudited.getBuildConfiguration())) {
                    throw new InvalidEntityException("BuildConfigurationSet " + buildConfigurationSet + " doesn't contain this BuildConfigurationAudited entity " + buildConfigurationAudited);
                }
                buildConfigurationAuditedsMap.put(buildConfigurationAudited.getId(), buildConfigurationAudited);
            }
        }
        return buildConfigurationAuditedsMap;
    }

    private String selectBuildRecordIdOf(Collection<BuildTask> buildTasks, int buildConfigId) throws CoreException {
        return buildTasks.stream().filter(t -> t.getBuildConfigurationAudited().getBuildConfiguration().getId().equals(buildConfigId)).map(BuildTask::getId).findAny().orElseThrow(() -> new CoreException("No build id for the triggered configuration"));
    }

    private void throwCoreExceptionIfInMaintenanceModeAndNonSystemUser() throws BuildConflictException {
        if (!this.genericSettingProvider.isCurrentUserAllowedToTriggerBuilds()) {
            String reason = this.genericSettingProvider.getAnnouncementBanner();
            if (reason == null) {
                reason = "";
            }
            throw new BuildConflictException("PNC is in maintenance mode: " + reason);
        }
    }
}

