/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.util.function.Consumer;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.jboss.pnc.common.util.HttpUtils;
import org.jboss.pnc.coordinator.maintenance.TemporaryBuildsCleanerAsyncInvoker;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.GroupBuildRef;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.GroupBuildProvider;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.mapper.api.ResultMapper;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.coordinator.Result;
import org.jboss.pnc.spi.datastore.predicates.BuildConfigSetRecordPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.exception.CoreException;
import org.jboss.pnc.spi.exception.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class GroupBuildProviderImpl
extends AbstractProvider<Long, BuildConfigSetRecord, GroupBuild, GroupBuildRef>
implements GroupBuildProvider {
    private static final Logger logger = LoggerFactory.getLogger(GroupBuildProviderImpl.class);
    @Inject
    private BuildConfigurationSetRepository buildConfigSetRecordRepository;
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    private TemporaryBuildsCleanerAsyncInvoker temporaryBuildsCleanerAsyncInvoker;
    @Inject
    private BuildCoordinator buildCoordinator;
    @Context
    private HttpServletRequest httpServletRequest;
    private UserService userService;
    private ResultMapper resultMapper;

    @Inject
    public GroupBuildProviderImpl(BuildConfigSetRecordRepository repository, GroupBuildMapper mapper, UserService userService, ResultMapper resultMapper) {
        super(repository, mapper, BuildConfigSetRecord.class);
        this.userService = userService;
        this.resultMapper = resultMapper;
    }

    @Override
    public GroupBuild store(GroupBuild restEntity) throws DTOValidationException {
        throw new UnsupportedOperationException("Direct GroupBuilds creation is not available.");
    }

    @Override
    @RolesAllowed(value={"system-user"})
    public GroupBuild update(String id, GroupBuild restEntity) {
        return super.update(id, restEntity);
    }

    @Override
    public boolean delete(String id, String callback) {
        User user = this.userService.currentUser();
        if (user == null) {
            throw new RuntimeException("Failed to load user metadata.");
        }
        try {
            return this.temporaryBuildsCleanerAsyncInvoker.deleteTemporaryBuildConfigSetRecord(Long.valueOf(id), user.getLoginToken(), this.notifyOnDeletionCompletion(callback));
        }
        catch (ValidationException e) {
            throw new RepositoryViolationException(e);
        }
    }

    private Consumer<Result> notifyOnDeletionCompletion(String callbackUrl) {
        return result -> {
            if (callbackUrl != null && !callbackUrl.isEmpty()) {
                try {
                    HttpUtils.performHttpPostRequest((String)callbackUrl, (Object)this.resultMapper.toDTO(result));
                }
                catch (JsonProcessingException e) {
                    logger.error("Failed to perform a callback of BuildConfigSetRecord delete operation.", (Throwable)e);
                }
            }
        };
    }

    @Override
    public Page<GroupBuild> getGroupBuilds(int pageIndex, int pageSize, String sort, String q, String groupConfigurationId) {
        return this.queryForCollection(pageIndex, pageSize, sort, q, BuildConfigSetRecordPredicates.withBuildConfigSetId((Integer)Integer.valueOf(groupConfigurationId)));
    }

    @Override
    public void cancel(String id) {
        try {
            this.buildCoordinator.cancelSet(Long.parseLong(id));
        }
        catch (CoreException e) {
            throw new RuntimeException("Error when canceling buildConfigSetRecord with id: " + id, e);
        }
    }
}

