/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NativeQueryBuilder {
    private final List<String> selects = new ArrayList<String>();
    private final List<String> froms = new ArrayList<String>();
    private final List<String> joins = new ArrayList<String>();
    private final List<String> wheres = new ArrayList<String>();
    private final List<String> orderBys = new ArrayList<String>();
    private Integer limit;
    private Integer offset;

    private NativeQueryBuilder() {
    }

    public NativeQueryBuilder select(String field) {
        this.selects.add(field);
        return this;
    }

    public NativeQueryBuilder select(String table, String field) {
        this.selects.add(NativeQueryBuilder.table(table) + field);
        return this;
    }

    public NativeQueryBuilder select(String table, String field, String alias) {
        this.selects.add(NativeQueryBuilder.table(table) + field + NativeQueryBuilder.alias(alias));
        return this;
    }

    public NativeQueryBuilder requiresSelect(String table, String field, String alias) {
        String selectClause = NativeQueryBuilder.table(table) + field + NativeQueryBuilder.alias(alias);
        if (!this.selects.contains(selectClause)) {
            this.selects.add(selectClause);
        }
        return this;
    }

    private static String table(String table) {
        return table == null || table.isEmpty() ? "" : table + ".";
    }

    private static String alias(String alias) {
        return alias == null || alias.isEmpty() ? "" : " AS " + alias;
    }

    public NativeQueryBuilder from(String table) {
        this.froms.add(table);
        return this;
    }

    public NativeQueryBuilder from(String table, String alias) {
        this.froms.add(table + NativeQueryBuilder.alias(alias));
        return this;
    }

    public NativeQueryBuilder join(String joinType, String table, String alias, String onClause) {
        this.joins.add(joinType + " JOIN " + table + NativeQueryBuilder.alias(alias) + NativeQueryBuilder.on(onClause));
        return this;
    }

    private static String on(String onClause) {
        return onClause == null || onClause.isBlank() ? "" : " ON " + onClause;
    }

    public NativeQueryBuilder requiresJoin(String joinType, String table, String alias, String onClause) {
        String joinClause = joinType + " JOIN " + table + NativeQueryBuilder.alias(alias) + NativeQueryBuilder.on(onClause);
        if (!this.joins.contains(joinClause)) {
            this.joins.add(joinClause);
        }
        return this;
    }

    public NativeQueryBuilder where(String condition) {
        this.wheres.add(condition);
        return this;
    }

    public NativeQueryBuilder orderBy(String ... orderFields) {
        this.orderBys.addAll(Arrays.asList(orderFields));
        return this;
    }

    public NativeQueryBuilder limit(int limit) {
        this.limit = limit;
        return this;
    }

    public NativeQueryBuilder offset(int offset) {
        this.offset = offset;
        return this;
    }

    public static NativeQueryBuilder builder() {
        return new NativeQueryBuilder();
    }

    public String build() {
        return this.toString();
    }

    public String toString() {
        StringBuilder queryString = new StringBuilder();
        if (!this.selects.isEmpty()) {
            queryString.append("SELECT ").append(String.join((CharSequence)", ", this.selects));
        }
        if (!this.froms.isEmpty()) {
            queryString.append(" FROM ").append(String.join((CharSequence)", ", this.froms));
        }
        if (!this.joins.isEmpty()) {
            queryString.append(" ").append(String.join((CharSequence)" ", this.joins));
        }
        if (!this.wheres.isEmpty()) {
            queryString.append(" WHERE ").append(String.join((CharSequence)" AND ", this.wheres));
        }
        if (!this.orderBys.isEmpty()) {
            queryString.append(" ORDER BY ").append(String.join((CharSequence)", ", this.orderBys));
        }
        if (this.limit != null) {
            queryString.append(" LIMIT ").append(this.limit);
        }
        if (this.offset != null) {
            queryString.append(" OFFSET ").append(this.offset);
        }
        return queryString.toString();
    }
}

