/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.util;

import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.jboss.pnc.auth.AuthenticationProvider;
import org.jboss.pnc.auth.LoggedInUser;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.datastore.predicates.UserPredicates;
import org.jboss.pnc.spi.datastore.repositories.UserRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class UserService {
    private static final Logger logger = LoggerFactory.getLogger(UserService.class);
    public static final String ROLE_USER = "user";
    public static final String ROLE_ADMIN = "admin";
    public static final String ROLE_SYSTEM_USER = "system-user";
    @Inject
    private AuthenticationProvider authenticationProvider;
    @Inject
    private HttpServletRequest httpServletRequest;
    @Inject
    private UserRepository repository;

    public boolean isUserLoggedIn() {
        return this.httpServletRequest.getUserPrincipal() != null;
    }

    public String currentUserToken() {
        logger.trace("Getting current user token using authenticationProvider: {}.", (Object)this.authenticationProvider.getId());
        LoggedInUser currentUser = this.authenticationProvider.getLoggedInUser(this.httpServletRequest);
        logger.trace("LoggedInUser: {}.", (Object)currentUser);
        return currentUser.getTokenString();
    }

    public String currentUsername() {
        logger.trace("Getting current user token using authenticationProvider: {}.", (Object)this.authenticationProvider.getId());
        LoggedInUser currentUser = this.authenticationProvider.getLoggedInUser(this.httpServletRequest);
        logger.trace("LoggedInUser: {}.", (Object)currentUser);
        return currentUser.getUserName();
    }

    public User currentUser() {
        logger.trace("Getting current user using authenticationProvider: {}.", (Object)this.authenticationProvider.getId());
        LoggedInUser currentUser = this.authenticationProvider.getLoggedInUser(this.httpServletRequest);
        logger.trace("LoggedInUser: {}.", (Object)currentUser);
        String username = currentUser.getUserName();
        if (StringUtils.isEmpty((String)username)) {
            return null;
        }
        User user = this.getOrCreate(currentUser, username);
        user.setLoginToken(currentUser.getTokenString());
        logger.trace("Returning user: {}.", (Object)user);
        return user;
    }

    public boolean hasLoggedInUserRole(String role) {
        logger.trace("Getting current user using authenticationProvider: {}.", (Object)this.authenticationProvider.getId());
        LoggedInUser currentUser = this.authenticationProvider.getLoggedInUser(this.httpServletRequest);
        logger.trace("LoggedInUser: {}.", (Object)currentUser);
        return currentUser.isUserInRole(role);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private User getOrCreate(LoggedInUser loggedInUser, String username) {
        User user = (User)this.repository.queryByPredicates(new Predicate[]{UserPredicates.withUserName((String)username)});
        if (user == null) {
            String syncObject;
            logger.info("Adding new user to the local database: {}.", (Object)loggedInUser);
            String string = syncObject = username.intern();
            synchronized (string) {
                user = (User)this.repository.queryByPredicates(new Predicate[]{UserPredicates.withUserName((String)username)});
                if (user == null) {
                    user = User.Builder.newBuilder().username(username).firstName(loggedInUser.getFirstName()).lastName(loggedInUser.getLastName()).email(loggedInUser.getEmail()).build();
                    this.repository.save((GenericEntity)user);
                }
            }
        }
        return user;
    }
}

