/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.math.BigInteger;
import java.text.MessageFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.Tuple;
import javax.ws.rs.NotFoundException;
import org.commonjava.atlas.maven.ident.ref.InvalidRefException;
import org.jboss.pnc.api.enums.Qualifier;
import org.jboss.pnc.common.maven.Gav;
import org.jboss.pnc.common.pnc.LongBase32IdConverter;
import org.jboss.pnc.common.util.StreamHelper;
import org.jboss.pnc.coordinator.maintenance.BlacklistAsyncInvoker;
import org.jboss.pnc.dto.ArtifactRef;
import org.jboss.pnc.dto.ArtifactRevision;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.requests.QValue;
import org.jboss.pnc.dto.response.ArtifactInfo;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.BuildCategory;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.ArtifactProvider;
import org.jboss.pnc.facade.util.NativeQueryBuilder;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.mapper.api.ArtifactMapper;
import org.jboss.pnc.mapper.api.ArtifactRevisionMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.ArtifactAudited;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class ArtifactProviderImpl
extends AbstractUpdatableProvider<Integer, Artifact, org.jboss.pnc.dto.Artifact, ArtifactRef>
implements ArtifactProvider {
    private static final Logger log = LoggerFactory.getLogger(ArtifactProviderImpl.class);
    private static Logger logger = LoggerFactory.getLogger(ArtifactProviderImpl.class);
    private static final EnumSet<ArtifactQuality> USER_ALLOWED_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.NEW, ArtifactQuality.VERIFIED, ArtifactQuality.TESTED, ArtifactQuality.DEPRECATED);
    private static final EnumSet<ArtifactQuality> ADMIN_ALLOWED_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.NEW, new ArtifactQuality[]{ArtifactQuality.VERIFIED, ArtifactQuality.TESTED, ArtifactQuality.DEPRECATED, ArtifactQuality.BLACKLISTED, ArtifactQuality.DELETED});
    private static final EnumSet<ArtifactQuality> NOT_MODIFIABLE_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.DELETED, ArtifactQuality.BLACKLISTED);
    private static final EnumSet<ArtifactQuality> DA_SYNCRONIZED_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.DELETED, ArtifactQuality.BLACKLISTED);
    private static final String MVN_BLACKLIST_JSON_PAYLOAD = "{\"groupId\":\"%s\",\"artifactId\":\"%s\",\"version\":\"%s\"}";
    private static final String ID_SUFFIX = "_id";
    private ArtifactRevisionMapper artifactRevisionMapper;
    private ProductMilestoneMapper productMilestoneMapper;
    private ArtifactAuditedRepository artifactAuditedRepository;
    private BlacklistAsyncInvoker blacklistAsyncInvoker;
    private UserService userService;
    private UserMapper userMapper;
    @Inject
    private EntityManager em;

    @Inject
    public ArtifactProviderImpl(ArtifactRepository repository, ArtifactMapper mapper, ArtifactRevisionMapper artifactRevisionMapper, ProductMilestoneMapper productMilestoneMapper, ArtifactAuditedRepository artifactAuditedRepository, BlacklistAsyncInvoker blacklistAsyncInvoker, UserService userService, UserMapper userMapper) {
        super(repository, mapper, Artifact.class);
        this.artifactRevisionMapper = artifactRevisionMapper;
        this.productMilestoneMapper = productMilestoneMapper;
        this.artifactAuditedRepository = artifactAuditedRepository;
        this.blacklistAsyncInvoker = blacklistAsyncInvoker;
        this.userService = userService;
        this.userMapper = userMapper;
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getAll(int pageIndex, int pageSize, String sortingRsql, String query, Optional<String> sha256, Optional<String> md5, Optional<String> sha1) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withSha256(sha256), ArtifactPredicates.withMd5(md5), ArtifactPredicates.withSha1(sha1));
    }

    @Override
    public Page<ArtifactInfo> getAllFiltered(int pageIndex, int pageSize, Optional<String> identifierPattern, Set<ArtifactQuality> qualities, Optional<RepositoryType> repoType, Set<BuildCategory> buildCategories, Set<QValue> requestedQualifiers) {
        HashMap<Integer, Object> queryParams = new HashMap<Integer, Object>();
        AtomicInteger paramCounter = new AtomicInteger(1);
        Map<Qualifier, List<String[]>> qualifierMap = requestedQualifiers.stream().collect(Collectors.groupingBy(QValue::getQualifier, Collectors.mapping(QValue::getValue, Collectors.toList())));
        String baseQuery = this.baseArtifactQuery(pageSize, pageIndex, identifierPattern, qualities, repoType, buildCategories, queryParams, paramCounter);
        String outerQuery = this.artifactInfoNativeQuery(baseQuery, repoType, qualifierMap, queryParams, paramCounter);
        List<Tuple> list = this.doNativeQuery(outerQuery, queryParams);
        List artifacts = list.stream().collect(Collectors.groupingBy(tuple -> (String)tuple.get("identifier", String.class))).values().stream().map(tuples -> this.mapTuplesToArtifactInfo((List<Tuple>)tuples, qualifierMap)).collect(Collectors.toList());
        queryParams.clear();
        paramCounter.set(1);
        String countQuery = this.countArtifactQuery(identifierPattern, qualities, repoType, buildCategories, queryParams, paramCounter);
        int totalHits = ((BigInteger)this.doNativeQuery(countQuery, queryParams).get(0).get(0, BigInteger.class)).intValue();
        int totalPages = (totalHits + pageSize - 1) / pageSize;
        return new Page(pageIndex, pageSize, totalPages, totalHits, artifacts);
    }

    private List<Tuple> doNativeQuery(String sql, Map<Integer, Object> queryParameters) {
        Query query = this.em.createNativeQuery(sql, Tuple.class);
        queryParameters.forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
        return query.getResultList();
    }

    @Override
    @RolesAllowed(value={"pnc-app-artifact-user", "pnc-users-admin"})
    public org.jboss.pnc.dto.Artifact store(org.jboss.pnc.dto.Artifact restEntity) throws DTOValidationException {
        org.jboss.pnc.model.User currentUser = this.userService.currentUser();
        User user = this.userMapper.toDTO(currentUser);
        Instant now = Instant.now();
        return super.store(restEntity.toBuilder().creationUser(user).modificationUser(user).creationTime(now).modificationTime(now).build());
    }

    @Override
    protected void preUpdate(Artifact dbEntity, org.jboss.pnc.dto.Artifact restEntity) {
        if (!this.equalAuditedValues(dbEntity, restEntity)) {
            org.jboss.pnc.model.User currentUser = this.userService.currentUser();
            dbEntity.setModificationUser(currentUser);
            dbEntity.setModificationTime(new Date());
        }
    }

    private boolean equalAuditedValues(Artifact persisted, org.jboss.pnc.dto.Artifact toUpdate) {
        return Objects.equals(persisted.getArtifactQuality(), toUpdate.getArtifactQuality()) && Objects.equals(persisted.getQualityLevelReason(), toUpdate.getQualityLevelReason());
    }

    @Override
    public ArtifactRevision createQualityLevelRevision(String id, String quality, String reason) throws DTOValidationException {
        boolean isLoggedInUserAdmin = this.userService.hasLoggedInUserRole("pnc-users-admin");
        boolean isLoggedInUserArtifactAdmin = this.userService.hasLoggedInUserRole("pnc-app-artifact-user");
        boolean isLoggedInBuildAdmin = this.userService.hasLoggedInUserRole("pnc-app-build-user");
        boolean isLoggedInUserSystemUser = isLoggedInUserAdmin || isLoggedInUserArtifactAdmin || isLoggedInBuildAdmin;
        ArtifactQuality newQuality = this.validateProvidedArtifactQuality(quality, isLoggedInUserSystemUser);
        org.jboss.pnc.dto.Artifact artifact = (org.jboss.pnc.dto.Artifact)this.getSpecific(id);
        if (artifact == null) {
            throw new InvalidEntityException("Artifact with id: " + id + " does not exist.");
        }
        this.validateIfArtifactQualityIsModifiable(artifact, newQuality);
        this.update(id, artifact.toBuilder().artifactQuality(newQuality).qualityLevelReason(reason).build());
        ArtifactAudited latestRevision = this.artifactAuditedRepository.findLatestById(Integer.parseInt(id));
        if (latestRevision == null) {
            throw new RepositoryViolationException("Entity should exist in the DB");
        }
        if (DA_SYNCRONIZED_ARTIFACT_QUALITIES.contains(newQuality)) {
            String jsonPayload = this.createBlacklistJSONPayload(artifact);
            this.blacklistAsyncInvoker.notifyBlacklistToDA(jsonPayload);
        }
        return this.artifactRevisionMapper.toDTO(latestRevision);
    }

    private String createBlacklistJSONPayload(org.jboss.pnc.dto.Artifact artifact) {
        switch (artifact.getTargetRepository().getRepositoryType()) {
            case MAVEN: {
                try {
                    Gav gav = Gav.parse((String)artifact.getIdentifier());
                    return String.format(MVN_BLACKLIST_JSON_PAYLOAD, gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                }
                catch (InvalidRefException e) {
                    log.info("Gav coordinates could not be calculated for identifier '{}', the artifact will not be blocklisted in DA", (Object)artifact.getIdentifier());
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    @DenyAll
    public void delete(String id) throws DTOValidationException {
        throw new UnsupportedOperationException("Direct artifact manipulation is not available.");
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getBuiltArtifactsForBuild(int pageIndex, int pageSize, String sortingRsql, String query, String buildId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withBuildRecordId((Base32LongID)BuildMapper.idMapper.toEntity(buildId)));
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getArtifactsForTargetRepository(int pageIndex, int pageSize, String sortingRsql, String query, Integer targetRepositoryId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withTargetRepositoryId((Integer)targetRepositoryId));
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getDependantArtifactsForBuild(int pageIndex, int pageSize, String sortingRsql, String query, String buildId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withDependantBuildRecordId((Base32LongID)BuildMapper.idMapper.toEntity(buildId)));
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getDeliveredArtifactsForMilestone(int pageIndex, int pageSize, String sortingRsql, String query, String milestoneId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withDeliveredInProductMilestone((Integer)((Integer)this.productMilestoneMapper.getIdMapper().toEntity((Object)milestoneId))));
    }

    @Override
    public Page<ArtifactRevision> getRevisions(int pageIndex, int pageSize, String id) {
        List auditedBuildConfigs = this.artifactAuditedRepository.findAllByIdOrderByRevDesc(Integer.valueOf(id));
        List toReturn = StreamHelper.nullableStreamOf((Collection)auditedBuildConfigs).map(arg_0 -> ((ArtifactRevisionMapper)this.artifactRevisionMapper).toDTO(arg_0)).skip(pageIndex * pageSize).limit(pageSize).collect(Collectors.toList());
        int totalHits = auditedBuildConfigs.size();
        int totalPages = (totalHits + pageSize - 1) / pageSize;
        return new Page(pageIndex, pageSize, totalPages, totalHits, toReturn);
    }

    @Override
    public ArtifactRevision getRevision(String id, Integer rev) {
        IdRev idRev = new IdRev(Integer.valueOf(id), rev);
        ArtifactAudited auditedArtifact = this.artifactAuditedRepository.queryById(idRev);
        return this.artifactRevisionMapper.toDTO(auditedArtifact);
    }

    @Override
    public org.jboss.pnc.dto.Artifact getSpecificFromPurl(String purl) {
        Artifact artifact = ((ArtifactRepository)this.repository).withPurl(purl);
        if (artifact == null) {
            throw new NotFoundException();
        }
        return (org.jboss.pnc.dto.Artifact)this.mapper.toDTO((GenericEntity)artifact);
    }

    private String artifactInfoNativeQuery(String baseArtifactQuery, Optional<RepositoryType> repoType, Map<Qualifier, List<String[]>> qualifierMap, Map<Integer, Object> queryParams, AtomicInteger paramCounter) {
        NativeQueryBuilder builder = NativeQueryBuilder.builder();
        builder.select("art", "id", "id").select("art", "identifier", "identifier").select("art", "artifactQuality", "QUALITY").select("art", "buildCategory", "BUILD_CATEGORY");
        repoType.ifPresent(ign -> builder.select("art", "repositoryType", "repoType"));
        builder.from("(" + baseArtifactQuery + ")", "art");
        qualifierMap.forEach((qualifier, values) -> {
            switch (qualifier) {
                case PRODUCT: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    this.requiresJoinOf(Qualifier.MILESTONE, builder);
                    this.requiresJoinOf(Qualifier.VERSION, builder);
                    this.requiresJoinOf(Qualifier.PRODUCT, builder);
                    this.requiresSelect(Qualifier.PRODUCT, builder);
                    break;
                }
                case PRODUCT_ID: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    this.requiresJoinOf(Qualifier.MILESTONE, builder);
                    this.requiresJoinOf(Qualifier.VERSION, builder);
                    builder.select("pv", "product_id", qualifier.name());
                    break;
                }
                case VERSION: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    this.requiresJoinOf(Qualifier.MILESTONE, builder);
                    this.requiresJoinOf(Qualifier.VERSION, builder);
                    this.requiresJoinOf(Qualifier.PRODUCT, builder);
                    this.requiresSelect(Qualifier.PRODUCT, builder);
                    builder.select("pv", "version", qualifier.name());
                    break;
                }
                case VERSION_ID: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    this.requiresJoinOf(Qualifier.MILESTONE, builder);
                    builder.select("pm", "productVersion_id", qualifier.name());
                    break;
                }
                case MILESTONE: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    this.requiresJoinOf(Qualifier.MILESTONE, builder);
                    this.requiresJoinOf(Qualifier.VERSION, builder);
                    this.requiresJoinOf(Qualifier.PRODUCT, builder);
                    this.requiresSelect(Qualifier.PRODUCT, builder);
                    builder.select("pm", "version", qualifier.name());
                    break;
                }
                case MILESTONE_ID: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    builder.select("br", "productMilestone_id", qualifier.name());
                    break;
                }
                case GROUP_BUILD: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    builder.select("br", "buildConfigSetRecord_id", qualifier.name());
                    break;
                }
                case BUILD: {
                    builder.select("art", "buildRecord_id", qualifier.name());
                    break;
                }
                case BUILD_CONFIG: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    this.requiresJoinOf(Qualifier.BUILD_CONFIG, builder);
                    builder.select("bc", "name", qualifier.name());
                    break;
                }
                case BUILD_CONFIG_ID: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    builder.select("br", "buildconfiguration_id", qualifier.name());
                    break;
                }
                case GROUP_CONFIG: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    this.requiresJoinOf(Qualifier.GROUP_BUILD, builder);
                    this.requiresJoinOf(Qualifier.GROUP_CONFIG, builder);
                    builder.select("bcs", "name", qualifier.name());
                    break;
                }
                case GROUP_CONFIG_ID: {
                    this.requiresJoinOf(Qualifier.BUILD, builder);
                    this.requiresJoinOf(Qualifier.GROUP_BUILD, builder);
                    builder.select("bcsr", "buildConfigurationSet_id", qualifier.name());
                    break;
                }
                case DEPENDENCY: {
                    List parameters = values.stream().peek(qValue -> queryParams.put(paramCounter.getAndIncrement(), LongBase32IdConverter.toLong((String)qValue[0]))).map(ign -> " ? ").collect(Collectors.toList());
                    builder.join("LEFT", "build_record_artifact_dependencies_map", "depmap", "art.id = depmap.dependency_artifact_id AND depmap.build_record_id IN (" + String.join((CharSequence)",", parameters) + ")");
                    builder.select("depmap", "build_record_id", qualifier.name());
                    break;
                }
            }
        });
        return builder.build();
    }

    private void requiresJoinOf(Qualifier toJoin, NativeQueryBuilder builder) {
        switch (toJoin) {
            case PRODUCT: {
                builder.requiresJoin("LEFT", "Product", "prod", "pv.product_id = prod.id");
                break;
            }
            case VERSION: {
                builder.requiresJoin("LEFT", "ProductVersion", "pv", "pm.productversion_id = pv.id");
                break;
            }
            case MILESTONE: {
                builder.requiresJoin("LEFT", "ProductMilestone", "pm", "br.productmilestone_id = pm.id");
                break;
            }
            case GROUP_BUILD: {
                builder.requiresJoin("LEFT", "BuildConfigSetRecord", "bcsr", "br.buildconfigsetrecord_id = bcsr.id");
                break;
            }
            case BUILD: {
                builder.requiresJoin("LEFT", "BuildRecord", "br", "art.buildrecord_id = br.id");
                break;
            }
            case BUILD_CONFIG: {
                builder.requiresJoin("LEFT", "BuildConfiguration", "bc", "br.buildconfiguration_id = bc.id");
                break;
            }
            case GROUP_CONFIG: {
                builder.requiresJoin("LEFT", "BuildConfigurationSet", "bcs", "bcsr.buildconfigurationset_id = bcs.id");
            }
        }
    }

    private void requiresSelect(Qualifier toSelect, NativeQueryBuilder builder) {
        switch (toSelect) {
            case PRODUCT: {
                builder.requiresSelect("prod", "abbreviation", Qualifier.PRODUCT.name());
            }
        }
    }

    private String baseArtifactQuery(int pageSize, int pageIndex, Optional<String> identifierPattern, Set<ArtifactQuality> qualities, Optional<RepositoryType> repoType, Set<BuildCategory> buildCategories, Map<Integer, Object> queryParameters, AtomicInteger parameterCounter) {
        NativeQueryBuilder builder = NativeQueryBuilder.builder();
        builder.select("a", "id").select("a", "identifier").select("a", "artifactQuality").select("a", "buildCategory").select("a", "buildRecord_id");
        if (repoType.isPresent()) {
            builder.select("tr", "repositoryType");
        }
        ArtifactProviderImpl.baseArtifactQueryBody(builder, identifierPattern, qualities, repoType, buildCategories, queryParameters, parameterCounter);
        builder.orderBy("a.id ASC");
        builder.limit(pageSize);
        builder.offset(pageIndex * pageSize);
        return builder.build();
    }

    private String countArtifactQuery(Optional<String> identifierPattern, Set<ArtifactQuality> qualities, Optional<RepositoryType> repoType, Set<BuildCategory> buildCategories, Map<Integer, Object> queryParameters, AtomicInteger parameterCounter) {
        NativeQueryBuilder builder = NativeQueryBuilder.builder();
        builder.select("count (*)");
        ArtifactProviderImpl.baseArtifactQueryBody(builder, identifierPattern, qualities, repoType, buildCategories, queryParameters, parameterCounter);
        return builder.build();
    }

    private static void baseArtifactQueryBody(NativeQueryBuilder builder, Optional<String> identifierPattern, Set<ArtifactQuality> qualities, Optional<RepositoryType> repoType, Set<BuildCategory> buildCategories, Map<Integer, Object> queryParameters, AtomicInteger parameterCounter) {
        Set strings;
        builder.from("artifact", "a");
        if (identifierPattern.isPresent()) {
            queryParameters.put(parameterCounter.getAndIncrement(), identifierPattern.get().replace("*", "%"));
            builder.where("a.identifier LIKE ?");
        }
        if (!qualities.isEmpty()) {
            strings = qualities.stream().map(e -> "'" + e.toString() + "'").collect(Collectors.toSet());
            builder.where("a.artifactQuality in (" + String.join((CharSequence)",", strings) + ")");
        }
        if (!buildCategories.isEmpty()) {
            strings = buildCategories.stream().map(e -> "'" + e.toString() + "'").collect(Collectors.toSet());
            builder.where("a.buildCategory in (" + String.join((CharSequence)",", strings) + ")");
        }
        if (repoType.isPresent()) {
            builder.join("LEFT", "TargetRepository", "tr", MessageFormat.format("a.{0} = tr.{1}", "targetRepository_id", "id"));
            String trColumn = "tr.repositoryType";
            String repoTypeString = repoType.get().toString();
            builder.where(trColumn + " = '" + repoTypeString + "'");
        }
    }

    private Predicate<Artifact>[] getPredicates(Optional<String> identifierPattern, Set<ArtifactQuality> qualities, Optional<RepositoryType> repoType, Set<BuildCategory> buildCategories) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(4);
        if (identifierPattern.isPresent()) {
            Predicate withIdentifierLike = ArtifactPredicates.withIdentifierLike((String)identifierPattern.get().replace("*", "%"));
            predicates.add(withIdentifierLike);
        }
        if (!qualities.isEmpty()) {
            Predicate withQualityIn = ArtifactPredicates.withArtifactQualityIn(qualities);
            predicates.add(withQualityIn);
        }
        if (!buildCategories.isEmpty()) {
            Predicate withBuildCategoryIn = ArtifactPredicates.withBuildCategoryIn(buildCategories);
            predicates.add(withBuildCategoryIn);
        }
        if (repoType.isPresent()) {
            Predicate withRepoType = ArtifactPredicates.withTargetRepositoryRepositoryType((RepositoryType)repoType.get());
            predicates.add(withRepoType);
        }
        return predicates.toArray(new Predicate[predicates.size()]);
    }

    private ArtifactInfo mapTuplesToArtifactInfo(List<Tuple> tuples, Map<Qualifier, List<String[]>> qualifierMap) {
        ArtifactInfo baseInfo = this.mapNamedTupleToArtifactInfo(tuples.get(0));
        for (Tuple tuple : tuples) {
            for (Map.Entry<Qualifier, List<String[]>> entry : qualifierMap.entrySet()) {
                Qualifier qualifier = entry.getKey();
                List<String[]> allowedValues = entry.getValue();
                CharSequence[] parsedValue = ArtifactProviderImpl.parseValue(tuple, qualifier);
                if (!allowedValues.stream().anyMatch(arg_0 -> ArtifactProviderImpl.lambda$mapTuplesToArtifactInfo$8((String[])parsedValue, arg_0))) continue;
                String joinedValue = String.join((CharSequence)" ", parsedValue);
                if (baseInfo.getQualifiers().containsKey(qualifier)) {
                    ((Set)baseInfo.getQualifiers().get(qualifier)).add(joinedValue);
                    continue;
                }
                baseInfo.getQualifiers().put(qualifier, new HashSet());
                ((Set)baseInfo.getQualifiers().get(qualifier)).add(joinedValue);
            }
        }
        return baseInfo;
    }

    private static String[] parseValue(Tuple tuple, Qualifier qualifier) {
        String[] parsedValue;
        switch (qualifier) {
            case VERSION: 
            case MILESTONE: {
                String productAbbr = (String)tuple.get(Qualifier.PRODUCT.name(), String.class);
                String versionPart = (String)tuple.get(qualifier.name(), String.class);
                parsedValue = new String[]{productAbbr, versionPart};
                break;
            }
            case BUILD: 
            case DEPENDENCY: {
                BigInteger toConvertId = (BigInteger)tuple.get(qualifier.name(), BigInteger.class);
                parsedValue = new String[]{LongBase32IdConverter.toString(toConvertId == null ? null : Long.valueOf(toConvertId.longValue()))};
                break;
            }
            case GROUP_BUILD: {
                BigInteger bigIntId = (BigInteger)tuple.get(qualifier.name(), BigInteger.class);
                parsedValue = new String[]{bigIntId == null ? null : String.valueOf(bigIntId.longValue())};
                break;
            }
            case PRODUCT_ID: 
            case VERSION_ID: 
            case MILESTONE_ID: 
            case BUILD_CONFIG_ID: 
            case GROUP_CONFIG_ID: {
                Integer intId = (Integer)tuple.get(qualifier.name(), Integer.class);
                parsedValue = new String[]{intId == null ? null : intId.toString()};
                break;
            }
            case PRODUCT: 
            case BUILD_CONFIG: 
            case GROUP_CONFIG: 
            case QUALITY: {
                parsedValue = new String[]{(String)tuple.get(qualifier.name(), String.class)};
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown qualifier " + qualifier.name());
            }
        }
        return parsedValue;
    }

    private ArtifactInfo mapTupleToArtifactInfo(Tuple tuple) {
        return ArtifactInfo.builder().id(tuple.get(0).toString()).identifier(tuple.get(1).toString()).artifactQuality((ArtifactQuality)tuple.get(2)).repositoryType((RepositoryType)tuple.get(3)).buildCategory((BuildCategory)tuple.get(4)).build();
    }

    private ArtifactInfo mapNamedTupleToArtifactInfo(Tuple tuple) {
        ArtifactInfo.Builder builder = ArtifactInfo.builder().id(((Integer)tuple.get("id", Integer.class)).toString()).identifier((String)tuple.get("identifier", String.class)).artifactQuality(ArtifactQuality.valueOf((String)((String)tuple.get("QUALITY", String.class)))).buildCategory(BuildCategory.valueOf((String)((String)tuple.get("BUILD_CATEGORY", String.class)))).qualifiers(new HashMap());
        try {
            builder.repositoryType(RepositoryType.valueOf((String)((String)tuple.get("repoType", String.class))));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return builder.build();
    }

    private ArtifactQuality validateProvidedArtifactQuality(String quality, boolean isLoggedInUserSystemUser) {
        EnumSet<ArtifactQuality> allowedQualities;
        ArtifactQuality newQuality;
        try {
            newQuality = ArtifactQuality.valueOf((String)quality.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidEntityException("Artifact quality: " + quality + " does not exist.");
        }
        EnumSet<ArtifactQuality> enumSet = allowedQualities = isLoggedInUserSystemUser ? ADMIN_ALLOWED_ARTIFACT_QUALITIES : USER_ALLOWED_ARTIFACT_QUALITIES;
        if (!allowedQualities.contains(newQuality)) {
            throw new InvalidEntityException("Artifact quality level can be changed only to " + allowedQualities);
        }
        return newQuality;
    }

    private void validateIfArtifactQualityIsModifiable(org.jboss.pnc.dto.Artifact artifact, ArtifactQuality newQuality) {
        if (artifact.getArtifactQuality().equals((Object)newQuality)) {
            return;
        }
        if (NOT_MODIFIABLE_ARTIFACT_QUALITIES.contains(artifact.getArtifactQuality())) {
            throw new ConflictedEntryException("Artifact " + artifact.getId() + " with quality " + artifact.getArtifactQuality() + " cannot be changed to another quality level.", Artifact.class, artifact.getId());
        }
        if (ArtifactQuality.TEMPORARY.equals((Object)artifact.getArtifactQuality()) && !newQuality.equals((Object)ArtifactQuality.DELETED)) {
            throw new ConflictedEntryException("Temporary artifact " + artifact.getId() + " can only be changed to DELETED quality level.", Artifact.class, artifact.getId());
        }
    }

    private static /* synthetic */ boolean lambda$mapTuplesToArtifactInfo$8(String[] parsedValue, String[] value) {
        return Arrays.equals(value, parsedValue);
    }
}

