/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.common.alignment.ranking.AlignmentPredicate;
import org.jboss.pnc.common.alignment.ranking.AlignmentRanking;
import org.jboss.pnc.common.alignment.ranking.exception.ValidationException;
import org.jboss.pnc.common.alignment.ranking.tokenizer.QualifierToken;
import org.jboss.pnc.common.alignment.ranking.tokenizer.Token;
import org.jboss.pnc.common.json.moduleconfig.AlignmentConfig;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.common.util.StreamHelper;
import org.jboss.pnc.dto.AlignmentStrategy;
import org.jboss.pnc.dto.BuildConfigurationRef;
import org.jboss.pnc.dto.BuildConfigurationRevision;
import org.jboss.pnc.dto.BuildConfigurationWithLatestBuild;
import org.jboss.pnc.dto.BuildRef;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.notification.BuildConfigurationCreation;
import org.jboss.pnc.dto.requests.BuildConfigWithSCMRequest;
import org.jboss.pnc.dto.response.BuildConfigCreationResponse;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.RepositoryCreationResponse;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.JobNotificationType;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.BuildConfigRevisionHelper;
import org.jboss.pnc.facade.providers.api.BuildConfigurationProvider;
import org.jboss.pnc.facade.providers.api.BuildProvider;
import org.jboss.pnc.facade.providers.api.SCMRepositoryProvider;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.ConflictedEntryValidator;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.facade.validation.ValidationBuilder;
import org.jboss.pnc.mapper.api.BuildConfigurationMapper;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.datastore.predicates.BuildConfigurationPredicates;
import org.jboss.pnc.spi.datastore.predicates.BuildConfigurationSetPredicates;
import org.jboss.pnc.spi.datastore.predicates.ProductMilestonePredicates;
import org.jboss.pnc.spi.datastore.predicates.ProductPredicates;
import org.jboss.pnc.spi.datastore.predicates.ProductVersionPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildEnvironmentRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductVersionRepository;
import org.jboss.pnc.spi.datastore.repositories.ProjectRepository;
import org.jboss.pnc.spi.datastore.repositories.RepositoryConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.SequenceHandlerRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.datastore.repositories.api.Repository;
import org.jboss.pnc.spi.exception.MissingDataException;
import org.jboss.pnc.spi.exception.RemoteRequestException;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class BuildConfigurationProviderImpl
extends AbstractUpdatableProvider<Integer, BuildConfiguration, org.jboss.pnc.dto.BuildConfiguration, BuildConfigurationRef>
implements BuildConfigurationProvider {
    private final Logger logger = LoggerFactory.getLogger(BuildConfigurationProviderImpl.class);
    @Inject
    private ProductVersionRepository productVersionRepository;
    @Inject
    private BuildRecordRepository buildRecordRepository;
    @Inject
    private BuildCoordinator buildCoordinator;
    @Inject
    private BuildConfigurationRevisionMapper buildConfigurationRevisionMapper;
    @Inject
    private SCMRepositoryMapper scmRepositoryMapper;
    @Inject
    private BuildMapper buildMapper;
    @Inject
    private BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    @Inject
    private RepositoryConfigurationRepository repositoryConfigurationRepository;
    @Inject
    private BuildConfigurationSetRepository buildConfigurationSetRepository;
    @Inject
    private BuildEnvironmentRepository buildEnvironmentRepository;
    @Inject
    private SequenceHandlerRepository sequenceHandlerRepository;
    @Inject
    private Notifier notifier;
    @Inject
    private SCMRepositoryProvider scmRepositoryProvider;
    @Inject
    private BuildConfigRevisionHelper buildConfigRevisionHelper;
    @Inject
    private ProjectRepository projectRepository;
    @Inject
    private ProductRepository productRepository;
    @Inject
    private ProductMilestoneRepository productMilestoneRepository;
    @Inject
    private BuildConfigSetRecordRepository buildConfigSetRecordRepository;
    @Inject
    private BuildProvider buildProvider;
    @Inject
    private UserService userService;
    @Inject
    private UserMapper userMapper;
    @Inject
    private AlignmentConfig alignmentConfig;
    private static final SCMRepository FAKE_REPOSITORY = SCMRepository.builder().id("-1").build();

    @Inject
    public BuildConfigurationProviderImpl(BuildConfigurationRepository repository, BuildConfigurationMapper mapper) {
        super(repository, mapper, BuildConfiguration.class);
    }

    @Override
    public Page<org.jboss.pnc.dto.BuildConfiguration> getAll(int pageIndex, int pageSize, String sortingRsql, String query) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public org.jboss.pnc.dto.BuildConfiguration store(org.jboss.pnc.dto.BuildConfiguration restEntity) throws DTOValidationException {
        this.validateBeforeSaving(restEntity);
        Long id = this.sequenceHandlerRepository.getNextID("build_configuration_id_seq");
        org.jboss.pnc.model.User currentUser = this.userService.currentUser();
        User user = this.userMapper.toDTO(currentUser);
        return super.store(restEntity.toBuilder().id(id.toString()).creationUser(user).modificationUser(user).build(), false);
    }

    @Override
    public org.jboss.pnc.dto.BuildConfiguration getSpecific(String id) {
        BuildConfiguration dbEntity = (BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(id));
        if (dbEntity != null && dbEntity.isArchived()) {
            return null;
        }
        return (org.jboss.pnc.dto.BuildConfiguration)this.mapper.toDTO((GenericEntity)dbEntity);
    }

    @Override
    protected void preUpdate(BuildConfiguration dbEntity, org.jboss.pnc.dto.BuildConfiguration restEntity) {
        if (!BuildConfigRevisionHelper.equalValues(dbEntity, restEntity)) {
            org.jboss.pnc.model.User currentUser = this.userService.currentUser();
            dbEntity.setLastModificationUser(currentUser);
            dbEntity.setLastModificationTime(new Date());
        }
        if (restEntity.getBuildType() != dbEntity.getBuildType()) {
            dbEntity.setDefaultAlignmentParams((String)this.alignmentConfig.getAlignmentParameters().get(restEntity.getBuildType().toString()));
        }
    }

    @Override
    protected void validateBeforeSaving(org.jboss.pnc.dto.BuildConfiguration buildConfigurationRest) {
        super.validateBeforeSaving(buildConfigurationRest);
        this.validateIfItsNotConflicted(buildConfigurationRest);
        this.validateEnvironment(buildConfigurationRest);
        this.validateAlignStrategy(buildConfigurationRest);
    }

    private void validateAlignStrategy(org.jboss.pnc.dto.BuildConfiguration newConfiguration) {
        Set newStrategies = newConfiguration.getAlignmentStrategies();
        if (newStrategies == null || newStrategies.isEmpty()) {
            return;
        }
        this.validateRankings(newStrategies);
        this.validateAllowDenyLists(newStrategies);
    }

    private void validateAlignStrategy(Integer id, org.jboss.pnc.dto.BuildConfiguration buildConfigurationRest) {
        Set newStrategies = buildConfigurationRest.getAlignmentStrategies();
        if (newStrategies == null || newStrategies.isEmpty()) {
            return;
        }
        Set oldStrategies = this.getSpecific(String.valueOf(id)).getAlignmentStrategies();
        if (oldStrategies == null || oldStrategies.isEmpty()) {
            this.validateRankings(newStrategies);
            this.validateAllowDenyLists(newStrategies);
        } else {
            this.validateRankings(newStrategies, oldStrategies);
            this.validateAllowDenyLists(newStrategies, oldStrategies);
        }
    }

    private void validateRankings(Set<AlignmentStrategy> strategies) {
        List rankings = strategies.stream().map(AlignmentStrategy::getRanks).collect(Collectors.toList());
        for (List ranks : rankings) {
            AlignmentRanking compiledRanks;
            try {
                compiledRanks = new AlignmentRanking(ranks, null);
            }
            catch (Exception e) {
                throw new InvalidEntityException(e.getMessage(), "alignmentStrategies", e);
            }
            List tokenizedRanks = compiledRanks.getRanksAsTokens();
            this.verifyQualifiersExist(tokenizedRanks);
        }
    }

    private void validateRankings(Set<AlignmentStrategy> newStrats, Set<AlignmentStrategy> oldStrats) {
        try {
            Map<String, List<List<Token>>> newDependencyTokensMap = BuildConfigurationProviderImpl.mapStratToListOfTokensPerRank(newStrats);
            Map<String, List<List<Token>>> oldDependencyTokensMap = BuildConfigurationProviderImpl.mapStratToListOfTokensPerRank(oldStrats);
            Map mappedByDepOverride = newStrats.stream().collect(Collectors.toMap(AlignmentStrategy::getDependencyOverride, Function.identity()));
            Set<AlignmentStrategy> toValidate = newDependencyTokensMap.entrySet().stream().filter(entry -> !oldDependencyTokensMap.containsKey(entry.getKey()) || !((List)oldDependencyTokensMap.get(entry.getKey())).equals(entry.getValue())).map(Map.Entry::getKey).map(mappedByDepOverride::get).collect(Collectors.toSet());
            this.validateRankings(toValidate);
        }
        catch (ValidationException e) {
            throw new InvalidEntityException(e.getMessage(), "alignmentStrategies", e);
        }
    }

    private void validateAllowDenyLists(Set<AlignmentStrategy> newStrats) {
        this.validateAList(newStrats, AlignmentStrategy::getDenyList);
        this.validateAList(newStrats, AlignmentStrategy::getAllowList);
    }

    private void validateAllowDenyLists(Set<AlignmentStrategy> newStrats, Set<AlignmentStrategy> oldStrats) {
        try {
            Map mappedByDepOverride = newStrats.stream().collect(Collectors.toMap(AlignmentStrategy::getDependencyOverride, Function.identity()));
            Map<String, List<Token>> newDenyListTokenMap = BuildConfigurationProviderImpl.mapStratPredicateToListOfTokens(newStrats, AlignmentStrategy::getDenyList);
            Map<String, List<Token>> oldDenyListTokenMap = BuildConfigurationProviderImpl.mapStratPredicateToListOfTokens(oldStrats, AlignmentStrategy::getDenyList);
            Set<Object> toValidate = newDenyListTokenMap.entrySet().stream().filter(entry -> !oldDenyListTokenMap.containsKey(entry.getKey()) || !((List)oldDenyListTokenMap.get(entry.getKey())).equals(entry.getValue())).map(Map.Entry::getKey).map(mappedByDepOverride::get).collect(Collectors.toSet());
            this.validateAList(toValidate, AlignmentStrategy::getDenyList);
            Map<String, List<Token>> newAllowListTokenMap = BuildConfigurationProviderImpl.mapStratPredicateToListOfTokens(newStrats, AlignmentStrategy::getAllowList);
            Map<String, List<Token>> oldAllowListTokenMap = BuildConfigurationProviderImpl.mapStratPredicateToListOfTokens(oldStrats, AlignmentStrategy::getAllowList);
            toValidate = newAllowListTokenMap.entrySet().stream().filter(entry -> !oldAllowListTokenMap.containsKey(entry.getKey()) || !((List)oldAllowListTokenMap.get(entry.getKey())).equals(entry.getValue())).map(Map.Entry::getKey).map(mappedByDepOverride::get).collect(Collectors.toSet());
            this.validateAList(toValidate, AlignmentStrategy::getAllowList);
        }
        catch (ValidationException e) {
            throw new InvalidEntityException(e.getMessage(), "alignmentStrategies", e);
        }
    }

    private void validateAList(Set<AlignmentStrategy> newStrats, Function<AlignmentStrategy, String> allowDenylistFunction) {
        try {
            Map<String, List<Token>> newDenies = BuildConfigurationProviderImpl.mapStratPredicateToListOfTokens(newStrats, allowDenylistFunction);
            newDenies.values().stream().flatMap(Collection::stream).filter(token -> token instanceof QualifierToken).forEach(token -> this.verifyQualifier((QualifierToken)token));
        }
        catch (ValidationException e) {
            throw new InvalidEntityException(e.getMessage(), "alignmentStrategies", e);
        }
    }

    private static Map<String, List<List<Token>>> mapStratToListOfTokensPerRank(Set<AlignmentStrategy> strats) {
        return strats.stream().collect(Collectors.toMap(AlignmentStrategy::getDependencyOverride, ac -> new AlignmentRanking(ac.getRanks(), null).getRanksAsTokens()));
    }

    private static Map<String, List<Token>> mapStratPredicateToListOfTokens(Set<AlignmentStrategy> strats, Function<AlignmentStrategy, String> allowDenylistFunction) {
        return strats.stream().collect(Collectors.toMap(AlignmentStrategy::getDependencyOverride, ac -> new AlignmentPredicate((String)allowDenylistFunction.apply((AlignmentStrategy)ac)).getTokens()));
    }

    private void verifyQualifiersExist(List<List<Token>> tokenizedRanks) {
        tokenizedRanks.stream().flatMap(Collection::stream).distinct().filter(token -> token instanceof QualifierToken).forEach(token -> this.verifyQualifier((QualifierToken)token));
    }

    private void verifyQualifier(QualifierToken token) {
        String[] values = token.parts;
        switch (token.qualifier) {
            case PRODUCT_ID: {
                this.validateById((Serializable)this.parseQualifierId(values[0], Integer::valueOf, Product.class), (Repository)this.productRepository, (Class)Product.class);
                break;
            }
            case PRODUCT: {
                Product product = (Product)this.productRepository.queryByPredicates(new Predicate[]{ProductPredicates.withAbbrev((String)values[0])});
                if (product != null) break;
                throw new InvalidEntityException("Product with abbreviation " + values[0] + " not found.");
            }
            case VERSION_ID: {
                this.validateById((Serializable)this.parseQualifierId(values[0], Integer::valueOf, ProductVersion.class), (Repository)this.productVersionRepository, (Class)ProductVersion.class);
                break;
            }
            case VERSION: {
                ProductVersion version = (ProductVersion)this.productVersionRepository.queryByPredicates(new Predicate[]{ProductVersionPredicates.withProductAbbreviation((String)values[0]), ProductVersionPredicates.withVersion((String)values[1])});
                if (version != null) break;
                throw new InvalidEntityException("ProductVersion of Product " + values[0] + " and Version " + values[1] + " does not exist.");
            }
            case MILESTONE_ID: {
                this.validateById((Serializable)this.parseQualifierId(values[0], Integer::valueOf, ProductMilestone.class), (Repository)this.productMilestoneRepository, (Class)ProductMilestone.class);
                break;
            }
            case MILESTONE: {
                ProductMilestone milestone = (ProductMilestone)this.productMilestoneRepository.queryByPredicates(new Predicate[]{ProductMilestonePredicates.withProductAbbreviationAndMilestoneVersion((String)values[0], (String)values[1])});
                if (milestone != null) break;
                throw new InvalidEntityException("ProductMilestone of Product " + values[0] + " and Version " + values[1] + " does not exist.");
            }
            case GROUP_BUILD: {
                this.validateById((Serializable)this.parseQualifierId(values[0], Long::valueOf, BuildConfigSetRecord.class), (Repository)this.buildConfigSetRecordRepository, (Class)BuildConfigSetRecord.class);
                break;
            }
            case DEPENDENCY: 
            case BUILD: {
                this.validateById((Serializable)this.parseQualifierId(values[0], Base32LongID::new, BuildRecord.class), (Repository)this.buildRecordRepository, (Class)BuildRecord.class);
                break;
            }
            case BUILD_CONFIG_ID: {
                this.validateById(this.parseQualifierId(values[0], Integer::valueOf, BuildConfiguration.class), this.repository, BuildConfiguration.class);
                break;
            }
            case BUILD_CONFIG: {
                BuildConfiguration configuration = (BuildConfiguration)this.repository.queryByPredicates(new Predicate[]{BuildConfigurationPredicates.withName((String)values[0])});
                if (configuration != null) break;
                throw new InvalidEntityException("BuildConfiguration with name " + values[0] + " not found");
            }
            case GROUP_CONFIG_ID: {
                this.validateById((Serializable)this.parseQualifierId(values[0], Integer::valueOf, BuildConfigurationSet.class), (Repository)this.buildConfigurationSetRepository, (Class)BuildConfigurationSet.class);
                break;
            }
            case GROUP_CONFIG: {
                BuildConfigurationSet bcs = (BuildConfigurationSet)this.buildConfigurationSetRepository.queryByPredicates(new Predicate[]{BuildConfigurationSetPredicates.withName((String)values[0])});
                if (bcs != null) break;
                throw new InvalidEntityException("BuildConfiguration with name " + values[0] + " not found");
            }
            case QUALITY: {
                try {
                    ArtifactQuality.valueOf((String)values[0]);
                    break;
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidEntityException("Unknown Quality " + values[0]);
                }
            }
        }
    }

    private <ID extends Serializable> ID parseQualifierId(String value, Function<String, ID> parser, Class<? extends GenericEntity<ID>> clazz) {
        try {
            return (ID)((Serializable)parser.apply(value));
        }
        catch (Exception e) {
            throw new InvalidEntityException("Could not parse " + clazz.getCanonicalName() + " ID " + value, "alignmentStrategies", e);
        }
    }

    private <E extends GenericEntity<ID>, ID extends Serializable> void validateById(ID parsedId, Repository<E, ID> repository, Class<E> clazz) {
        GenericEntity entity = repository.queryById(parsedId);
        if (entity == null) {
            throw new InvalidEntityException(clazz.getSimpleName() + " with ID " + parsedId.toString() + " does not exist.");
        }
    }

    @Override
    protected void validateBeforeUpdating(Integer id, org.jboss.pnc.dto.BuildConfiguration buildConfigurationRest) {
        super.validateBeforeUpdating(id, buildConfigurationRest);
        BuildConfiguration dbEntity = (BuildConfiguration)this.findInDB(id);
        if (dbEntity.isArchived()) {
            throw new RepositoryViolationException("The Build Config " + id + " is already deleted.");
        }
        this.validateIfItsNotConflicted(buildConfigurationRest);
        this.validateDependencies(id, buildConfigurationRest.getDependencies());
        this.validateEnvironment(buildConfigurationRest);
        this.validateAlignStrategy(id, buildConfigurationRest);
    }

    private void validateDependencies(Integer buildConfigId, Map<String, BuildConfigurationRef> dependencies) throws InvalidEntityException {
        if (dependencies == null || dependencies.isEmpty()) {
            return;
        }
        BuildConfiguration buildConfig = (BuildConfiguration)this.repository.queryById((Serializable)buildConfigId);
        for (String id : dependencies.keySet()) {
            Integer dependencyId = Integer.valueOf(id);
            ValidationBuilder.validateObject(buildConfig, WhenUpdating.class).validateCondition(!buildConfig.getId().equals(dependencyId), "A build configuration cannot depend on itself");
            BuildConfiguration dependency = (BuildConfiguration)this.repository.queryById((Serializable)dependencyId);
            ValidationBuilder.validateObject(buildConfig, WhenUpdating.class).validateCondition(!dependency.getAllDependencies().contains(buildConfig), "Cannot add dependency from : " + buildConfig.getId() + " to: " + dependencyId + " because it would introduce a cyclic dependency");
        }
    }

    private void validateIfItsNotConflicted(org.jboss.pnc.dto.BuildConfiguration buildConfigurationRest) throws ConflictedEntryException, InvalidEntityException {
        ValidationBuilder.validateObject(buildConfigurationRest, WhenUpdating.class).validateConflict(() -> {
            BuildConfiguration buildConfigurationFromDB = (BuildConfiguration)this.repository.queryByPredicates(new Predicate[]{BuildConfigurationPredicates.withName((String)buildConfigurationRest.getName()), BuildConfigurationPredicates.isNotArchived()});
            if (!(buildConfigurationFromDB == null || buildConfigurationRest.getId() != null && buildConfigurationFromDB.getId().equals(Integer.valueOf(buildConfigurationRest.getId())))) {
                return new ConflictedEntryValidator.ConflictedEntryValidationError<Integer>(buildConfigurationFromDB.getId(), BuildConfiguration.class, "Build configuration with the same name already exists");
            }
            return null;
        });
    }

    private void validateEnvironment(org.jboss.pnc.dto.BuildConfiguration buildConfigurationRest) {
        String envId = buildConfigurationRest.getEnvironment().getId();
        BuildEnvironment env = (BuildEnvironment)this.buildEnvironmentRepository.queryById((Serializable)Integer.valueOf(envId));
        if (env == null) {
            throw new EmptyEntityException("Build environment " + envId + " does not exist.");
        }
    }

    @Override
    public BuildConfigurationRevision createRevision(String id, org.jboss.pnc.dto.BuildConfiguration buildConfiguration) {
        this.buildConfigRevisionHelper.updateBuildConfiguration(id, buildConfiguration);
        return this.buildConfigRevisionHelper.findRevision((Integer)this.parseId(id), buildConfiguration);
    }

    @Override
    public Page<org.jboss.pnc.dto.BuildConfiguration> getBuildConfigurationsForProductVersion(int pageIndex, int pageSize, String sortingRsql, String query, String productVersionId) {
        ValidationBuilder.validateObject(null).validateAgainstRepository(this.productVersionRepository, Integer.valueOf(productVersionId), true);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withProductVersionId((Integer)Integer.valueOf(productVersionId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public Page<org.jboss.pnc.dto.BuildConfiguration> getBuildConfigurationsForProject(int pageIndex, int pageSize, String sortingRsql, String query, String projectId) {
        ValidationBuilder.validateObject(null).validateAgainstRepository(this.projectRepository, Integer.valueOf(projectId), true);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withProjectId((Integer)Integer.valueOf(projectId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public Page<org.jboss.pnc.dto.BuildConfiguration> getBuildConfigurationsForScmRepository(int pageIndex, int pageSize, String sortingRsql, String query, String scmRepositoryId) {
        ValidationBuilder.validateObject(null).validateAgainstRepository(this.repositoryConfigurationRepository, Integer.valueOf(scmRepositoryId), true);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withScmRepositoryId((Integer)Integer.valueOf(scmRepositoryId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public Page<BuildConfigurationWithLatestBuild> getBuildConfigurationIncludeLatestBuild(int pageIndex, int pageSize, String sortingRsql, String query) {
        List runningBuilds;
        Page buildConfigs = this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.isNotArchived());
        List configIds = buildConfigs.getContent().stream().map(bc -> (Integer)this.mapper.getIdMapper().toEntity((Object)bc.getId())).collect(Collectors.toList());
        List latestBuilds = this.buildRecordRepository.getLatestBuildsForBuildConfigs(configIds);
        try {
            runningBuilds = this.buildCoordinator.getSubmittedBuildTasks();
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
        ArrayList bcsWithLatest = new ArrayList();
        buildConfigs.getContent().forEach(bc -> bcsWithLatest.add(this.populateBuildConfigWithLatestBuild((org.jboss.pnc.dto.BuildConfiguration)bc, latestBuilds, runningBuilds)));
        return new Page(pageIndex, pageSize, buildConfigs.getTotalPages(), buildConfigs.getTotalHits(), bcsWithLatest);
    }

    private BuildConfigurationWithLatestBuild populateBuildConfigWithLatestBuild(org.jboss.pnc.dto.BuildConfiguration buildConfig, List<BuildRecord> latestBuilds, List<BuildTask> runningBuilds) {
        Integer bcId = (Integer)this.mapper.getIdMapper().toEntity((Object)buildConfig.getId());
        Optional<BuildTask> latestBuildTask = runningBuilds.stream().filter(Objects::nonNull).filter(bt -> bt.getBuildConfigurationAudited().getId().equals(bcId)).max(Comparator.comparing(BuildTask::getSubmitTime));
        Optional<BuildRecord> latestBuildRecord = latestBuilds.stream().filter(br -> br.getBuildConfigurationId().equals(bcId)).findFirst();
        BuildRef latestBuild = latestBuildTask.map(bt -> this.buildMapper.fromBuildTask(bt)).orElse(latestBuildRecord.map(arg_0 -> ((BuildMapper)this.buildMapper).toRef(arg_0)).orElse(null));
        String latestBuildUsername = latestBuildTask.map(bt -> bt.getUser().getUsername()).orElse(latestBuildRecord.map(br -> br.getUser().getUsername()).orElse(null));
        return BuildConfigurationWithLatestBuild.builderWithLatestBuild().buildConfig(buildConfig).latestBuild(latestBuild).latestBuildUsername(latestBuildUsername).build();
    }

    @Override
    public org.jboss.pnc.dto.BuildConfiguration clone(String buildConfigurationId) {
        ValidationBuilder.validateObject(WhenCreatingNew.class).validateAgainstRepository(this.repository, Integer.valueOf(buildConfigurationId), true);
        BuildConfiguration buildConfiguration = (BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(buildConfigurationId));
        org.jboss.pnc.model.User user = this.userService.currentUser();
        BuildConfiguration clonedBuildConfiguration = buildConfiguration.clone();
        Long id = this.sequenceHandlerRepository.getNextID("build_configuration_id_seq");
        clonedBuildConfiguration.setId(Integer.valueOf(id.intValue()));
        clonedBuildConfiguration.setCreationUser(user);
        clonedBuildConfiguration.setLastModificationUser(user);
        clonedBuildConfiguration = (BuildConfiguration)this.repository.save((GenericEntity)clonedBuildConfiguration);
        this.repository.flushAndRefresh((GenericEntity)clonedBuildConfiguration);
        this.logger.debug("Cloned saved BuildConfiguration: {}", (Object)clonedBuildConfiguration);
        return (org.jboss.pnc.dto.BuildConfiguration)this.mapper.toDTO((GenericEntity)clonedBuildConfiguration);
    }

    @Override
    public void addDependency(String configId, String dependencyId) {
        BuildConfiguration buildConfig = (BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(configId));
        BuildConfiguration dependency = (BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(dependencyId));
        ValidationBuilder.validateObject(buildConfig, WhenUpdating.class).validateCondition(buildConfig != null, "No build config exists with id: " + configId).validateCondition(dependency != null, "No dependency build config exists with id: " + dependencyId).validateCondition(!configId.equals(dependencyId), "A build configuration cannot depend on itself").validateCondition(!dependency.getAllDependencies().contains(buildConfig), "Cannot add dependency from : " + configId + " to: " + dependencyId + " because it would introduce a cyclic dependency");
        this.logger.debug("Didn't throw any validation errors");
        buildConfig.addDependency(dependency);
        this.repository.save((GenericEntity)buildConfig);
    }

    @Override
    public void removeDependency(String configId, String dependencyId) {
        BuildConfiguration buildConfig = (BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(configId));
        BuildConfiguration dependency = (BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(dependencyId));
        ValidationBuilder.validateObject(buildConfig, WhenUpdating.class).validateCondition(buildConfig != null, "No build config exists with id: " + configId).validateCondition(dependency != null, "No dependency build config exists with id: " + dependencyId);
        buildConfig.removeDependency(dependency);
        this.repository.save((GenericEntity)buildConfig);
    }

    @Override
    public Page<org.jboss.pnc.dto.BuildConfiguration> getDependencies(int pageIndex, int pageSize, String sortingRsql, String query, String configId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withDependantConfiguration((Integer)Integer.valueOf(configId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public Page<org.jboss.pnc.dto.BuildConfiguration> getDependants(int pageIndex, int pageSize, String sortingRsql, String query, String configId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withDependencyConfiguration((Integer)Integer.valueOf(configId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public Page<BuildConfigurationRevision> getRevisions(int pageIndex, int pageSize, String id) {
        List auditedBuildConfigs = this.buildConfigurationAuditedRepository.findAllByIdOrderByRevDesc(Integer.valueOf(id));
        List toReturn = StreamHelper.nullableStreamOf((Collection)auditedBuildConfigs).map(arg_0 -> ((BuildConfigurationRevisionMapper)this.buildConfigurationRevisionMapper).toDTO(arg_0)).skip(pageIndex * pageSize).limit(pageSize).collect(Collectors.toList());
        int totalHits = auditedBuildConfigs.size();
        int totalPages = (totalHits + pageSize - 1) / pageSize;
        return new Page(pageIndex, pageSize, totalPages, totalHits, toReturn);
    }

    @Override
    public BuildConfigurationRevision getRevision(String id, Integer rev) {
        IdRev idRev = new IdRev(Integer.valueOf(id), rev);
        BuildConfigurationAudited auditedBuildConfig = this.buildConfigurationAuditedRepository.queryById(idRev);
        return this.buildConfigurationRevisionMapper.toDTO(auditedBuildConfig);
    }

    @Override
    public Page<org.jboss.pnc.dto.BuildConfiguration> getBuildConfigurationsForGroup(int pageIndex, int pageSize, String sortingRsql, String query, String groupConfigId) {
        ValidationBuilder.validateObject(null).validateAgainstRepository(this.buildConfigurationSetRepository, Integer.valueOf(groupConfigId), true);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationPredicates.withBuildConfigurationSetId((Integer)Integer.valueOf(groupConfigId)), BuildConfigurationPredicates.isNotArchived());
    }

    @Override
    public BuildConfigCreationResponse createWithScm(BuildConfigWithSCMRequest request) {
        BuildConfigCreationResponse response;
        ValidationBuilder.validateObject(request, WhenCreatingNew.class).validateNotEmptyArgument().validateAnnotations();
        org.jboss.pnc.dto.BuildConfiguration buildConfiguration = request.getBuildConfig();
        this.validateBeforeSaving(buildConfiguration.toBuilder().scmRepository(FAKE_REPOSITORY).build());
        Long buildConfigurationId = this.sequenceHandlerRepository.getNextID("build_configuration_id_seq");
        MDCUtils.addProcessContext((String)buildConfigurationId.toString());
        org.jboss.pnc.dto.BuildConfiguration newBuildConfigurationWithId = buildConfiguration.toBuilder().id(buildConfigurationId.toString()).build();
        RepositoryCreationResponse rcResponse = this.scmRepositoryProvider.createSCMRepository(request.getScmUrl(), request.getBuildConfig().getScmRevision(), request.getPreBuildSyncEnabled(), JobNotificationType.BUILD_CONFIG_CREATION, Optional.of(newBuildConfigurationWithId));
        if (rcResponse.getTaskId() == null) {
            this.createBuildConfigurationWithRepository(null, Integer.parseInt(rcResponse.getRepository().getId()), newBuildConfigurationWithId);
            BuildConfiguration buildConfigurationFromDB = (BuildConfiguration)this.repository.queryByPredicates(new Predicate[]{BuildConfigurationPredicates.withName((String)newBuildConfigurationWithId.getName()), BuildConfigurationPredicates.isNotArchived()});
            response = new BuildConfigCreationResponse((org.jboss.pnc.dto.BuildConfiguration)this.mapper.toDTO((GenericEntity)buildConfigurationFromDB));
        } else {
            response = new BuildConfigCreationResponse(rcResponse.getTaskId().toString());
        }
        MDCUtils.removeProcessContext();
        return response;
    }

    @Override
    public Optional<org.jboss.pnc.dto.BuildConfiguration> restoreRevision(String id, int rev) {
        IdRev idRev = new IdRev(Integer.valueOf(id), Integer.valueOf(rev));
        BuildConfigurationAudited buildConfigurationAudited = this.buildConfigurationAuditedRepository.queryById(idRev);
        BuildConfiguration originalBC = (BuildConfiguration)this.repository.queryById((Serializable)Integer.valueOf(id));
        org.jboss.pnc.model.User user = this.userService.currentUser();
        if (buildConfigurationAudited == null || originalBC == null) {
            return Optional.empty();
        }
        originalBC.setName(buildConfigurationAudited.getName());
        originalBC.setBuildScript(buildConfigurationAudited.getBuildScript());
        originalBC.setRepositoryConfiguration(buildConfigurationAudited.getRepositoryConfiguration());
        originalBC.setScmRevision(buildConfigurationAudited.getScmRevision());
        originalBC.setBuildType(buildConfigurationAudited.getBuildType());
        originalBC.setBuildEnvironment(buildConfigurationAudited.getBuildEnvironment());
        originalBC.setGenericParameters(buildConfigurationAudited.getGenericParameters());
        originalBC.setLastModificationUser(user);
        BuildConfiguration newBc = (BuildConfiguration)this.repository.save((GenericEntity)originalBC);
        newBc.getBuildConfigurationSets().forEach(BuildConfigurationSet::getId);
        newBc.getDependencies().forEach(BuildConfiguration::getId);
        this.repository.flushAndRefresh((GenericEntity)newBc);
        return Optional.of((org.jboss.pnc.dto.BuildConfiguration)this.mapper.toDTO((GenericEntity)newBc));
    }

    @Override
    public void createBuildConfigurationWithRepository(String taskId, int scmRepositoryId, org.jboss.pnc.dto.BuildConfiguration configuration) {
        boolean sendMessage;
        RepositoryConfiguration repositoryConfiguration = (RepositoryConfiguration)this.repositoryConfigurationRepository.queryById((Serializable)Integer.valueOf(scmRepositoryId));
        boolean bl = sendMessage = taskId != null;
        if (repositoryConfiguration == null) {
            String errorMessage = "Repository Configuration was not found in database.";
            this.logger.error(errorMessage);
            if (sendMessage) {
                this.sendErrorMessage(SCMRepository.builder().id(Integer.toString(scmRepositoryId)).build(), null, errorMessage, taskId);
                return;
            }
            throw new RepositoryViolationException("Repository Configuration was not found in database.");
        }
        BuildConfiguration buildConfiguration = (BuildConfiguration)this.mapper.toEntity((DTOEntity)configuration);
        buildConfiguration.setRepositoryConfiguration(repositoryConfiguration);
        BuildConfiguration buildConfigurationSaved = (BuildConfiguration)this.repository.save((GenericEntity)buildConfiguration);
        Set<Integer> bcSetIds = configuration.getGroupConfigs() == null ? Collections.emptySet() : configuration.getGroupConfigs().keySet().stream().map(Integer::valueOf).collect(Collectors.toSet());
        SCMRepository scmRepository = this.scmRepositoryMapper.toDTO(repositoryConfiguration);
        org.jboss.pnc.dto.BuildConfiguration buildConfig = (org.jboss.pnc.dto.BuildConfiguration)this.mapper.toDTO((GenericEntity)buildConfigurationSaved);
        try {
            this.addBuildConfigurationToSet(buildConfigurationSaved, bcSetIds);
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            if (sendMessage) {
                this.sendErrorMessage(scmRepository, (BuildConfigurationRef)buildConfig, e.getMessage(), taskId);
                return;
            }
            throw new RepositoryViolationException("Failed to add BuildConfig to BuildConfigSets.");
        }
        this.logger.info("Created Build Configuration with Repository: {}.", (Object)buildConfig);
        if (sendMessage) {
            BuildConfigurationCreation successMessage = BuildConfigurationCreation.success((SCMRepository)scmRepository, (BuildConfigurationRef)buildConfig, (String)taskId);
            this.notifier.sendMessage((Object)successMessage);
        }
    }

    private void addBuildConfigurationToSet(BuildConfiguration buildConfig, Set<Integer> bcSetIds) {
        HashSet<String> notFoundSets = null;
        for (Integer setId : bcSetIds) {
            BuildConfigurationSet bcSet = (BuildConfigurationSet)this.buildConfigurationSetRepository.queryById((Serializable)setId);
            if (bcSet == null) {
                if (notFoundSets == null) {
                    notFoundSets = new HashSet<String>();
                }
                notFoundSets.add(setId.toString());
                continue;
            }
            if (bcSet.getBuildConfigurations().contains(buildConfig)) continue;
            bcSet.addBuildConfiguration(buildConfig);
            this.buildConfigurationSetRepository.save((GenericEntity)bcSet);
        }
        if (notFoundSets != null) {
            String ids = String.join((CharSequence)", ", notFoundSets);
            throw new IllegalArgumentException("No group configuration exists for ids: " + ids);
        }
    }

    private void sendErrorMessage(SCMRepository scmRepository, BuildConfigurationRef buildConfig, String message, String taskId) {
        BuildConfigurationCreation errorMessage = BuildConfigurationCreation.error((SCMRepository)scmRepository, (BuildConfigurationRef)buildConfig, (String)message, (String)taskId);
        this.notifier.sendMessage((Object)errorMessage);
    }
}

