/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql;

import cz.jirutka.rsql.parser.ast.AndNode;
import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.ComparisonOperator;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.Node;
import cz.jirutka.rsql.parser.ast.OrNode;
import cz.jirutka.rsql.parser.ast.RSQLOperators;
import java.lang.invoke.MethodHandles;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.query.criteria.internal.path.SingularAttributePath;
import org.jboss.pnc.facade.rsql.RSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.RSQLProducerImpl;
import org.jboss.pnc.facade.rsql.RSQLSelectorPath;
import org.jboss.pnc.facade.rsql.converter.Value;
import org.jboss.pnc.facade.rsql.converter.ValueConverter;
import org.jboss.pnc.model.GenericEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EntityRSQLNodeTraveller<DB extends GenericEntity<Integer>>
extends RSQLNodeTraveller<Predicate> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final char ESCAPE_CHAR = '\\';
    private final Root<DB> root;
    private final CriteriaBuilder cb;
    private final BiFunction<From<?, DB>, RSQLSelectorPath, Path> toPath;
    private ValueConverter valueConverter;

    public EntityRSQLNodeTraveller(Root<DB> root, CriteriaBuilder cb, BiFunction<From<?, DB>, RSQLSelectorPath, Path> toPath, ValueConverter valueConverter) {
        this.root = root;
        this.cb = cb;
        this.toPath = toPath;
        this.valueConverter = valueConverter;
    }

    @Override
    public Predicate visit(LogicalNode node) {
        logger.trace("Parsing LogicalNode {}", (Object)node);
        return this.proceedEmbeddedNodes(node);
    }

    @Override
    public Predicate visit(ComparisonNode node) {
        logger.trace("Parsing ComparisonNode {}", (Object)node);
        return this.proceedSelection(node);
    }

    private Predicate proceedSelection(ComparisonNode node) {
        RSQLSelectorPath selector = RSQLSelectorPath.get(node.getSelector());
        Path path = this.toPath.apply((From<?, DB>)this.root, selector);
        List arguments = node.getArguments();
        ComparisonOperator operator = node.getOperator();
        if (RSQLOperators.EQUAL.equals((Object)operator)) {
            Object argument = this.valueConverter.convert(this.getValue(path, (String)arguments.get(0)));
            return this.cb.equal((Expression)path, argument);
        }
        if (RSQLOperators.NOT_EQUAL.equals((Object)operator)) {
            Object argument = this.valueConverter.convert(this.getValue(path, (String)arguments.get(0)));
            return this.cb.notEqual((Expression)path, argument);
        }
        if (RSQLOperators.GREATER_THAN.equals((Object)operator)) {
            Comparable argument = this.valueConverter.convertComparable(this.getValue(path, (String)arguments.get(0)));
            return this.cb.greaterThan((Expression)path, argument);
        }
        if (RSQLOperators.GREATER_THAN_OR_EQUAL.equals((Object)operator)) {
            Comparable argument = this.valueConverter.convertComparable(this.getValue(path, (String)arguments.get(0)));
            return this.cb.greaterThanOrEqualTo((Expression)path, argument);
        }
        if (RSQLOperators.LESS_THAN.equals((Object)operator)) {
            Comparable argument = this.valueConverter.convertComparable(this.getValue(path, (String)arguments.get(0)));
            return this.cb.lessThan((Expression)path, argument);
        }
        if (RSQLOperators.LESS_THAN_OR_EQUAL.equals((Object)operator)) {
            Comparable argument = this.valueConverter.convertComparable(this.getValue(path, (String)arguments.get(0)));
            return this.cb.lessThanOrEqualTo((Expression)path, argument);
        }
        if (RSQLOperators.IN.equals((Object)operator)) {
            List<Object> castArguments = this.castArguments(arguments, path);
            return path.in(castArguments);
        }
        if (RSQLOperators.NOT_IN.equals((Object)operator)) {
            List<Object> castArguments = this.castArguments(arguments, path);
            return this.cb.not((Expression)path.in(castArguments));
        }
        if (RSQLProducerImpl.LIKE.equals((Object)operator)) {
            return this.cb.like(this.cb.lower((Expression)path), this.preprocessLikeOperatorArgument(((String)arguments.get(0)).toLowerCase()), '\\');
        }
        if (RSQLProducerImpl.NOT_LIKE.equals((Object)operator)) {
            return this.cb.not((Expression)this.cb.like(this.cb.lower((Expression)path), this.preprocessLikeOperatorArgument(((String)arguments.get(0)).toLowerCase()), '\\'));
        }
        if (RSQLProducerImpl.IS_NULL.equals((Object)operator)) {
            if (Boolean.parseBoolean((String)arguments.get(0))) {
                return this.cb.isNull((Expression)path);
            }
            return this.cb.isNotNull((Expression)path);
        }
        throw new UnsupportedOperationException("Not Implemented yet!");
    }

    private Value getValue(Path path, String argument) {
        SingularAttribute pathAttribute = ((SingularAttributePath)path).getAttribute();
        Class<?> entityClass = pathAttribute.getJavaMember().getDeclaringClass();
        return new Value(entityClass, pathAttribute.getName(), path.getJavaType(), argument);
    }

    private Predicate proceedEmbeddedNodes(LogicalNode node) {
        Iterator iterator = node.iterator();
        Predicate p1 = (Predicate)this.visit((Node)iterator.next());
        Predicate p2 = (Predicate)this.visit((Node)iterator.next());
        if (node instanceof AndNode) {
            Predicate pCombined = this.cb.and((Expression)p1, (Expression)p2);
            while (iterator.hasNext()) {
                Predicate pNext = (Predicate)this.visit((Node)iterator.next());
                pCombined = this.cb.and((Expression)pCombined, (Expression)pNext);
            }
            return pCombined;
        }
        if (node instanceof OrNode) {
            Predicate pCombined = this.cb.or((Expression)p1, (Expression)p2);
            while (iterator.hasNext()) {
                Predicate pNext = (Predicate)this.visit((Node)iterator.next());
                pCombined = this.cb.or((Expression)pCombined, (Expression)pNext);
            }
            return pCombined;
        }
        throw new UnsupportedOperationException("Logical operation not supported");
    }

    private String preprocessLikeOperatorArgument(String argument) {
        return argument.replaceAll("_", Matcher.quoteReplacement("\\_")).replaceAll("\\?", "_").replaceAll("\\*", "%");
    }

    private List<Object> castArguments(List<String> arguments, Path path) {
        Stream<Object> objectStream = arguments.stream().map(a -> this.valueConverter.convert(this.getValue(path, (String)a)));
        return objectStream.collect(Collectors.toList());
    }
}

