/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.rsql;

import cz.jirutka.rsql.parser.ast.ComparisonNode;
import cz.jirutka.rsql.parser.ast.LogicalNode;
import cz.jirutka.rsql.parser.ast.Node;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Path;
import org.jboss.pnc.facade.rsql.RSQLException;
import org.jboss.pnc.facade.rsql.RSQLNodeTraveller;
import org.jboss.pnc.facade.rsql.RSQLProducerImpl;
import org.jboss.pnc.facade.rsql.RSQLSelectorPath;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.api.OrderInfo;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.DefaultOrderInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.DefaultSortInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SortRSQLNodeTraveller<DB extends GenericEntity<Integer>>
extends RSQLNodeTraveller<SortInfo<DB>> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final BiFunction<From<?, DB>, RSQLSelectorPath, Path> toPath;

    public SortRSQLNodeTraveller(BiFunction<From<?, DB>, RSQLSelectorPath, Path> toPath) {
        this.toPath = toPath;
    }

    @Override
    public SortInfo<DB> visit(LogicalNode logicalNode) {
        List orders = logicalNode.getChildren().stream().flatMap(n -> ((SortInfo)this.visit((Node)n)).orders().stream()).collect(Collectors.toList());
        return new DefaultSortInfo(orders);
    }

    @Override
    public SortInfo<DB> visit(ComparisonNode node) {
        OrderInfo.SortingDirection sortingDirection;
        if (node.getOperator().equals((Object)RSQLProducerImpl.ASC)) {
            sortingDirection = OrderInfo.SortingDirection.ASC;
        } else if (node.getOperator().equals((Object)RSQLProducerImpl.DESC)) {
            sortingDirection = OrderInfo.SortingDirection.DESC;
        } else {
            throw new UnsupportedOperationException("Unsupported sorting: " + node.getOperator());
        }
        logger.trace("Sorting direction - {}, arguments {}", (Object)sortingDirection, (Object)node.getArguments());
        ArrayList<DefaultOrderInfo> orders = new ArrayList<DefaultOrderInfo>();
        for (String argument : node.getArguments()) {
            RSQLSelectorPath path;
            RSQLSelectorPath last = path = RSQLSelectorPath.get(argument);
            while (!last.isFinal()) {
                last = last.next();
            }
            if ("id".equals(last.getElement())) {
                throw new RSQLException("Sorting by id is not supported.");
            }
            orders.add(new DefaultOrderInfo(sortingDirection, root -> (Expression)this.toPath.apply((From<?, DB>)root, path)));
        }
        return new DefaultSortInfo(orders);
    }
}

