/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.DenyAll;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.ws.rs.NotFoundException;
import org.commonjava.atlas.maven.ident.ref.InvalidRefException;
import org.jboss.pnc.common.maven.Gav;
import org.jboss.pnc.common.util.StreamHelper;
import org.jboss.pnc.coordinator.maintenance.BlacklistAsyncInvoker;
import org.jboss.pnc.dto.ArtifactRef;
import org.jboss.pnc.dto.ArtifactRevision;
import org.jboss.pnc.dto.User;
import org.jboss.pnc.dto.response.ArtifactInfo;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.BuildCategory;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.ArtifactProvider;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.mapper.api.ArtifactMapper;
import org.jboss.pnc.mapper.api.ArtifactRevisionMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.UserMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.ArtifactAudited;
import org.jboss.pnc.model.Artifact_;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.TargetRepository_;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class ArtifactProviderImpl
extends AbstractUpdatableProvider<Integer, Artifact, org.jboss.pnc.dto.Artifact, ArtifactRef>
implements ArtifactProvider {
    private static final Logger log = LoggerFactory.getLogger(ArtifactProviderImpl.class);
    private static Logger logger = LoggerFactory.getLogger(ArtifactProviderImpl.class);
    private static final EnumSet<ArtifactQuality> USER_ALLOWED_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.NEW, ArtifactQuality.VERIFIED, ArtifactQuality.TESTED, ArtifactQuality.DEPRECATED);
    private static final EnumSet<ArtifactQuality> ADMIN_ALLOWED_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.NEW, new ArtifactQuality[]{ArtifactQuality.VERIFIED, ArtifactQuality.TESTED, ArtifactQuality.DEPRECATED, ArtifactQuality.BLACKLISTED, ArtifactQuality.DELETED});
    private static final EnumSet<ArtifactQuality> NOT_MODIFIABLE_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.DELETED, ArtifactQuality.BLACKLISTED);
    private static final EnumSet<ArtifactQuality> DA_SYNCRONIZED_ARTIFACT_QUALITIES = EnumSet.of(ArtifactQuality.DELETED, ArtifactQuality.BLACKLISTED);
    private static final String MVN_BLACKLIST_JSON_PAYLOAD = "{\"groupId\":\"%s\",\"artifactId\":\"%s\",\"version\":\"%s\"}";
    private ArtifactRevisionMapper artifactRevisionMapper;
    private ProductMilestoneMapper productMilestoneMapper;
    private ArtifactAuditedRepository artifactAuditedRepository;
    private BlacklistAsyncInvoker blacklistAsyncInvoker;
    private UserService userService;
    private UserMapper userMapper;
    @Inject
    private EntityManager em;

    @Inject
    public ArtifactProviderImpl(ArtifactRepository repository, ArtifactMapper mapper, ArtifactRevisionMapper artifactRevisionMapper, ProductMilestoneMapper productMilestoneMapper, ArtifactAuditedRepository artifactAuditedRepository, BlacklistAsyncInvoker blacklistAsyncInvoker, UserService userService, UserMapper userMapper) {
        super(repository, mapper, Artifact.class);
        this.artifactRevisionMapper = artifactRevisionMapper;
        this.productMilestoneMapper = productMilestoneMapper;
        this.artifactAuditedRepository = artifactAuditedRepository;
        this.blacklistAsyncInvoker = blacklistAsyncInvoker;
        this.userService = userService;
        this.userMapper = userMapper;
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getAll(int pageIndex, int pageSize, String sortingRsql, String query, Optional<String> sha256, Optional<String> md5, Optional<String> sha1) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withSha256(sha256), ArtifactPredicates.withMd5(md5), ArtifactPredicates.withSha1(sha1));
    }

    @Override
    public Page<ArtifactInfo> getAllFiltered(int pageIndex, int pageSize, Optional<String> identifierPattern, Set<ArtifactQuality> qualities, Optional<RepositoryType> repoType, Set<BuildCategory> buildCategories) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery<Tuple> query = this.artifactInfoQuery(cb, identifierPattern, qualities, repoType, buildCategories);
        int offset = pageIndex * pageSize;
        List artifacts = this.em.createQuery(query).setMaxResults(pageSize).setFirstResult(offset).getResultList().stream().map(this::mapTupleToArtifactInfo).collect(Collectors.toList());
        org.jboss.pnc.spi.datastore.repositories.api.Predicate<Artifact>[] predicates = this.getPredicates(identifierPattern, qualities, repoType, buildCategories);
        int totalHits = this.repository.count(predicates);
        int totalPages = (totalHits + pageSize - 1) / pageSize;
        return new Page(pageIndex, pageSize, totalPages, totalHits, artifacts);
    }

    @Override
    @RolesAllowed(value={"pnc-app-artifact-user", "pnc-users-admin"})
    public org.jboss.pnc.dto.Artifact store(org.jboss.pnc.dto.Artifact restEntity) throws DTOValidationException {
        org.jboss.pnc.model.User currentUser = this.userService.currentUser();
        User user = this.userMapper.toDTO(currentUser);
        Instant now = Instant.now();
        return super.store(restEntity.toBuilder().creationUser(user).modificationUser(user).creationTime(now).modificationTime(now).build());
    }

    @Override
    protected void preUpdate(Artifact dbEntity, org.jboss.pnc.dto.Artifact restEntity) {
        if (!this.equalAuditedValues(dbEntity, restEntity)) {
            org.jboss.pnc.model.User currentUser = this.userService.currentUser();
            dbEntity.setModificationUser(currentUser);
            dbEntity.setModificationTime(new Date());
        }
    }

    private boolean equalAuditedValues(Artifact persisted, org.jboss.pnc.dto.Artifact toUpdate) {
        return Objects.equals(persisted.getArtifactQuality(), toUpdate.getArtifactQuality()) && Objects.equals(persisted.getQualityLevelReason(), toUpdate.getQualityLevelReason());
    }

    @Override
    public ArtifactRevision createQualityLevelRevision(String id, String quality, String reason) throws DTOValidationException {
        boolean isLoggedInUserAdmin = this.userService.hasLoggedInUserRole("pnc-users-admin");
        boolean isLoggedInUserArtifactAdmin = this.userService.hasLoggedInUserRole("pnc-app-artifact-user");
        boolean isLoggedInBuildAdmin = this.userService.hasLoggedInUserRole("pnc-app-build-user");
        boolean isLoggedInUserSystemUser = isLoggedInUserAdmin || isLoggedInUserArtifactAdmin || isLoggedInBuildAdmin;
        ArtifactQuality newQuality = this.validateProvidedArtifactQuality(quality, isLoggedInUserSystemUser);
        org.jboss.pnc.dto.Artifact artifact = (org.jboss.pnc.dto.Artifact)this.getSpecific(id);
        if (artifact == null) {
            throw new InvalidEntityException("Artifact with id: " + id + " does not exist.");
        }
        this.validateIfArtifactQualityIsModifiable(artifact, newQuality);
        this.update(id, artifact.toBuilder().artifactQuality(newQuality).qualityLevelReason(reason).build());
        ArtifactAudited latestRevision = this.artifactAuditedRepository.findLatestById(Integer.parseInt(id));
        if (latestRevision == null) {
            throw new RepositoryViolationException("Entity should exist in the DB");
        }
        if (DA_SYNCRONIZED_ARTIFACT_QUALITIES.contains(newQuality)) {
            String jsonPayload = this.createBlacklistJSONPayload(artifact);
            this.blacklistAsyncInvoker.notifyBlacklistToDA(jsonPayload);
        }
        return this.artifactRevisionMapper.toDTO(latestRevision);
    }

    private String createBlacklistJSONPayload(org.jboss.pnc.dto.Artifact artifact) {
        switch (artifact.getTargetRepository().getRepositoryType()) {
            case MAVEN: {
                try {
                    Gav gav = Gav.parse((String)artifact.getIdentifier());
                    return String.format(MVN_BLACKLIST_JSON_PAYLOAD, gav.getGroupId(), gav.getArtifactId(), gav.getVersion());
                }
                catch (InvalidRefException e) {
                    log.info("Gav coordinates could not be calculated for identifier '{}', the artifact will not be blocklisted in DA", (Object)artifact.getIdentifier());
                    return null;
                }
            }
        }
        return null;
    }

    @Override
    @DenyAll
    public void delete(String id) throws DTOValidationException {
        throw new UnsupportedOperationException("Direct artifact manipulation is not available.");
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getBuiltArtifactsForBuild(int pageIndex, int pageSize, String sortingRsql, String query, String buildId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withBuildRecordId((Base32LongID)BuildMapper.idMapper.toEntity(buildId)));
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getArtifactsForTargetRepository(int pageIndex, int pageSize, String sortingRsql, String query, Integer targetRepositoryId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withTargetRepositoryId((Integer)targetRepositoryId));
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getDependantArtifactsForBuild(int pageIndex, int pageSize, String sortingRsql, String query, String buildId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withDependantBuildRecordId((Base32LongID)BuildMapper.idMapper.toEntity(buildId)));
    }

    @Override
    public Page<org.jboss.pnc.dto.Artifact> getDeliveredArtifactsForMilestone(int pageIndex, int pageSize, String sortingRsql, String query, String milestoneId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ArtifactPredicates.withDeliveredInProductMilestone((Integer)((Integer)this.productMilestoneMapper.getIdMapper().toEntity((Object)milestoneId))));
    }

    @Override
    public Page<ArtifactRevision> getRevisions(int pageIndex, int pageSize, String id) {
        List auditedBuildConfigs = this.artifactAuditedRepository.findAllByIdOrderByRevDesc(Integer.valueOf(id));
        List toReturn = StreamHelper.nullableStreamOf((Collection)auditedBuildConfigs).map(arg_0 -> ((ArtifactRevisionMapper)this.artifactRevisionMapper).toDTO(arg_0)).skip(pageIndex * pageSize).limit(pageSize).collect(Collectors.toList());
        int totalHits = auditedBuildConfigs.size();
        int totalPages = (totalHits + pageSize - 1) / pageSize;
        return new Page(pageIndex, pageSize, totalPages, totalHits, toReturn);
    }

    @Override
    public ArtifactRevision getRevision(String id, Integer rev) {
        IdRev idRev = new IdRev(Integer.valueOf(id), rev);
        ArtifactAudited auditedArtifact = this.artifactAuditedRepository.queryById(idRev);
        return this.artifactRevisionMapper.toDTO(auditedArtifact);
    }

    @Override
    public org.jboss.pnc.dto.Artifact getSpecificFromPurl(String purl) {
        Artifact artifact = ((ArtifactRepository)this.repository).withPurl(purl);
        if (artifact == null) {
            throw new NotFoundException();
        }
        return (org.jboss.pnc.dto.Artifact)this.mapper.toDTO((GenericEntity)artifact);
    }

    private CriteriaQuery<Tuple> artifactInfoQuery(CriteriaBuilder cb, Optional<String> identifierPattern, Set<ArtifactQuality> qualities, Optional<RepositoryType> repoType, Set<BuildCategory> buildCategories) {
        CriteriaQuery query = cb.createTupleQuery();
        Root artifact = query.from(Artifact.class);
        Path repository = artifact.get(Artifact_.targetRepository);
        query.multiselect(new Selection[]{artifact.get(Artifact_.id), artifact.get(Artifact_.identifier), artifact.get(Artifact_.artifactQuality), repository.get(TargetRepository_.repositoryType), artifact.get(Artifact_.buildCategory)});
        ArrayList<Predicate> predicates = new ArrayList<Predicate>(4);
        if (identifierPattern.isPresent()) {
            Predicate withIdentifierLike = cb.like((Expression)artifact.get(Artifact_.identifier), identifierPattern.get().replace("*", "%"));
            predicates.add(withIdentifierLike);
        }
        if (!qualities.isEmpty()) {
            Predicate withQualityIn = artifact.get(Artifact_.artifactQuality).in(qualities);
            predicates.add(withQualityIn);
        }
        if (!buildCategories.isEmpty()) {
            Predicate withBuildCategoryIn = artifact.get(Artifact_.buildCategory).in(buildCategories);
            predicates.add(withBuildCategoryIn);
        }
        if (repoType.isPresent()) {
            Predicate withRepoType = cb.equal((Expression)artifact.join(Artifact_.targetRepository).get(TargetRepository_.repositoryType), (Object)repoType.get());
            predicates.add(withRepoType);
        }
        query.where((Expression)cb.and(predicates.toArray(new Predicate[predicates.size()])));
        query.orderBy(new Order[]{cb.asc((Expression)artifact.get(Artifact_.id))});
        return query;
    }

    private org.jboss.pnc.spi.datastore.repositories.api.Predicate<Artifact>[] getPredicates(Optional<String> identifierPattern, Set<ArtifactQuality> qualities, Optional<RepositoryType> repoType, Set<BuildCategory> buildCategories) {
        ArrayList<org.jboss.pnc.spi.datastore.repositories.api.Predicate> predicates = new ArrayList<org.jboss.pnc.spi.datastore.repositories.api.Predicate>(4);
        if (identifierPattern.isPresent()) {
            org.jboss.pnc.spi.datastore.repositories.api.Predicate withIdentifierLike = ArtifactPredicates.withIdentifierLike((String)identifierPattern.get().replace("*", "%"));
            predicates.add(withIdentifierLike);
        }
        if (!qualities.isEmpty()) {
            org.jboss.pnc.spi.datastore.repositories.api.Predicate withQualityIn = ArtifactPredicates.withArtifactQualityIn(qualities);
            predicates.add(withQualityIn);
        }
        if (!buildCategories.isEmpty()) {
            org.jboss.pnc.spi.datastore.repositories.api.Predicate withBuildCategoryIn = ArtifactPredicates.withBuildCategoryIn(buildCategories);
            predicates.add(withBuildCategoryIn);
        }
        if (repoType.isPresent()) {
            org.jboss.pnc.spi.datastore.repositories.api.Predicate withRepoType = ArtifactPredicates.withTargetRepositoryRepositoryType((RepositoryType)repoType.get());
            predicates.add(withRepoType);
        }
        return predicates.toArray(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[predicates.size()]);
    }

    private ArtifactInfo mapTupleToArtifactInfo(Tuple tuple) {
        return ArtifactInfo.builder().id(tuple.get(0).toString()).identifier(tuple.get(1).toString()).artifactQuality((ArtifactQuality)tuple.get(2)).repositoryType((RepositoryType)tuple.get(3)).buildCategory((BuildCategory)tuple.get(4)).build();
    }

    private ArtifactQuality validateProvidedArtifactQuality(String quality, boolean isLoggedInUserSystemUser) {
        EnumSet<ArtifactQuality> allowedQualities;
        ArtifactQuality newQuality;
        try {
            newQuality = ArtifactQuality.valueOf((String)quality.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new InvalidEntityException("Artifact quality: " + quality + " does not exist.");
        }
        EnumSet<ArtifactQuality> enumSet = allowedQualities = isLoggedInUserSystemUser ? ADMIN_ALLOWED_ARTIFACT_QUALITIES : USER_ALLOWED_ARTIFACT_QUALITIES;
        if (!allowedQualities.contains(newQuality)) {
            throw new InvalidEntityException("Artifact quality level can be changed only to " + allowedQualities);
        }
        return newQuality;
    }

    private void validateIfArtifactQualityIsModifiable(org.jboss.pnc.dto.Artifact artifact, ArtifactQuality newQuality) {
        if (artifact.getArtifactQuality().equals((Object)newQuality)) {
            return;
        }
        if (NOT_MODIFIABLE_ARTIFACT_QUALITIES.contains(artifact.getArtifactQuality())) {
            throw new ConflictedEntryException("Artifact " + artifact.getId() + " with quality " + artifact.getArtifactQuality() + " cannot be changed to another quality level.", Artifact.class, artifact.getId());
        }
        if (ArtifactQuality.TEMPORARY.equals((Object)artifact.getArtifactQuality()) && !newQuality.equals((Object)ArtifactQuality.DELETED)) {
            throw new ConflictedEntryException("Temporary artifact " + artifact.getId() + " can only be changed to DELETED quality level.", Artifact.class, artifact.getId());
        }
    }
}

