/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.facade.util.MergeIterator;
import org.jboss.pnc.facade.validation.CorruptedDataException;
import org.jboss.pnc.mapper.Base32LongIdMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.IdMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.datastore.predicates.BuildConfigurationPredicates;
import org.jboss.pnc.spi.datastore.predicates.BuildRecordPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.CursorPageInfo;
import org.jboss.pnc.spi.exception.MissingDataException;
import org.jboss.pnc.spi.exception.RemoteRequestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class BuildFetcher {
    private static final Logger log = LoggerFactory.getLogger(BuildFetcher.class);
    @Inject
    private BuildMapper buildMapper;
    @Inject
    private BuildRecordRepository buildRecordRepository;
    @Inject
    private BuildCoordinator buildCoordinator;
    @Inject
    private BuildConfigSetRecordRepository buildConfigSetRecordRepository;
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    private BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    private final Map<String, BuildTask> buildTaskCache = new HashMap<String, BuildTask>();
    private final Map<Base32LongID, BuildRecord> buildRecordCache = new HashMap<Base32LongID, BuildRecord>();
    private final Set<Base32LongID> depsToFetch = new HashSet<Base32LongID>();
    private final Set<Base32LongID> depsProcessed = new HashSet<Base32LongID>();

    public BuildWithDeps getBuildWithDeps(String id) {
        BuildTask buildTask = this.buildTaskCache.get(id);
        if (buildTask != null) {
            return new BuildWithDeps(this.buildMapper.fromBuildTask(buildTask), buildTask);
        }
        Base32LongID dbid = (Base32LongID)this.buildMapper.getIdMapper().toEntity((Object)id);
        BuildRecord buildRecord = this.buildRecordCache.get(dbid);
        if (buildRecord == null) {
            buildRecord = (BuildRecord)this.buildRecordRepository.queryById((Serializable)dbid);
            if (buildRecord == null) {
                throw new CorruptedDataException("Missing build with id:" + id);
            }
            log.warn("Prefetch missed build {}", (Object)id);
            this.buildRecordCache.put(buildRecord.getId(), buildRecord);
        }
        return new BuildWithDeps(this.buildMapper.toDTO(buildRecord), buildRecord);
    }

    public static Comparator<BuildWrapper> wrapperComparator(Comparator<Build> comparator) {
        return (o1, o2) -> comparator.compare(o1.mappedBuild, o2.mappedBuild);
    }

    public List<Build> getBuildPage(int pageIndex, int pageSize, List<Build> runningBuilds, Predicate<BuildRecord>[] predicates, SortInfo<BuildRecord> sortInfo, Comparator<Build> comparing) {
        int firstPossibleDBIndex = pageIndex * pageSize - runningBuilds.size();
        int lastPossibleDBIndex = (pageIndex + 1) * pageSize - 1;
        int toSkip = Math.min(runningBuilds.size(), pageIndex * pageSize);
        Iterator wrappedRunningBuilds = runningBuilds.stream().sorted(comparing).map(x$0 -> new BuildWrapper((Build)x$0)).iterator();
        BuildIterator buildIterator = new BuildIterator(firstPossibleDBIndex, lastPossibleDBIndex, pageSize, sortInfo, predicates);
        MergeIterator<BuildWrapper> buildsIT = new MergeIterator<BuildWrapper>(wrappedRunningBuilds, buildIterator, BuildFetcher.wrapperComparator(comparing));
        List builds = StreamSupport.stream(Spliterators.spliteratorUnknownSize(buildsIT, 20), false).skip(toSkip).limit(pageSize).collect(Collectors.toList());
        this.fetchBuildConfigAudited(builds.stream().flatMap(BuildWrapper::buildRecordStream).collect(Collectors.toSet()));
        return builds.stream().map(BuildWrapper::getBuild).collect(Collectors.toList());
    }

    public void fetchRunningBuilds() {
        try {
            for (BuildTask buildTask : this.buildCoordinator.getSubmittedBuildTasks()) {
                this.buildTaskCache.put(buildTask.getId(), buildTask);
            }
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean buildExists(Base32LongID buildId) {
        this.fetchRunningBuilds();
        if (this.buildTaskCache.containsKey(buildId.getId())) {
            return true;
        }
        BuildRecord buildRecord = (BuildRecord)this.buildRecordRepository.queryById((Serializable)buildId);
        if (buildRecord == null) {
            return false;
        }
        this.buildRecordCache.put(buildRecord.getId(), buildRecord);
        return true;
    }

    public Set<Base32LongID> getGroupBuildContent(long buildConfigSetRecordId) {
        try {
            BuildConfigSetRecord buildGroup;
            HashSet<Base32LongID> buildIds = new HashSet<Base32LongID>();
            List buildTasks = this.buildCoordinator.getSubmittedBuildTasksBySetId(buildConfigSetRecordId);
            if (!buildTasks.isEmpty()) {
                this.fetchRunningBuilds();
                buildTasks.stream().map(BuildTask::getId).map(arg_0 -> ((IdMapper)this.buildMapper.getIdMapper()).toEntity(arg_0)).forEach(buildIds::add);
            }
            if ((buildGroup = (BuildConfigSetRecord)this.buildConfigSetRecordRepository.queryById((Serializable)Long.valueOf(buildConfigSetRecordId))) == null) {
                return Set.of();
            }
            buildGroup.getBuildRecords().stream().map(BuildRecord::getId).forEach(buildIds::add);
            return buildIds;
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    public void precacheAllBuildsDeps(Base32LongID buildId) {
        this.checkCacheForMissingDeps(buildId);
        this.fetchRemainingDeps();
        this.fetchBuildConfigAudited(this.buildRecordCache.values());
    }

    public void precacheAllBuildsDeps(Collection<Base32LongID> buildIds) {
        for (Base32LongID buildId : buildIds) {
            this.checkCacheForMissingDeps(buildId);
        }
        this.fetchRemainingDeps();
        this.fetchBuildConfigAudited(this.buildRecordCache.values());
    }

    private void checkBuildTasksForMissingDeps(String id) {
        Base32LongID dbId = (Base32LongID)this.buildMapper.getIdMapper().toEntity((Object)id);
        if (this.depsProcessed.contains(dbId)) {
            return;
        }
        BuildTask buildTask = this.buildTaskCache.get(id);
        if (buildTask == null) {
            this.depsToFetch.add(dbId);
        } else {
            this.depsProcessed.add(dbId);
            for (BuildTask dependency : buildTask.getDependencies()) {
                this.checkBuildTasksForMissingDeps(dependency.getId());
            }
            for (BuildTask dependant : buildTask.getDependants()) {
                this.checkBuildTasksForMissingDeps(dependant.getId());
            }
        }
    }

    private void checkCacheForMissingDeps(Base32LongID id) {
        if (this.depsProcessed.contains(id)) {
            return;
        }
        if (this.buildTaskCache.containsKey(id.getId())) {
            this.checkBuildTasksForMissingDeps(id.getId());
        } else if (this.buildRecordCache.containsKey(id)) {
            BuildRecord buildRecord = this.buildRecordCache.get(id);
            this.depsProcessed.add(id);
            for (Base32LongID dependency : buildRecord.getDependencyBuildRecordIds()) {
                this.checkCacheForMissingDeps(dependency);
            }
            for (Base32LongID dependant : buildRecord.getDependentBuildRecordIds()) {
                this.checkCacheForMissingDeps(dependant);
            }
        } else {
            this.depsToFetch.add(id);
        }
    }

    private void fetchRemainingDeps() {
        this.depsToFetch.removeAll(this.buildRecordCache.keySet());
        while (!this.depsToFetch.isEmpty()) {
            List buildRecords = this.buildRecordRepository.queryWithPredicates(new Predicate[]{BuildRecordPredicates.withIds(this.depsToFetch)});
            this.depsToFetch.clear();
            for (BuildRecord buildRecord : buildRecords) {
                this.buildRecordCache.put(buildRecord.getId(), buildRecord);
                if (this.depsProcessed.contains(buildRecord.getId())) continue;
                this.depsProcessed.add(buildRecord.getId());
                this.depsToFetch.addAll(buildRecord.getDependencyBuildRecordIds());
                this.depsToFetch.addAll(buildRecord.getDependentBuildRecordIds());
            }
            this.depsToFetch.removeAll(this.buildRecordCache.keySet());
        }
    }

    private void fetchBuildConfigAudited(Collection<BuildRecord> buildRecords) {
        if (buildRecords.isEmpty()) {
            return;
        }
        Set<IdRev> idRevs = buildRecords.stream().filter(buildRecord -> buildRecord.getBuildConfigurationAudited() == null).map(BuildRecord::getBuildConfigurationAuditedIdRev).collect(Collectors.toSet());
        this.prefetchFieldsOfBuildConfigs(idRevs);
        Map buildConfigRevisions = this.buildConfigurationAuditedRepository.queryById(idRevs);
        for (BuildRecord buildRecord2 : buildRecords) {
            if (buildRecord2.getBuildConfigurationAudited() != null) continue;
            IdRev idRev = buildRecord2.getBuildConfigurationAuditedIdRev();
            BuildConfigurationAudited buildConfigurationAudited = (BuildConfigurationAudited)buildConfigRevisions.get(idRev);
            buildRecord2.setBuildConfigurationAudited(buildConfigurationAudited);
        }
    }

    private void prefetchFieldsOfBuildConfigs(Set<IdRev> idRevs) {
        Set buildConfigIDs = idRevs.stream().map(IdRev::getId).collect(Collectors.toSet());
        this.buildConfigurationRepository.queryWithPredicates(new Predicate[]{BuildConfigurationPredicates.withIds(buildConfigIDs)});
    }

    public class BuildWrapper {
        private final BuildRecord buildRecord;
        private final Build mappedBuild;

        public BuildWrapper(BuildRecord buildRecord) {
            this.buildRecord = buildRecord;
            this.mappedBuild = BuildFetcher.this.buildMapper.toDTOWithoutBCR(buildRecord);
        }

        public BuildWrapper(Build build) {
            this.buildRecord = null;
            this.mappedBuild = build;
        }

        public Build getBuild() {
            if (this.buildRecord == null) {
                return this.mappedBuild;
            }
            return BuildFetcher.this.buildMapper.toDTO(this.buildRecord);
        }

        public Stream<BuildRecord> buildRecordStream() {
            return Stream.ofNullable(this.buildRecord);
        }
    }

    public class BuildIterator
    implements Iterator<BuildWrapper> {
        private final int maxPageSize;
        private final int lastIndex;
        private final SortInfo<BuildRecord> sortInfo;
        private final Predicate<BuildRecord>[] predicates;
        private List<BuildRecord> builds;
        private Iterator<BuildRecord> it;
        private int firstIndex;

        public BuildIterator(int firstIndex, int lastIndex, int pageSize, SortInfo<BuildRecord> sortInfo, Predicate<BuildRecord> ... predicate) {
            this.maxPageSize = Math.max(pageSize, 10);
            this.firstIndex = Math.max(firstIndex, 0);
            this.lastIndex = lastIndex;
            this.predicates = predicate;
            this.sortInfo = sortInfo;
            this.nextPage();
        }

        @Override
        public boolean hasNext() {
            if (this.it.hasNext()) {
                return true;
            }
            if (this.firstIndex > this.lastIndex) {
                return false;
            }
            this.nextPage();
            return this.it.hasNext();
        }

        @Override
        public BuildWrapper next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            return new BuildWrapper(this.it.next());
        }

        private void nextPage() {
            int size = this.lastIndex - this.firstIndex + 1;
            if (size > this.maxPageSize) {
                size = this.maxPageSize;
            }
            CursorPageInfo pageInfo = new CursorPageInfo(this.firstIndex, size);
            this.builds = BuildFetcher.this.buildRecordRepository.queryWithPredicates((PageInfo)pageInfo, this.sortInfo, this.predicates);
            this.it = this.builds.iterator();
            this.firstIndex = this.builds.size() < size ? this.lastIndex + 1 : (this.firstIndex += size);
        }
    }

    public static class BuildWithDeps {
        private final Build build;
        private final Collection<String> dependencies;
        private final Collection<String> dependants;

        public BuildWithDeps(Build build, BuildTask buildTask) {
            this.build = build;
            this.dependencies = buildTask.getDependencies().stream().map(BuildTask::getId).collect(Collectors.toSet());
            this.dependants = buildTask.getDependants().stream().map(BuildTask::getId).collect(Collectors.toSet());
        }

        public BuildWithDeps(Build build, BuildRecord buildRecord) {
            this.build = build;
            this.dependencies = buildRecord.getDependencyBuildRecordIds().stream().map(arg_0 -> ((Base32LongIdMapper)BuildMapper.idMapper).toDto(arg_0)).collect(Collectors.toSet());
            this.dependants = buildRecord.getDependentBuildRecordIds().stream().map(arg_0 -> ((Base32LongIdMapper)BuildMapper.idMapper).toDto(arg_0)).collect(Collectors.toSet());
        }

        public Build getBuild() {
            return this.build;
        }

        public Collection<String> getDependencies() {
            return this.dependencies;
        }

        public Collection<String> getDependants() {
            return this.dependants;
        }
    }
}

