/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.time.Instant;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.dto.PncStatus;
import org.jboss.pnc.dto.notification.GenericSettingNotification;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.GenericSetting;
import org.jboss.pnc.spi.datastore.repositories.GenericSettingRepository;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class GenericSettingProvider {
    private static final Logger log = LoggerFactory.getLogger(GenericSettingProvider.class);
    @Inject
    private GenericSettingRepository genericSettingRepository;
    @Inject
    private UserService userService;
    @Inject
    private Notifier notifier;

    @Deprecated
    public GenericSettingProvider() {
    }

    @RolesAllowed(value={"pnc-users-admin"})
    public void activateMaintenanceMode() {
        log.info("Activating Maintenance mode");
        GenericSetting maintenanceMode = this.createGenericParameterIfNotFound("MAINTENANCE_MODE");
        maintenanceMode.setValue(Boolean.TRUE.toString());
        this.genericSettingRepository.save((GenericEntity)maintenanceMode);
    }

    @RolesAllowed(value={"pnc-users-admin"})
    public void deactivateMaintenanceMode() {
        log.info("Deactivating Maintenance mode");
        GenericSetting maintenanceMode = this.genericSettingRepository.queryByKey("MAINTENANCE_MODE");
        if (maintenanceMode == null) {
            maintenanceMode = new GenericSetting();
            maintenanceMode.setKey("MAINTENANCE_MODE");
        }
        maintenanceMode.setValue(Boolean.FALSE.toString());
        this.genericSettingRepository.save((GenericEntity)maintenanceMode);
    }

    public boolean isInMaintenanceMode() {
        GenericSetting maintenanceMode = this.genericSettingRepository.queryByKey("MAINTENANCE_MODE");
        if (maintenanceMode == null) {
            return false;
        }
        return Boolean.parseBoolean(maintenanceMode.getValue());
    }

    public boolean isCurrentUserAllowedToTriggerBuilds() {
        boolean isLoggedInUserSystemUser = this.userService.hasLoggedInUserRole("pnc-users-admin");
        if (isLoggedInUserSystemUser) {
            log.info("Users with system-role are always allowed to trigger builds");
            return true;
        }
        return !this.isInMaintenanceMode();
    }

    @RolesAllowed(value={"pnc-users-admin"})
    public void setPNCVersion(String version) {
        log.info("PNC System version set to: '{}'", (Object)version);
        GenericSetting pncVersion = this.createGenericParameterIfNotFound("PNC_VERSION");
        pncVersion.setValue(version);
        this.genericSettingRepository.save((GenericEntity)pncVersion);
    }

    public String getPNCVersion() {
        GenericSetting pncVersion = this.genericSettingRepository.queryByKey("PNC_VERSION");
        if (pncVersion == null) {
            return "";
        }
        return pncVersion.getValue();
    }

    @RolesAllowed(value={"pnc-users-admin"})
    public void setAnnouncementBanner(String banner) {
        log.info("Announcement banner set to: '{}'", (Object)banner);
        GenericSetting announcementBanner = this.createGenericParameterIfNotFound("ANNOUNCEMENT_BANNER");
        announcementBanner.setValue(banner);
        this.genericSettingRepository.save((GenericEntity)announcementBanner);
    }

    public String getAnnouncementBanner() {
        GenericSetting announcementBanner = this.genericSettingRepository.queryByKey("ANNOUNCEMENT_BANNER");
        if (announcementBanner == null) {
            return "";
        }
        return announcementBanner.getValue();
    }

    @RolesAllowed(value={"pnc-users-admin"})
    public void clearAnnouncementBanner() {
        this.clearByKey("ANNOUNCEMENT_BANNER");
    }

    public PncStatus getPncStatus() {
        GenericSetting banner = this.genericSettingRepository.queryByKey("ANNOUNCEMENT_BANNER");
        GenericSetting eta = this.genericSettingRepository.queryByKey("ANNOUNCEMENT_ETA");
        return PncStatus.builder().banner(banner == null ? null : banner.getValue()).eta(eta == null ? null : Instant.parse(eta.getValue())).isMaintenanceMode(Boolean.valueOf(this.isInMaintenanceMode())).build();
    }

    @RolesAllowed(value={"pnc-users-admin"})
    public void setEta(String eta) {
        log.info("ETA set to: '{}'", (Object)eta);
        GenericSetting pncEta = this.createGenericParameterIfNotFound("ANNOUNCEMENT_ETA");
        pncEta.setValue(eta);
        this.genericSettingRepository.save((GenericEntity)pncEta);
    }

    @RolesAllowed(value={"pnc-users-admin"})
    public void clearEta() {
        this.clearByKey("ANNOUNCEMENT_ETA");
    }

    public void notifyListeners() {
        this.notifier.sendMessage((Object)GenericSettingNotification.pncStatusChanged((PncStatus)this.getPncStatus()));
    }

    private GenericSetting createGenericParameterIfNotFound(String key) {
        GenericSetting genericSetting = this.genericSettingRepository.queryByKey(key);
        if (genericSetting == null) {
            genericSetting = new GenericSetting();
            genericSetting.setKey(key);
        }
        return genericSetting;
    }

    private void clearByKey(String key) {
        GenericSetting dbEntry = this.genericSettingRepository.queryByKey(key);
        if (dbEntry != null) {
            this.genericSettingRepository.delete((Serializable)dbEntry.getId());
        }
    }
}

