/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.Tuple;
import org.jboss.pnc.common.Maps;
import org.jboss.pnc.common.json.moduleconfig.SystemConfig;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.ProductVersionRef;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.statistics.ProductMilestoneArtifactQualityStatistics;
import org.jboss.pnc.dto.response.statistics.ProductMilestoneRepositoryTypeStatistics;
import org.jboss.pnc.dto.response.statistics.ProductVersionDeliveredArtifactsStatistics;
import org.jboss.pnc.dto.response.statistics.ProductVersionStatistics;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.ProductVersionProvider;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.mapper.api.ProductVersionMapper;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.Product;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.spi.datastore.predicates.ProductMilestonePredicates;
import org.jboss.pnc.spi.datastore.predicates.ProductVersionPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductVersionRepository;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class ProductVersionProviderImpl
extends AbstractUpdatableProvider<Integer, ProductVersion, org.jboss.pnc.dto.ProductVersion, ProductVersionRef>
implements ProductVersionProvider {
    private static final Logger log = LoggerFactory.getLogger(ProductVersionProviderImpl.class);
    private final ProductVersionRepository versionRepository;
    private final ProductRepository productRepository;
    private final ProductMilestoneRepository milestoneRepository;
    private final DeliverableArtifactRepository deliverableArtifactRepository;
    private final BuildConfigurationSetRepository groupConfigRepository;
    private final SystemConfig systemConfig;
    private final ProductMilestoneMapper milestoneMapper;

    @Inject
    public ProductVersionProviderImpl(ProductVersionRepository repository, ProductVersionMapper mapper, ProductMilestoneMapper milestoneMapper, ProductRepository productRepository, ProductMilestoneRepository milestoneRepository, DeliverableArtifactRepository deliverableArtifactRepository, BuildConfigurationSetRepository groupConfigRepository, SystemConfig systemConfig) {
        super(repository, mapper, ProductVersion.class);
        this.versionRepository = repository;
        this.milestoneMapper = milestoneMapper;
        this.productRepository = productRepository;
        this.groupConfigRepository = groupConfigRepository;
        this.systemConfig = systemConfig;
        this.milestoneRepository = milestoneRepository;
        this.deliverableArtifactRepository = deliverableArtifactRepository;
    }

    @Override
    public org.jboss.pnc.dto.ProductVersion store(org.jboss.pnc.dto.ProductVersion restEntity) {
        this.validateBeforeSaving(restEntity);
        ProductVersion productVersionRestDb = (ProductVersion)this.mapper.toEntity((DTOEntity)restEntity);
        Product product = (Product)this.productRepository.queryById((Serializable)Integer.valueOf(restEntity.getProduct().getId()));
        productVersionRestDb.generateBrewTagPrefix(product.getAbbreviation(), restEntity.getVersion(), this.systemConfig.getBrewTagPattern());
        ProductVersion productVersion = (ProductVersion)this.repository.save((GenericEntity)productVersionRestDb);
        for (BuildConfiguration bc : productVersionRestDb.getBuildConfigurations()) {
            bc.setProductVersion(productVersion);
        }
        this.repository.flushAndRefresh((GenericEntity)productVersion);
        return (org.jboss.pnc.dto.ProductVersion)this.mapper.toDTO((GenericEntity)productVersion);
    }

    @Override
    protected void validateBeforeSaving(org.jboss.pnc.dto.ProductVersion restEntity) {
        super.validateBeforeSaving(restEntity);
        Product product = (Product)this.productRepository.queryById((Serializable)Integer.valueOf(restEntity.getProduct().getId()));
        if (product == null) {
            throw new InvalidEntityException("Product with id: " + restEntity.getProduct().getId() + " does not exist.");
        }
        Set productVersionList = product.getProductVersions();
        if (productVersionList == null) {
            return;
        }
        productVersionList.stream().filter(pv -> pv.getVersion().equals(restEntity.getVersion())).findFirst().ifPresent(pv -> {
            throw new ConflictedEntryException("Product version with version " + restEntity.getVersion() + " already exists", ProductVersion.class, pv.getId().toString());
        });
    }

    @Override
    protected void validateBeforeUpdating(Integer id, org.jboss.pnc.dto.ProductVersion restEntity) {
        super.validateBeforeUpdating(id, restEntity);
        this.validateVersionChange(id, restEntity);
        this.validateGroupConfigsBeforeUpdating(id, restEntity);
        this.validateMilestone(id, restEntity);
    }

    private void validateVersionChange(Integer id, org.jboss.pnc.dto.ProductVersion restEntity) throws InvalidEntityException {
        boolean hasClosedMilestone;
        boolean changingVersion;
        ProductVersion entityInDb = (ProductVersion)this.findInDB(id);
        boolean bl = changingVersion = !entityInDb.getVersion().equals(restEntity.getVersion());
        if (changingVersion && (hasClosedMilestone = entityInDb.getProductMilestones().stream().anyMatch(milestone -> milestone.getEndDate() != null))) {
            throw new InvalidEntityException("Cannot change version due to having closed milestone. Product version id: " + id);
        }
    }

    private void validateGroupConfigsBeforeUpdating(Integer id, org.jboss.pnc.dto.ProductVersion restEntity) throws InvalidEntityException, NumberFormatException, ConflictedEntryException {
        if (restEntity.getGroupConfigs() != null) {
            for (String groupConfigId : restEntity.getGroupConfigs().keySet()) {
                BuildConfigurationSet set = (BuildConfigurationSet)this.groupConfigRepository.queryById((Serializable)Integer.valueOf(groupConfigId));
                if (set == null) {
                    throw new InvalidEntityException("Group config with id: " + groupConfigId + " does not exist.");
                }
                if (set.getProductVersion() == null || set.getProductVersion().getId().equals(id)) continue;
                throw new ConflictedEntryException("Group config with id: " + groupConfigId + " already belongs to different product version.", ProductVersion.class, set.getProductVersion().getId().toString());
            }
        }
    }

    private void validateMilestone(Integer id, org.jboss.pnc.dto.ProductVersion entity) {
        if (entity.getCurrentProductMilestone() != null) {
            Integer newMilestoneId = (Integer)this.milestoneMapper.getIdMapper().toEntity((Object)entity.getCurrentProductMilestone().getId());
            ProductVersion productVersion = (ProductVersion)this.repository.queryById((Serializable)id);
            ProductMilestone currentMilestone = productVersion.getCurrentProductMilestone();
            if (currentMilestone == null || currentMilestone.getId() != newMilestoneId) {
                ProductMilestone newMilestone = (ProductMilestone)this.milestoneRepository.queryById((Serializable)newMilestoneId);
                if (newMilestone == null) {
                    throw new InvalidEntityException("Milestone with id: " + newMilestoneId + " does not exist.");
                }
                if (newMilestone.getEndDate() != null) {
                    throw new InvalidEntityException("Milestone with id: " + newMilestoneId + " is closed, so cannot be set as current.");
                }
            }
        }
    }

    @Override
    public Page<org.jboss.pnc.dto.ProductVersion> getAllForProduct(int pageIndex, int pageSize, String sortingRsql, String query, String productId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ProductVersionPredicates.withProductId((Integer)Integer.valueOf(productId)));
    }

    @Override
    public ProductVersionStatistics getStatistics(String id) {
        Integer productVersionId = (Integer)this.mapper.getIdMapper().toEntity((Object)id);
        return ProductVersionStatistics.builder().milestones(this.versionRepository.countMilestonesInThisVersion(productVersionId)).productDependencies(this.deliverableArtifactRepository.countVersionDeliveredArtifactsProductDependencies(productVersionId)).milestoneDependencies(this.deliverableArtifactRepository.countVersionDeliveredArtifactsMilestoneDependencies(productVersionId)).artifactsInVersion(this.versionRepository.countBuiltArtifactsInThisVersion(productVersionId)).deliveredArtifactsSource(ProductVersionDeliveredArtifactsStatistics.builder().thisVersion(this.deliverableArtifactRepository.countVersionDeliveredArtifactsBuiltInThisVersion(productVersionId)).otherVersions(this.deliverableArtifactRepository.countVersionDeliveredArtifactsBuiltInOtherVersions(productVersionId)).otherProducts(this.deliverableArtifactRepository.countVersionDeliveredArtifactsBuiltByOtherProducts(productVersionId)).noMilestone(this.deliverableArtifactRepository.countVersionDeliveredArtifactsBuiltInNoMilestone(productVersionId)).noBuild(this.deliverableArtifactRepository.countVersionDeliveredArtifactsNotBuilt(productVersionId)).build()).build();
    }

    @Override
    public Page<ProductMilestoneArtifactQualityStatistics> getArtifactQualitiesStatistics(int pageIndex, int pageSize, String sort, String query, String id) {
        Integer entityId = (Integer)this.mapper.getIdMapper().toEntity((Object)id);
        List<ProductMilestone> productMilestones = this.getProductMilestones(pageIndex, pageSize, sort, query, entityId);
        List artifactQualities = this.deliverableArtifactRepository.getArtifactQualityStatistics(productMilestones.stream().map(ProductMilestone::getId).collect(Collectors.toSet()));
        Map<Integer, EnumMap<ArtifactQuality, Long>> artifactQualityStatsById = ProductVersionProviderImpl.transformToMapByIds(artifactQualities, ArtifactQuality.class);
        List<ProductMilestoneArtifactQualityStatistics> artifactQualityStatistics = this.toProductMilestoneArtifactQualityStatistics(productMilestones, artifactQualityStatsById);
        return new Page(pageIndex, pageSize, this.countAllProductMilestonesOfTheVersion(query, entityId), artifactQualityStatistics);
    }

    @Override
    public Page<ProductMilestoneRepositoryTypeStatistics> getRepositoryTypesStatistics(int pageIndex, int pageSize, String sort, String query, String id) {
        Integer entityId = (Integer)this.mapper.getIdMapper().toEntity((Object)id);
        List<ProductMilestone> productMilestones = this.getProductMilestones(pageIndex, pageSize, sort, query, entityId);
        List repositoryTypes = this.deliverableArtifactRepository.getRepositoryTypesStatistics(productMilestones.stream().map(ProductMilestone::getId).collect(Collectors.toSet()));
        Map<Integer, EnumMap<RepositoryType, Long>> repositoryTypesStatsById = ProductVersionProviderImpl.transformToMapByIds(repositoryTypes, RepositoryType.class);
        List<ProductMilestoneRepositoryTypeStatistics> repositoryTypesStats = this.toProductMilestoneRepositoryTypeStatistics(productMilestones, repositoryTypesStatsById);
        return new Page(pageIndex, pageSize, this.countAllProductMilestonesOfTheVersion(query, entityId), repositoryTypesStats);
    }

    private List<ProductMilestone> getProductMilestones(int pageIndex, int pageSize, String sort, String query, Integer entityId) {
        Predicate<ProductMilestone> rsqlPredicate = this.rsqlPredicateProducer.getCriteriaPredicate(ProductMilestone.class, query);
        PageInfo pageInfo = this.pageInfoProducer.getPageInfo(pageIndex, pageSize);
        SortInfo<ProductMilestone> sortInfo = this.rsqlPredicateProducer.getSortInfo(ProductMilestone.class, sort);
        return this.milestoneRepository.queryWithPredicates(pageInfo, sortInfo, new Predicate[]{rsqlPredicate, ProductMilestonePredicates.withProductVersionId((Integer)entityId)});
    }

    private static <E extends Enum<E>> Map<Integer, EnumMap<E, Long>> transformToMapByIds(List<Tuple> tuples, Class<E> entityClass) {
        HashMap<Integer, EnumMap<E, Long>> statisticsById = new HashMap<Integer, EnumMap<E, Long>>();
        for (Tuple tuple : tuples) {
            Integer id = (Integer)tuple.get(0, Integer.class);
            EnumMap statsOfThisId = statisticsById.getOrDefault(id, Maps.initEnumMapWithDefaultValue(entityClass, (Object)0L));
            statsOfThisId.put((Enum)tuple.get(1, entityClass), (Long)tuple.get(2, Long.class));
            statisticsById.put(id, statsOfThisId);
        }
        return statisticsById;
    }

    private List<ProductMilestoneArtifactQualityStatistics> toProductMilestoneArtifactQualityStatistics(List<ProductMilestone> productMilestones, Map<Integer, EnumMap<ArtifactQuality, Long>> artifactQualityStatsById) {
        ArrayList<ProductMilestoneArtifactQualityStatistics> productMilestoneArtifactQualityStats = new ArrayList<ProductMilestoneArtifactQualityStatistics>();
        for (ProductMilestone pm : productMilestones) {
            productMilestoneArtifactQualityStats.add(ProductMilestoneArtifactQualityStatistics.builder().productMilestone(this.milestoneMapper.toRef(pm)).artifactQuality(artifactQualityStatsById.getOrDefault(pm.getId(), Maps.initEnumMapWithDefaultValue(ArtifactQuality.class, (Object)0L))).build());
        }
        return productMilestoneArtifactQualityStats;
    }

    private List<ProductMilestoneRepositoryTypeStatistics> toProductMilestoneRepositoryTypeStatistics(List<ProductMilestone> productMilestones, Map<Integer, EnumMap<RepositoryType, Long>> repositoryTypesStatsById) {
        ArrayList<ProductMilestoneRepositoryTypeStatistics> productMilestoneRepositoryTypeStats = new ArrayList<ProductMilestoneRepositoryTypeStatistics>();
        for (ProductMilestone pm : productMilestones) {
            productMilestoneRepositoryTypeStats.add(ProductMilestoneRepositoryTypeStatistics.builder().productMilestone(this.milestoneMapper.toRef(pm)).repositoryType(repositoryTypesStatsById.getOrDefault(pm.getId(), Maps.initEnumMapWithDefaultValue(RepositoryType.class, (Object)0L))).build());
        }
        return productMilestoneRepositoryTypeStats;
    }

    private int countAllProductMilestonesOfTheVersion(String query, Integer id) {
        Predicate<ProductMilestone> rsqlPredicate = this.rsqlPredicateProducer.getCriteriaPredicate(ProductMilestone.class, query);
        return this.milestoneRepository.count(new Predicate[]{rsqlPredicate, ProductMilestonePredicates.withProductVersionId((Integer)id)});
    }
}

