/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.util;

import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.ws.rs.ProcessingException;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.core.MediaType;
import org.jboss.pnc.api.repour.dto.TranslateRequest;
import org.jboss.pnc.api.repour.dto.TranslateResponse;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class RepourClient {
    private Logger logger = LoggerFactory.getLogger(RepourClient.class);
    private static final String TRANSLATE_ENDPOINT = "/git-external-to-internal";
    @Inject
    private GlobalModuleGroup globalModuleGroupConfiguration;
    private final Client client = ClientBuilder.newClient();

    public String translateExternalUrl(String externalUrl) {
        try {
            TranslateRequest request = new TranslateRequest(externalUrl);
            TranslateResponse response = (TranslateResponse)this.client.target(this.globalModuleGroupConfiguration.getRepourUrl()).path(TRANSLATE_ENDPOINT).request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity((Object)request, (MediaType)MediaType.APPLICATION_JSON_TYPE), TranslateResponse.class);
            if (StringUtils.isEmpty((String)response.getInternalUrl())) {
                throw new RuntimeException("Failed to read translation of external URL to internal one.");
            }
            return response.getInternalUrl();
        }
        catch (ProcessingException ex) {
            throw new RuntimeException("Failed to translate external URL to internal one.", ex);
        }
    }
}

