/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.util.labels;

import java.util.EnumSet;
import javax.transaction.Transactional;
import org.jboss.pnc.api.enums.LabelOperation;
import org.jboss.pnc.facade.util.labels.LabelModifier;
import org.jboss.pnc.facade.validation.InvalidLabelOperationException;

public abstract class AbstractLabelModifier<L extends Enum<L>>
implements LabelModifier<L> {
    private EnumSet<L> activeLabels;

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void validateAndAddLabel(L label, EnumSet<L> activeLabels) {
        this.activeLabels = activeLabels;
        this.checkLabelIsNotPresent(label);
        this.addLabel(label, activeLabels);
    }

    protected abstract void addLabel(L var1, EnumSet<L> var2);

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void validateAndRemoveLabel(L label, EnumSet<L> activeLabels) {
        this.activeLabels = activeLabels;
        this.checkLabelIsPresent(label);
        this.removeLabel(label, activeLabels);
    }

    protected abstract void removeLabel(L var1, EnumSet<L> var2);

    private void checkLabelIsNotPresent(L label) {
        if (this.activeLabels.contains(label)) {
            throw new InvalidLabelOperationException((Enum<?>)label, (EnumSet<? extends Enum<?>>)this.activeLabels, LabelOperation.ADDED, "label already present in the set of active labels");
        }
    }

    private void checkLabelIsPresent(L label) {
        if (!this.activeLabels.contains(label)) {
            throw new InvalidLabelOperationException((Enum<?>)label, (EnumSet<? extends Enum<?>>)this.activeLabels, LabelOperation.REMOVED, "no such label present in the set of active labels");
        }
    }
}

