/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.impl;

import java.io.Serializable;
import java.net.URI;
import java.sql.Date;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jboss.pnc.api.constants.MDCHeaderKeys;
import org.jboss.pnc.api.dto.Request;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.facade.OperationsManager;
import org.jboss.pnc.facade.impl.OperationChangedEventImpl;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.mapper.api.OperationMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.DeliverableAnalyzerOperation;
import org.jboss.pnc.model.Operation;
import org.jboss.pnc.model.ProductMilestone;
import org.jboss.pnc.spi.datastore.repositories.OperationRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.events.OperationChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

@ApplicationScoped
public class OperationsManagerImpl
implements OperationsManager {
    private static final Logger log = LoggerFactory.getLogger(OperationsManagerImpl.class);
    private String callbackUrlTemplate = "%s/operations/%s/complete";
    @Inject
    private OperationRepository repository;
    @Inject
    private ProductMilestoneRepository productMilestoneRepository;
    @Inject
    private UserService userService;
    @Inject
    private GlobalModuleGroup globalConfig;
    @Inject
    private Event<OperationChangedEvent> analysisStatusChangedEventNotifier;
    @Inject
    private OperationsManagerImpl self;

    @Override
    public Operation updateProgress(Base32LongID id, ProgressStatus status) {
        Tuple tuple = this.self._updateProgress(id, status);
        this.analysisStatusChangedEventNotifier.fire((Object)new OperationChangedEventImpl(tuple.operation, tuple.previousProgress));
        return tuple.operation;
    }

    @Transactional
    public Tuple _updateProgress(Base32LongID id, ProgressStatus status) {
        Operation operation = (Operation)this.repository.queryById((Serializable)id);
        if (operation.getEndTime() != null) {
            throw new InvalidEntityException("Operation " + operation + " is already finished!");
        }
        log.debug("Updating progress of operation " + operation + " to " + status);
        if (operation.getStartTime() == null && status == ProgressStatus.IN_PROGRESS) {
            operation.setStartTime(Date.from(Instant.now()));
        }
        ProgressStatus previousProgress = operation.getProgressStatus();
        operation.setProgressStatus(status);
        return new Tuple(operation, previousProgress);
    }

    @Override
    public Operation setResult(Base32LongID id, OperationResult result) {
        Tuple tuple = this.self._setResult(id, result);
        this.analysisStatusChangedEventNotifier.fire((Object)new OperationChangedEventImpl(tuple.operation, tuple.previousProgress));
        return tuple.operation;
    }

    @Transactional
    public Tuple _setResult(Base32LongID id, OperationResult result) {
        Operation operation = (Operation)this.repository.queryById((Serializable)id);
        if (operation.getEndTime() != null) {
            throw new InvalidEntityException("Operation " + operation + " is already finished!");
        }
        log.debug("Updating result of operation " + operation + " to " + result);
        ProgressStatus previousProgress = operation.getProgressStatus();
        operation.setResult(result);
        operation.setEndTime(Date.from(Instant.now()));
        return new Tuple(operation, previousProgress);
    }

    @Override
    public DeliverableAnalyzerOperation newDeliverableAnalyzerOperation(String milestoneId, Map<String, String> inputParams) {
        ProductMilestone milestone = null;
        if (milestoneId != null && (milestone = (ProductMilestone)this.productMilestoneRepository.queryById((Serializable)ProductMilestoneMapper.idMapper.toEntity(milestoneId))) == null) {
            throw new EmptyEntityException("Milestone with id " + milestoneId + " doesn't exist");
        }
        String operationId = Sequence.nextBase32Id();
        MDCUtils.addProcessContext((String)operationId);
        DeliverableAnalyzerOperation operation = DeliverableAnalyzerOperation.Builder.newBuilder().progressStatus(ProgressStatus.NEW).submitTime(Date.from(Instant.now())).productMilestone(milestone).operationParameters(inputParams).user(this.userService.currentUser()).id(operationId).build();
        operation = this.self.saveToDb(operation);
        this.analysisStatusChangedEventNotifier.fire((Object)new OperationChangedEventImpl((Operation)operation, null));
        return operation;
    }

    @Transactional
    public <T extends Operation> T saveToDb(T operation) {
        return (T)((Operation)this.repository.save(operation));
    }

    @Override
    public Request getOperationCallback(Base32LongID operationId) {
        ArrayList<Request.Header> headers = new ArrayList<Request.Header>();
        this.addCommonHeaders(headers);
        this.addMDCHeaders(headers);
        this.addOTELHeaders(headers);
        String actualEndpoint = String.format(this.callbackUrlTemplate, this.globalConfig.getPncUrl(), operationId.getId());
        URI callbackURI = URI.create(actualEndpoint);
        return new Request(Request.Method.POST, callbackURI, headers);
    }

    private void addMDCHeaders(List<Request.Header> headers) {
        this.headersFromMdc(headers, MDCHeaderKeys.REQUEST_CONTEXT);
        this.headersFromMdc(headers, MDCHeaderKeys.PROCESS_CONTEXT);
        this.headersFromMdc(headers, MDCHeaderKeys.SLF4J_TRACE_ID);
        this.headersFromMdc(headers, MDCHeaderKeys.SLF4J_SPAN_ID);
    }

    private void addCommonHeaders(List<Request.Header> headers) {
        headers.add(new Request.Header("Content-Type", "application/json"));
    }

    private void addOTELHeaders(List<Request.Header> headers) {
        Map otelHeaders = MDCUtils.getOtelHeadersFromMDC();
        otelHeaders.forEach((key, value) -> {
            log.debug("Setting {}: {}", key, value);
            headers.add(new Request.Header(key, value));
        });
    }

    private void headersFromMdc(List<Request.Header> headers, MDCHeaderKeys headerKey) {
        String mdcValue = MDC.get((String)headerKey.getMdcKey());
        if (mdcValue != null && !mdcValue.isEmpty()) {
            headers.add(new Request.Header(headerKey.getHeaderName(), mdcValue.trim()));
        }
    }

    private Base32LongID parseId(String operationId) {
        return OperationMapper.idMapper.toEntity(operationId);
    }

    public static class Tuple {
        private final Operation operation;
        private final ProgressStatus previousProgress;

        public Tuple(Operation operation, ProgressStatus previousProgress) {
            this.operation = operation;
            this.previousProgress = previousProgress;
        }
    }
}

