/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.dto.ProjectRef;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.ProjectProvider;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.mapper.api.ProjectMapper;
import org.jboss.pnc.model.Project;
import org.jboss.pnc.spi.datastore.predicates.ProjectPredicates;
import org.jboss.pnc.spi.datastore.repositories.ProjectRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@PermitAll
@Stateless
public class ProjectProviderImpl
extends AbstractUpdatableProvider<Integer, Project, org.jboss.pnc.dto.Project, ProjectRef>
implements ProjectProvider {
    @Inject
    public ProjectProviderImpl(ProjectRepository repository, ProjectMapper mapper) {
        super(repository, mapper, Project.class);
    }

    @Override
    protected void validateBeforeSaving(org.jboss.pnc.dto.Project projectRest) {
        super.validateBeforeSaving(projectRest);
        this.validateIfNotConflicted(projectRest);
    }

    @Override
    public void validateBeforeUpdating(Integer id, org.jboss.pnc.dto.Project restEntity) {
        super.validateBeforeUpdating(id, restEntity);
        this.validateIfNotConflicted(restEntity);
    }

    @Override
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting projects is prohibited!");
    }

    private void validateIfNotConflicted(org.jboss.pnc.dto.Project projectRest) throws ConflictedEntryException {
        Project project = (Project)this.repository.queryByPredicates(new Predicate[]{ProjectPredicates.withProjectName((String)projectRest.getName())});
        Integer projectId = null;
        if (projectRest.getId() != null) {
            projectId = Integer.valueOf(projectRest.getId());
        }
        if (project != null && !project.getId().equals(projectId)) {
            throw new ConflictedEntryException("Project of that name already exists", Project.class, project.getId().toString());
        }
    }
}

