/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.deliverables;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURLBuilder;
import java.io.Serializable;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.PermitAll;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jboss.pnc.api.deliverablesanalyzer.dto.Artifact;
import org.jboss.pnc.api.deliverablesanalyzer.dto.ArtifactType;
import org.jboss.pnc.api.deliverablesanalyzer.dto.Build;
import org.jboss.pnc.api.deliverablesanalyzer.dto.BuildSystemType;
import org.jboss.pnc.api.deliverablesanalyzer.dto.FinderResult;
import org.jboss.pnc.api.deliverablesanalyzer.dto.LicenseInfo;
import org.jboss.pnc.api.deliverablesanalyzer.dto.MavenArtifact;
import org.jboss.pnc.api.dto.Request;
import org.jboss.pnc.api.enums.DeliverableAnalyzerReportLabel;
import org.jboss.pnc.api.enums.LabelOperation;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.auth.KeycloakServiceClient;
import org.jboss.pnc.bpm.Connector;
import org.jboss.pnc.bpm.model.AnalyzeDeliverablesBpmRequest;
import org.jboss.pnc.bpm.task.AnalyzeDeliverablesTask;
import org.jboss.pnc.common.Strings;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.json.moduleconfig.BpmModuleConfig;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.enums.ArtifactQuality;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.facade.DeliverableAnalyzerManager;
import org.jboss.pnc.facade.OperationsManager;
import org.jboss.pnc.facade.deliverables.DefaultDeliverableAnalysisStatusChangedEvent;
import org.jboss.pnc.facade.deliverables.DeliverableAnalysisStatusChangedEvent;
import org.jboss.pnc.facade.deliverables.api.AnalysisResult;
import org.jboss.pnc.mapper.api.ArtifactMapper;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerOperationMapper;
import org.jboss.pnc.mapper.api.IdMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.DeliverableAnalyzerDistribution;
import org.jboss.pnc.model.DeliverableAnalyzerLabelEntry;
import org.jboss.pnc.model.DeliverableAnalyzerOperation;
import org.jboss.pnc.model.DeliverableAnalyzerReport;
import org.jboss.pnc.model.DeliverableArtifact;
import org.jboss.pnc.model.DeliverableArtifactLicenseInfo;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.TargetRepository;
import org.jboss.pnc.model.User;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerDistributionRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerLabelEntryRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerOperationRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerReportRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableArtifactLicenseInfoRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.TargetRepositoryRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.events.OperationChangedEvent;
import org.jboss.pnc.spi.exception.ProcessManagerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
@PermitAll
public class DeliverableAnalyzerManagerImpl
implements DeliverableAnalyzerManager {
    private static final Logger log = LoggerFactory.getLogger(DeliverableAnalyzerManagerImpl.class);
    private static final String KOJI_PATH_MAVEN_PREFIX = "/api/content/maven/remote/koji-";
    private static final Pattern NVR_PATTERN = Pattern.compile("(.+)-([^-]+)-([^-]+)");
    public static final String URL_PARAMETER_PREFIX = "url-";
    @Inject
    private ArtifactRepository artifactRepository;
    @Inject
    private TargetRepositoryRepository targetRepositoryRepository;
    @Inject
    private DeliverableAnalyzerDistributionRepository deliverableAnalyzerDistributionRepository;
    @Inject
    private DeliverableAnalyzerOperationRepository deliverableAnalyzerOperationRepository;
    @Inject
    private DeliverableArtifactRepository deliverableArtifactRepository;
    @Inject
    private DeliverableAnalyzerReportRepository deliverableAnalyzerReportRepository;
    @Inject
    private DeliverableAnalyzerLabelEntryRepository deliverableAnalyzerLabelEntryRepository;
    @Inject
    private DeliverableArtifactLicenseInfoRepository deliverableArtifactLicenseInfoRepository;
    @Inject
    private ArtifactMapper artifactMapper;
    @Inject
    private OperationsManager operationsManager;
    @Inject
    private KeycloakServiceClient keycloakServiceClient;
    @Inject
    private BpmModuleConfig bpmConfig;
    @Inject
    private GlobalModuleGroup globalConfig;
    @Inject
    private DeliverableAnalyzerOperationMapper deliverableAnalyzerOperationMapper;
    @Inject
    private Event<DeliverableAnalysisStatusChangedEvent> analysisStatusChangedEventNotifier;
    @Inject
    private Connector connector;

    @Override
    public org.jboss.pnc.dto.DeliverableAnalyzerOperation analyzeDeliverables(String id, List<String> deliverablesUrls, boolean runAsScratchAnalysis) {
        int i = 1;
        HashMap<String, String> inputParams = new HashMap<String, String>();
        for (String url : deliverablesUrls) {
            inputParams.put(URL_PARAMETER_PREFIX + i++, url);
        }
        Base32LongID operationId = this.operationsManager.newDeliverableAnalyzerOperation(id, inputParams).getId();
        try {
            log.info("Starting analysis of deliverables for milestone {} from urls: {}.", (Object)id, deliverablesUrls);
            this.startAnalysis(id, deliverablesUrls, runAsScratchAnalysis, operationId);
            return this.deliverableAnalyzerOperationMapper.toDTO((DeliverableAnalyzerOperation)this.operationsManager.updateProgress(operationId, ProgressStatus.IN_PROGRESS));
        }
        catch (RuntimeException ex) {
            this.operationsManager.setResult(operationId, OperationResult.SYSTEM_ERROR);
            throw ex;
        }
    }

    @Override
    @Transactional
    public void completeAnalysis(AnalysisResult analysisResult) {
        log.info("Processing deliverables of operation with id={} in {} results.", (Object)analysisResult.getDeliverableAnalyzerOperationId(), (Object)analysisResult.getResults().size());
        DeliverableAnalyzerReport report = this.createReportForCompletedAnalysis(analysisResult.getDeliverableAnalyzerOperationId(), analysisResult.isWasRunAsScratchAnalysis());
        for (FinderResult finderResult : analysisResult.getResults()) {
            this.processDeliverables(report, finderResult.getBuilds(), finderResult.getUrl(), finderResult.getNotFoundArtifacts());
        }
    }

    private Artifact findDistributionUrlAssociatedArtifact(URL distributionUrl, Collection<Build> builds, Collection<Artifact> notFoundArtifacts) {
        String urlFilename = Paths.get(distributionUrl.getPath(), new String[0]).getFileName().toString();
        Optional<Artifact> distributionArtifact = builds.stream().flatMap(b -> b.getArtifacts().stream()).filter(a -> a.getArchiveFilenames() != null && a.getArchiveFilenames().contains(urlFilename)).findFirst();
        if (distributionArtifact.isPresent()) {
            return distributionArtifact.get();
        }
        distributionArtifact = builds.stream().flatMap(b -> b.getArtifacts().stream()).filter(a -> a.getFilename().equals(urlFilename)).findFirst();
        if (distributionArtifact.isPresent()) {
            return distributionArtifact.get();
        }
        return notFoundArtifacts.stream().filter(a -> a.getFilename().equals(urlFilename)).findFirst().orElse(null);
    }

    private void processDeliverables(DeliverableAnalyzerReport report, Collection<Build> builds, URL distributionUrl, Collection<Artifact> notFoundArtifacts) {
        log.debug("Processing deliverables in {} builds. Distribution URL: {}", (Object)builds.size(), (Object)distributionUrl);
        User user = report.getOperation().getUser();
        ArtifactStats stats = new ArtifactStats();
        ArtifactCache artifactCache = new ArtifactCache(builds, user);
        Artifact urlAssociatedArtifact = this.findDistributionUrlAssociatedArtifact(distributionUrl, builds, notFoundArtifacts);
        if (urlAssociatedArtifact == null) {
            log.warn("The local archive associated with the deliverableUrl was not found!");
        }
        DeliverableAnalyzerDistribution distribution = this.getDistribution(distributionUrl.toString(), urlAssociatedArtifact);
        for (Build build : builds) {
            Function<Artifact, org.jboss.pnc.model.Artifact> artifactParser;
            Consumer<Artifact> statCounter;
            log.debug("Processing build {}", (Object)build);
            if (build.getBuildSystemType() == null) {
                throw new IllegalArgumentException("Build system type not set.");
            }
            switch (build.getBuildSystemType()) {
                case PNC: {
                    statCounter = stats.pncCounter();
                    artifactParser = artifactCache::findPNCArtifact;
                    break;
                }
                case BREW: {
                    statCounter = stats.brewCounter();
                    artifactParser = art -> this.findOrCreateBrewArtifact((Artifact)art, user, artifactCache, build);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown build system type " + build.getBuildSystemType());
                }
            }
            build.getArtifacts().stream().peek(statCounter).forEach(artifactDto -> this.addDeliveredArtifact((org.jboss.pnc.model.Artifact)artifactParser.apply((Artifact)artifactDto), report, artifactDto.isBuiltFromSource(), build.getBrewId(), artifactDto.getArchiveFilenames(), artifactDto.getArchiveUnmatchedFilenames(), artifactDto.getLicenses(), distribution));
        }
        if (!notFoundArtifacts.isEmpty()) {
            TargetRepository distributionRepository = this.getDistributionRepository(distributionUrl.toString());
            for (Artifact art2 : notFoundArtifacts) {
                stats.notFoundCounter().accept(art2);
                org.jboss.pnc.model.Artifact artifact = this.findOrCreateNotFoundArtifact(art2, distributionRepository, user);
                this.addDeliveredArtifact(artifact, report, false, null, art2.getArchiveFilenames(), art2.getArchiveUnmatchedFilenames(), art2.getLicenses(), distribution);
            }
        }
        stats.log(distributionUrl.toString());
    }

    private void addDeliveredArtifact(org.jboss.pnc.model.Artifact artifact, DeliverableAnalyzerReport report, boolean builtFromSource, Long brewBuildId, Collection<String> archiveFilenames, Collection<String> archiveUnmatchedFilenames, Collection<LicenseInfo> licenseInfo, DeliverableAnalyzerDistribution distribution) {
        DeliverableArtifact deliverableArtifact = DeliverableArtifact.builder().artifact(artifact).report(report).builtFromSource(builtFromSource).brewBuildId(brewBuildId).archiveFilenames(StringUtils.joinArray(archiveFilenames)).archiveUnmatchedFilenames(StringUtils.joinArray(archiveUnmatchedFilenames)).distribution(distribution).build();
        report.addDeliverableArtifact(deliverableArtifact);
        this.deliverableArtifactRepository.save((GenericEntity)deliverableArtifact);
        Set licenses = ((Collection)Optional.ofNullable(licenseInfo).orElse(Collections.emptySet())).stream().map(license -> DeliverableAnalyzerManagerImpl.toEntity(license, deliverableArtifact)).collect(Collectors.toSet());
        for (DeliverableArtifactLicenseInfo licenseEntity : licenses) {
            this.deliverableArtifactLicenseInfoRepository.save((GenericEntity)licenseEntity);
            deliverableArtifact.addDeliverableArtifactLicenseInfo(licenseEntity);
        }
        log.debug("Added delivered artifact {}", (Object)deliverableArtifact);
    }

    private static DeliverableArtifactLicenseInfo toEntity(LicenseInfo license, DeliverableArtifact deliverableArtifact) {
        return DeliverableArtifactLicenseInfo.builder().id(new Base32LongID(Sequence.nextBase32Id())).comments(license.getComments()).distribution(license.getDistribution()).name(license.getName()).spdxLicenseId(license.getSpdxLicenseId()).url(license.getUrl()).source(license.getSource()).artifact(deliverableArtifact).build();
    }

    private DeliverableAnalyzerReport createReportForCompletedAnalysis(Base32LongID operationId, boolean wasRunAsScratchAnalysis) {
        DeliverableAnalyzerReport report = DeliverableAnalyzerReport.builder().id(operationId).operation((DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.queryById((Serializable)operationId)).labels(this.getReportLabels(wasRunAsScratchAnalysis)).labelHistory(new ArrayList()).artifacts(new HashSet(Set.of())).build();
        this.deliverableAnalyzerReportRepository.save((GenericEntity)report);
        if (wasRunAsScratchAnalysis) {
            this.updateLabelHistoryWithScratchEntry(report);
        }
        return report;
    }

    private EnumSet<DeliverableAnalyzerReportLabel> getReportLabels(boolean wasRunAsScratchAnalysis) {
        return wasRunAsScratchAnalysis ? EnumSet.of(DeliverableAnalyzerReportLabel.SCRATCH) : EnumSet.noneOf(DeliverableAnalyzerReportLabel.class);
    }

    private void updateLabelHistoryWithScratchEntry(DeliverableAnalyzerReport report) {
        DeliverableAnalyzerLabelEntry labelHistoryEntry = DeliverableAnalyzerLabelEntry.builder().report(report).changeOrder(Integer.valueOf(1)).entryTime(Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant())).user(report.getOperation().getUser()).reason("Analysis run as scratch.").change(LabelOperation.ADDED).label(DeliverableAnalyzerReportLabel.SCRATCH).build();
        this.deliverableAnalyzerLabelEntryRepository.save((GenericEntity)labelHistoryEntry);
        report.getLabelHistory().add(labelHistoryEntry);
    }

    private Optional<org.jboss.pnc.model.Artifact> getBestMatchingArtifact(Collection<org.jboss.pnc.model.Artifact> artifacts, boolean isImport) {
        if (artifacts == null || artifacts.isEmpty()) {
            return Optional.empty();
        }
        Function<org.jboss.pnc.model.Artifact, Integer> artifactRatingFunction = isImport ? DeliverableAnalyzerManagerImpl::getNotBuiltArtifactRating : DeliverableAnalyzerManagerImpl::getBuiltArtifactRating;
        return artifacts.stream().sorted(Comparator.comparing(artifactRatingFunction).reversed()).findFirst();
    }

    private static Integer getNotBuiltArtifactRating(org.jboss.pnc.model.Artifact artifact) {
        ArtifactQuality quality = artifact.getArtifactQuality();
        switch (quality) {
            case NEW: {
                return 1;
            }
            case VERIFIED: {
                return 2;
            }
            case TESTED: {
                return 3;
            }
            case IMPORTED: {
                return 4;
            }
            case DEPRECATED: {
                return -1;
            }
            case BLACKLISTED: {
                return -2;
            }
            case TEMPORARY: {
                return -3;
            }
            case DELETED: {
                return -4;
            }
        }
        log.warn("Unsupported ArtifactQuality! Got: {} for artifact: {}", (Object)quality, (Object)artifact);
        return -100;
    }

    private static Integer getBuiltArtifactRating(org.jboss.pnc.model.Artifact artifact) {
        ArtifactQuality quality = artifact.getArtifactQuality();
        switch (quality) {
            case NEW: {
                return 1;
            }
            case VERIFIED: {
                return 2;
            }
            case TESTED: {
                return 3;
            }
            case DEPRECATED: {
                return -1;
            }
            case BLACKLISTED: {
                return -2;
            }
            case TEMPORARY: {
                return -3;
            }
            case DELETED: {
                return -4;
            }
        }
        log.warn("Unsupported ArtifactQuality! Got: {} for artifact: {}", (Object)quality, (Object)artifact);
        return -100;
    }

    private org.jboss.pnc.model.Artifact findOrCreateBrewArtifact(Artifact artifact, User user, ArtifactCache artifactCache, Build build) {
        org.jboss.pnc.model.Artifact brewArtifact = this.mapBrewArtifact(artifact, build.getBrewNVR(), null, user);
        return artifactCache.findOrCreateBrewArtifact(brewArtifact, build);
    }

    private org.jboss.pnc.model.Artifact findOrCreateNotFoundArtifact(Artifact artifact, TargetRepository targetRepo, User user) {
        Path path = Paths.get(artifact.getFilename(), new String[0]);
        String filename = path.getFileName().toString();
        List artifacts = this.artifactRepository.withSha256In(Collections.singleton(artifact.getSha256()));
        if ((artifacts = artifacts.stream().filter(art -> art.getFilename().equals(filename)).collect(Collectors.toList())).size() == 1) {
            return (org.jboss.pnc.model.Artifact)artifacts.iterator().next();
        }
        if ((artifacts = artifacts.stream().filter(art -> art.getTargetRepository().equals((Object)targetRepo)).collect(Collectors.toList())).size() == 1) {
            return (org.jboss.pnc.model.Artifact)artifacts.iterator().next();
        }
        if ((artifacts = artifacts.stream().filter(art -> art.getIdentifier().equals(artifact.getFilename())).collect(Collectors.toList())).size() == 1) {
            return (org.jboss.pnc.model.Artifact)artifacts.iterator().next();
        }
        return this.createArtifact(this.mapNotFoundArtifact(artifact, user), targetRepo);
    }

    private org.jboss.pnc.model.Artifact createArtifact(org.jboss.pnc.model.Artifact artifact, TargetRepository targetRepo) {
        artifact.setTargetRepository(targetRepo);
        artifact.setPurl(this.createGenericPurl(artifact.getFilename().toString(), artifact.getSha256()));
        org.jboss.pnc.model.Artifact savedArtifact = (org.jboss.pnc.model.Artifact)this.artifactRepository.save((GenericEntity)artifact);
        targetRepo.getArtifacts().add(savedArtifact);
        return savedArtifact;
    }

    private org.jboss.pnc.model.Artifact mapNotFoundArtifact(Artifact artifact, User user) {
        Artifact.Builder builder = this.mapArtifact(artifact, user);
        Path path = Paths.get(artifact.getFilename(), new String[0]);
        builder.filename(path.getFileName().toString());
        builder.identifier(artifact.getFilename());
        Path directory = path.getParent();
        builder.deployPath(directory == null ? null : directory.toString());
        return builder.build();
    }

    private org.jboss.pnc.model.Artifact mapBrewArtifact(Artifact artifact, String nvr, TargetRepository targetRepository, User user) {
        if (artifact.getArtifactType() != ArtifactType.MAVEN) {
            throw new UnsupportedOperationException("Brew artifact " + artifact + " is not Maven!");
        }
        MavenArtifact mavenArtifact = (MavenArtifact)artifact;
        Artifact.Builder builder = this.mapArtifact((Artifact)mavenArtifact, user);
        builder.identifier(this.createIdentifier(mavenArtifact));
        builder.filename(DeliverableAnalyzerManagerImpl.createFileName(mavenArtifact));
        builder.deployPath(DeliverableAnalyzerManagerImpl.createDeployPath(mavenArtifact));
        builder.originUrl(this.createBrewOriginURL(mavenArtifact, nvr));
        builder.purl(this.createPURL(mavenArtifact));
        builder.targetRepository(targetRepository);
        return builder.build();
    }

    private Artifact.Builder mapArtifact(Artifact artifact, User user) {
        Date now = new Date();
        Artifact.Builder builder = org.jboss.pnc.model.Artifact.builder();
        builder.md5(artifact.getMd5());
        builder.sha1(artifact.getSha1());
        builder.sha256(artifact.getSha256());
        builder.size(Long.valueOf(artifact.getSize()));
        builder.importDate(now);
        builder.creationUser(user);
        builder.creationTime(now);
        if (artifact.isBuiltFromSource()) {
            builder.artifactQuality(ArtifactQuality.NEW);
        } else {
            builder.artifactQuality(ArtifactQuality.IMPORTED);
        }
        return builder;
    }

    private static String createDeployPath(MavenArtifact mavenArt) {
        String filename = DeliverableAnalyzerManagerImpl.createFileName(mavenArt);
        String deployPath = "/" + mavenArt.getGroupId().replace('.', '/') + "/" + mavenArt.getArtifactId() + "/" + mavenArt.getVersion() + "/" + filename;
        return deployPath;
    }

    private static String createFileName(MavenArtifact mavenArt) {
        String filename = mavenArt.getArtifactId() + "-" + mavenArt.getVersion();
        if (!Strings.isEmpty((String)mavenArt.getClassifier())) {
            filename = filename + "-" + mavenArt.getClassifier();
        }
        filename = filename + "." + mavenArt.getType();
        return filename;
    }

    private String createBrewOriginURL(MavenArtifact mavenArt, String nvr) {
        String brewContentUrl = this.globalConfig.getBrewContentUrl();
        Matcher matcher = NVR_PATTERN.matcher(nvr);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("NVR " + nvr + " does not match expected format.");
        }
        String name = matcher.group(1);
        String version = matcher.group(2);
        String release = matcher.group(3);
        return brewContentUrl + "/" + name + "/" + version + "/" + release + "/maven" + DeliverableAnalyzerManagerImpl.createDeployPath(mavenArt);
    }

    private String createPURL(MavenArtifact mavenArtifact) {
        try {
            PackageURLBuilder purlBuilder = PackageURLBuilder.aPackageURL().withType("maven").withNamespace(mavenArtifact.getGroupId()).withName(mavenArtifact.getArtifactId()).withVersion(mavenArtifact.getVersion()).withQualifier("type", StringUtils.isEmpty((String)mavenArtifact.getType()) ? "jar" : mavenArtifact.getType());
            if (!StringUtils.isEmpty((String)mavenArtifact.getClassifier())) {
                purlBuilder.withQualifier("classifier", mavenArtifact.getClassifier());
            }
            return purlBuilder.build().toString();
        }
        catch (MalformedPackageURLException e) {
            throw new RuntimeException(e);
        }
    }

    private String createGenericPurl(String filename, String sha256) {
        try {
            PackageURLBuilder purlBuilder = PackageURLBuilder.aPackageURL().withType("generic").withName(filename).withQualifier("checksum", "sha256:" + sha256);
            return purlBuilder.build().toString();
        }
        catch (MalformedPackageURLException e) {
            throw new RuntimeException(e);
        }
    }

    private String createIdentifier(MavenArtifact mavenArtifact) {
        return Arrays.asList(mavenArtifact.getGroupId(), mavenArtifact.getArtifactId(), mavenArtifact.getType(), mavenArtifact.getVersion(), mavenArtifact.getClassifier()).stream().filter(Objects::nonNull).collect(Collectors.joining(":"));
    }

    private TargetRepository getDistributionRepository(String distURL) {
        TargetRepository tr = this.targetRepositoryRepository.queryByIdentifierAndPath("distribution-archive", distURL);
        if (tr == null) {
            tr = this.createRepository(distURL, "distribution-archive", RepositoryType.DISTRIBUTION_ARCHIVE);
        }
        return tr;
    }

    private TargetRepository createRepository(String path, String identifier, RepositoryType type) {
        TargetRepository tr = TargetRepository.newBuilder().temporaryRepo(Boolean.valueOf(false)).identifier(identifier).repositoryPath(path).repositoryType(type).artifacts(new HashSet()).build();
        return (TargetRepository)this.targetRepositoryRepository.save((GenericEntity)tr);
    }

    private DeliverableAnalyzerDistribution getDistribution(String distURL, Artifact artifact) {
        DeliverableAnalyzerDistribution distribution;
        DeliverableAnalyzerDistribution deliverableAnalyzerDistribution = distribution = artifact == null ? this.deliverableAnalyzerDistributionRepository.queryByUrl(distURL) : this.deliverableAnalyzerDistributionRepository.queryByUrlAndSha256(distURL, artifact.getSha256());
        if (distribution == null) {
            distribution = this.createDistribution(distURL, artifact);
        }
        return distribution;
    }

    private DeliverableAnalyzerDistribution createDistribution(String url, Artifact artifact) {
        DeliverableAnalyzerDistribution distro = DeliverableAnalyzerDistribution.builder().distributionUrl(url).artifacts(new HashSet()).md5(artifact != null ? artifact.getMd5() : null).sha1(artifact != null ? artifact.getSha1() : null).sha256(artifact != null ? artifact.getSha256() : null).build();
        return (DeliverableAnalyzerDistribution)this.deliverableAnalyzerDistributionRepository.save((GenericEntity)distro);
    }

    private void startAnalysis(String milestoneId, List<String> deliverablesUrls, boolean runAsScratchAnalysis, Base32LongID operationId) {
        Request callback = this.operationsManager.getOperationCallback(operationId);
        String id = operationId.getId();
        try {
            AnalyzeDeliverablesBpmRequest bpmRequest = new AnalyzeDeliverablesBpmRequest(id, deliverablesUrls, runAsScratchAnalysis);
            AnalyzeDeliverablesTask analyzeTask = new AnalyzeDeliverablesTask(bpmRequest, callback);
            this.connector.startProcess(this.bpmConfig.getAnalyzeDeliverablesBpmProcessId(), (Object)analyzeTask, id, this.keycloakServiceClient.getAuthToken());
            DefaultDeliverableAnalysisStatusChangedEvent analysisStatusChanged = DefaultDeliverableAnalysisStatusChangedEvent.started(id, milestoneId, deliverablesUrls);
            this.analysisStatusChangedEventNotifier.fire((Object)analysisStatusChanged);
        }
        catch (ProcessManagerException e) {
            log.error("Error trying to start analysis of deliverables task for milestone: {}", (Object)milestoneId, (Object)e);
            throw new RuntimeException(e);
        }
    }

    public void observeEvent(@Observes OperationChangedEvent event) {
        if (event.getOperationClass() != DeliverableAnalyzerOperation.class) {
            return;
        }
        log.debug("Observed deliverable analysis operation status changed event {}.", (Object)event);
        if (event.getStatus() == ProgressStatus.FINISHED && event.getPreviousStatus() != ProgressStatus.FINISHED) {
            DeliverableAnalyzerOperation operation = (DeliverableAnalyzerOperation)this.deliverableAnalyzerOperationRepository.queryById((Serializable)event.getId());
            this.onDeliverableAnalysisFinished(operation);
        }
    }

    private void onDeliverableAnalysisFinished(DeliverableAnalyzerOperation operation) {
        List<String> deliverablesUrls = operation.getOperationParameters().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(URL_PARAMETER_PREFIX)).map(Map.Entry::getValue).collect(Collectors.toList());
        DefaultDeliverableAnalysisStatusChangedEvent analysisStatusChanged = DefaultDeliverableAnalysisStatusChangedEvent.finished(operation.getId().getId(), operation.getProductMilestone().getId().toString(), operation.getResult(), deliverablesUrls);
        this.analysisStatusChangedEventNotifier.fire((Object)analysisStatusChanged);
    }

    private class ArtifactCache {
        private Map<Integer, org.jboss.pnc.model.Artifact> pncCache = new HashMap<Integer, org.jboss.pnc.model.Artifact>();
        private Map<Artifact.IdentifierSha256, org.jboss.pnc.model.Artifact> brewCache = new HashMap<Artifact.IdentifierSha256, org.jboss.pnc.model.Artifact>();
        private Map<String, TargetRepository> targetRepositoryCache = new HashMap<String, TargetRepository>();
        private User user;

        public ArtifactCache(Collection<Build> builds, User user) {
            this.user = user;
            this.prefetchPNCArtifacts(builds);
            this.prefetchTargetRepos(builds);
            this.prefetchBrewArtifacts(builds);
            this.prefetchBrewImportedArtifacts(builds);
        }

        private void prefetchPNCArtifacts(Collection<Build> builds) {
            log.debug("Preloading PNC artifacts...");
            Set ids = builds.stream().filter(b -> b.getBuildSystemType() == BuildSystemType.PNC).flatMap(b -> b.getArtifacts().stream()).map(a -> a.getPncId()).map(arg_0 -> ((IdMapper)DeliverableAnalyzerManagerImpl.this.artifactMapper.getIdMapper()).toEntity(arg_0)).collect(Collectors.toSet());
            if (!ids.isEmpty()) {
                this.pncCache = DeliverableAnalyzerManagerImpl.this.artifactRepository.queryWithPredicates(new Predicate[]{ArtifactPredicates.withIds(ids)}).stream().collect(Collectors.toMap(org.jboss.pnc.model.Artifact::getId, Function.identity()));
            }
            log.debug("Preloaded {} PNC artifacts to cache.", (Object)this.pncCache.size());
        }

        private void prefetchTargetRepos(Collection<Build> builds) {
            log.debug("Preloading target repos...");
            Set queries = builds.stream().filter(b -> b.getBuildSystemType() == BuildSystemType.BREW).map(this::getKojiPath).map(path -> new TargetRepository.IdentifierPath("indy-maven", path)).collect(Collectors.toSet());
            if (!queries.isEmpty()) {
                List targetRepositories = DeliverableAnalyzerManagerImpl.this.targetRepositoryRepository.queryByIdentifiersAndPaths(queries);
                for (TargetRepository targetRepository : targetRepositories) {
                    this.targetRepositoryCache.put(targetRepository.getRepositoryPath(), targetRepository);
                }
            }
            log.debug("Preloaded {} target repos to cache.", (Object)this.targetRepositoryCache.size());
        }

        private void prefetchBrewArtifacts(Collection<Build> builds) {
            log.debug("Preloading brew artifacts...");
            int initialCacheSize = this.brewCache.size();
            Set identifierSha256Set = builds.stream().filter(b -> b.getBuildSystemType() == BuildSystemType.BREW).filter(b -> !b.isImport()).flatMap(this::prefetchBrewBuild).collect(Collectors.toSet());
            if (!identifierSha256Set.isEmpty()) {
                Set artifacts = DeliverableAnalyzerManagerImpl.this.artifactRepository.withIdentifierAndSha256(identifierSha256Set);
                Map<Artifact.IdentifierSha256, List<org.jboss.pnc.model.Artifact>> groupedByIdentifierSha256 = artifacts.stream().collect(Collectors.groupingBy(org.jboss.pnc.model.Artifact::getIdentifierSha256));
                groupedByIdentifierSha256.forEach((key, matchedArtifacts) -> this.brewCache.put((Artifact.IdentifierSha256)key, DeliverableAnalyzerManagerImpl.this.getBestMatchingArtifact((Collection<org.jboss.pnc.model.Artifact>)matchedArtifacts, false).get()));
            }
            log.debug("Preloaded {} brew artifacts to cache, total cache size: {}.", (Object)(this.brewCache.size() - initialCacheSize), (Object)this.brewCache.size());
        }

        private void prefetchBrewImportedArtifacts(Collection<Build> builds) {
            log.debug("Preloading brew imported artifacts...");
            int initialCacheSize = this.brewCache.size();
            Set identifierSha256Set = builds.stream().filter(b -> b.getBuildSystemType() == BuildSystemType.BREW).filter(b -> b.isImport()).flatMap(this::prefetchBrewBuild).collect(Collectors.toSet());
            if (!identifierSha256Set.isEmpty()) {
                Set artifacts = DeliverableAnalyzerManagerImpl.this.artifactRepository.withIdentifierAndSha256(identifierSha256Set);
                Map<Artifact.IdentifierSha256, List<org.jboss.pnc.model.Artifact>> groupedByIdentifierSha256 = artifacts.stream().collect(Collectors.groupingBy(org.jboss.pnc.model.Artifact::getIdentifierSha256));
                groupedByIdentifierSha256.forEach((key, matchedArtifacts) -> this.brewCache.put((Artifact.IdentifierSha256)key, DeliverableAnalyzerManagerImpl.this.getBestMatchingArtifact((Collection<org.jboss.pnc.model.Artifact>)matchedArtifacts, true).get()));
            }
            log.debug("Preloaded {} brew imported artifacts to cache, total cache size: {}.", (Object)(this.brewCache.size() - initialCacheSize), (Object)this.brewCache.size());
        }

        public Stream<Artifact.IdentifierSha256> prefetchBrewBuild(Build build) {
            return build.getArtifacts().stream().peek(this::assertBrewArtifacts).map(a -> DeliverableAnalyzerManagerImpl.this.mapBrewArtifact((Artifact)a, build.getBrewNVR(), null, this.user)).map(a -> a.getIdentifierSha256());
        }

        private String getKojiPath(Build build) {
            return DeliverableAnalyzerManagerImpl.KOJI_PATH_MAVEN_PREFIX + build.getBrewNVR() + "/";
        }

        private void assertBrewArtifacts(Artifact artifact) {
            if (artifact.getArtifactType() != null && artifact.getArtifactType() != ArtifactType.MAVEN) {
                throw new IllegalArgumentException("Brew artifacts are expected to be either MAVEN or unknown, artifact " + artifact + " is " + artifact.getArtifactType());
            }
        }

        public org.jboss.pnc.model.Artifact findPNCArtifact(Artifact art) {
            org.jboss.pnc.model.Artifact artifact = this.pncCache.get(DeliverableAnalyzerManagerImpl.this.artifactMapper.getIdMapper().toEntity((Object)art.getPncId()));
            if (artifact == null) {
                throw new IllegalArgumentException("PNC artifact with id " + art.getPncId() + " doesn't exist.");
            }
            return artifact;
        }

        public TargetRepository findOrCreateTargetRepository(Build build) {
            String path = this.getKojiPath(build);
            TargetRepository tr = this.targetRepositoryCache.get(path);
            if (tr == null) {
                tr = DeliverableAnalyzerManagerImpl.this.createRepository(path, "indy-maven", RepositoryType.MAVEN);
                this.targetRepositoryCache.put(path, tr);
            }
            return tr;
        }

        private org.jboss.pnc.model.Artifact findOrCreateBrewArtifact(org.jboss.pnc.model.Artifact artifact, Build build) {
            org.jboss.pnc.model.Artifact cachedArtifact = this.brewCache.get(artifact.getIdentifierSha256());
            if (cachedArtifact != null) {
                return cachedArtifact;
            }
            TargetRepository brewRepository = this.findOrCreateTargetRepository(build);
            artifact.setTargetRepository(brewRepository);
            org.jboss.pnc.model.Artifact savedArtifact = (org.jboss.pnc.model.Artifact)DeliverableAnalyzerManagerImpl.this.artifactRepository.save((GenericEntity)artifact);
            brewRepository.getArtifacts().add(savedArtifact);
            this.brewCache.put(artifact.getIdentifierSha256(), savedArtifact);
            return savedArtifact;
        }
    }

    private class ArtifactStats {
        int totalArtifacts = 0;
        int pncArtifactsCount = 0;
        int pncNotBuiltArtifactsCount = 0;
        int brewArtifactsCount = 0;
        int brewNotBuiltArtifactsCount = 0;
        int notFoundArtifactsCount = 0;

        private ArtifactStats() {
        }

        public Consumer<Artifact> pncCounter() {
            return a -> {
                ++this.totalArtifacts;
                ++this.pncArtifactsCount;
                if (!a.isBuiltFromSource()) {
                    ++this.pncNotBuiltArtifactsCount;
                }
            };
        }

        public Consumer<Artifact> brewCounter() {
            return a -> {
                ++this.totalArtifacts;
                ++this.brewArtifactsCount;
                if (!a.isBuiltFromSource()) {
                    ++this.brewNotBuiltArtifactsCount;
                }
            };
        }

        public Consumer<Artifact> notFoundCounter() {
            return a -> {
                ++this.totalArtifacts;
                ++this.notFoundArtifactsCount;
            };
        }

        public void log(String distributionUrl) {
            log.info("Processed {} artifacts from deliverables at {}: ", (Object)this.totalArtifacts, (Object)distributionUrl);
            log.info("  PNC artifacts: {} ({} artifacts not built from source), BREW artifacts: {} ({} artifacts not built from source), other artifacts not built from source: {} ", new Object[]{this.pncArtifactsCount, this.pncNotBuiltArtifactsCount, this.brewArtifactsCount, this.brewNotBuiltArtifactsCount, this.notFoundArtifactsCount});
            int totalNotBuild = this.pncNotBuiltArtifactsCount + this.brewNotBuiltArtifactsCount + this.notFoundArtifactsCount;
            if (totalNotBuild > 0) {
                log.info("  There are total {} artifacts not built from source!", (Object)totalNotBuild);
            }
        }
    }
}

