/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.EJBAccessException;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.metamodel.SingularAttribute;
import org.jboss.pnc.auth.KeycloakServiceClient;
import org.jboss.pnc.common.graph.GraphBuilder;
import org.jboss.pnc.common.graph.GraphUtils;
import org.jboss.pnc.common.pnc.LongBase32IdConverter;
import org.jboss.pnc.common.scm.ScmException;
import org.jboss.pnc.common.scm.ScmUrlGeneratorProvider;
import org.jboss.pnc.common.util.HttpUtils;
import org.jboss.pnc.common.util.StreamHelper;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.common.util.TimeUtils;
import org.jboss.pnc.dto.Build;
import org.jboss.pnc.dto.BuildConfigurationRevision;
import org.jboss.pnc.dto.BuildRef;
import org.jboss.pnc.dto.insights.BuildRecordInsights;
import org.jboss.pnc.dto.response.Graph;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.RunningBuildCount;
import org.jboss.pnc.dto.response.SSHCredentials;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.BuildFetcher;
import org.jboss.pnc.facade.providers.api.BuildPageInfo;
import org.jboss.pnc.facade.providers.api.BuildProvider;
import org.jboss.pnc.facade.util.GraphDtoBuilder;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.mapper.api.BuildConfigurationRevisionMapper;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.EntityMapper;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.mapper.api.ResultMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationAudited;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildRecord_;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.IdRev;
import org.jboss.pnc.model.User;
import org.jboss.pnc.remotecoordinator.maintenance.TemporaryBuildsCleanerAsyncInvoker;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.coordinator.BuildTask;
import org.jboss.pnc.spi.coordinator.Result;
import org.jboss.pnc.spi.datastore.predicates.ArtifactPredicates;
import org.jboss.pnc.spi.datastore.predicates.BuildConfigurationPredicates;
import org.jboss.pnc.spi.datastore.predicates.BuildRecordPredicates;
import org.jboss.pnc.spi.datastore.repositories.ArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationAuditedRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.api.OrderInfo;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.DefaultOrderInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.DefaultPageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.DefaultSortInfo;
import org.jboss.pnc.spi.exception.MissingDataException;
import org.jboss.pnc.spi.exception.RemoteRequestException;
import org.jboss.pnc.spi.exception.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class BuildProviderImpl
extends AbstractUpdatableProvider<Base32LongID, BuildRecord, Build, BuildRef>
implements BuildProvider {
    private static final Logger logger = LoggerFactory.getLogger(BuildProviderImpl.class);
    private ArtifactRepository artifactRepository;
    private BuildRecordRepository buildRecordRepository;
    private BuildConfigurationRepository buildConfigurationRepository;
    private BuildConfigurationAuditedRepository buildConfigurationAuditedRepository;
    private BuildConfigSetRecordRepository buildConfigSetRecordRepository;
    private BuildConfigurationRevisionMapper buildConfigurationRevisionMapper;
    private BuildMapper buildMapper;
    private BuildCoordinator buildCoordinator;
    private UserService userService;
    private TemporaryBuildsCleanerAsyncInvoker temporaryBuildsCleanerAsyncInvoker;
    private ResultMapper resultMapper;
    private GroupBuildMapper groupBuildMapper;
    private BuildFetcher buildFetcher;
    private KeycloakServiceClient keycloakServiceClient;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Inject
    public BuildProviderImpl(ArtifactRepository artifactRepository, BuildRecordRepository repository, BuildMapper mapper, BuildConfigurationRepository buildConfigurationRepository, BuildConfigurationAuditedRepository buildConfigurationAuditedRepository, BuildConfigSetRecordRepository buildConfigSetRecordRepository, BuildConfigurationRevisionMapper buildConfigurationRevisionMapper, BuildCoordinator buildCoordinator, UserService userService, TemporaryBuildsCleanerAsyncInvoker temporaryBuildsCleanerAsyncInvoker, ResultMapper resultMapper, GroupBuildMapper groupBuildMapper, BuildFetcher buildFetcher, KeycloakServiceClient keycloakServiceClient) {
        super(repository, mapper, BuildRecord.class);
        this.artifactRepository = artifactRepository;
        this.buildRecordRepository = repository;
        this.buildConfigurationRepository = buildConfigurationRepository;
        this.buildConfigurationAuditedRepository = buildConfigurationAuditedRepository;
        this.buildConfigSetRecordRepository = buildConfigSetRecordRepository;
        this.buildConfigurationRevisionMapper = buildConfigurationRevisionMapper;
        this.buildMapper = mapper;
        this.buildCoordinator = buildCoordinator;
        this.userService = userService;
        this.temporaryBuildsCleanerAsyncInvoker = temporaryBuildsCleanerAsyncInvoker;
        this.resultMapper = resultMapper;
        this.groupBuildMapper = groupBuildMapper;
        this.buildFetcher = buildFetcher;
        this.keycloakServiceClient = keycloakServiceClient;
    }

    @Override
    public Build store(Build restEntity) throws DTOValidationException {
        throw new UnsupportedOperationException("Direct build creation is not available.");
    }

    @Override
    @RolesAllowed(value={"pnc-app-build-user", "pnc-users-admin"})
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting persistent builds is never allowed");
    }

    @Override
    @RolesAllowed(value={"pnc-app-build-user", "pnc-users-admin"})
    public Build update(String buildId, Build restEntity) {
        Base32LongID id = (Base32LongID)this.parseId(buildId);
        this.validateBeforeUpdating(id, restEntity);
        logger.debug("Updating build: " + restEntity.toString());
        BuildRecord entityInDB = (BuildRecord)this.repository.queryById((Serializable)id);
        entityInDB.setStatus(restEntity.getStatus());
        return (Build)this.mapper.toDTO((GenericEntity)entityInDB);
    }

    @Override
    @RolesAllowed(value={"pnc-app-build-delete", "pnc-app-build-user", "pnc-users-admin"})
    public boolean delete(String buildId, String callback) {
        try {
            return this.temporaryBuildsCleanerAsyncInvoker.deleteTemporaryBuild((Base32LongID)this.parseId(buildId), this.notifyOnBuildDeletionCompletion(callback));
        }
        catch (ValidationException e) {
            throw new RepositoryViolationException(e);
        }
    }

    private Consumer<Result> notifyOnBuildDeletionCompletion(String callback) {
        return result -> {
            if (callback != null && !callback.isEmpty()) {
                try {
                    HttpUtils.performHttpPostRequest((String)callback, (String)OBJECT_MAPPER.writeValueAsString((Object)this.resultMapper.toDTO(result)), (String)this.keycloakServiceClient.getAuthToken());
                }
                catch (JsonProcessingException e) {
                    logger.error("Failed to perform a callback of delete operation.", (Throwable)e);
                }
            }
        };
    }

    @Override
    public Page<Build> getAllIndependentTemporaryOlderThanTimestamp(int pageIndex, int pageSize, String sort, String q, long timestamp) {
        return this.queryForCollection(pageIndex, pageSize, sort, q, BuildRecordPredicates.temporaryBuild(), BuildRecordPredicates.buildFinishedBefore((Date)new Date(timestamp)), BuildRecordPredicates.withoutImplicitDependants(), BuildRecordPredicates.withoutLinkedNRRRecordOlderThanTimestamp((Date)new Date(timestamp)));
    }

    @Override
    public void addAttribute(String buildId, String key, String value) {
        BuildRecord buildRecord = this.getBuildRecord(buildId);
        if (null == key) {
            throw new IllegalArgumentException("Attribute key must not be null");
        }
        if (!key.matches("[a-zA-Z_0-9]+")) {
            throw new IllegalArgumentException("Attribute key must match [a-zA-Z_0-9]+");
        }
        switch (key) {
            case "BREW_BUILD_NAME": {
                buildRecord.setExecutionRootName(value);
                break;
            }
            case "BREW_BUILD_VERSION": {
                buildRecord.setExecutionRootVersion(value);
                break;
            }
            default: {
                buildRecord.putAttribute(key, value);
            }
        }
        this.repository.save((GenericEntity)buildRecord);
    }

    @Override
    public void removeAttribute(String buildId, String key) {
        BuildRecord buildRecord = this.getBuildRecord(buildId);
        switch (key) {
            case "BREW_BUILD_NAME": {
                buildRecord.setExecutionRootName(null);
                break;
            }
            case "BREW_BUILD_VERSION": {
                buildRecord.setExecutionRootVersion(null);
                break;
            }
            default: {
                buildRecord.removeAttribute(key);
            }
        }
        this.repository.save((GenericEntity)buildRecord);
    }

    @Override
    public BuildConfigurationRevision getBuildConfigurationRevision(String buildId) {
        BuildRecord buildRecord = this.getBuildRecord(buildId);
        if (buildRecord.getBuildConfigurationAudited() != null) {
            return this.buildConfigurationRevisionMapper.toDTO(buildRecord.getBuildConfigurationAudited());
        }
        BuildConfigurationAudited buildConfigurationAudited = this.buildConfigurationAuditedRepository.queryById(new IdRev(buildRecord.getBuildConfigurationId(), buildRecord.getBuildConfigurationRev()));
        return this.buildConfigurationRevisionMapper.toDTO(buildConfigurationAudited);
    }

    @Override
    public SSHCredentials getSshCredentials(String buildId) {
        BuildRecord buildRecord = this.getBuildRecord(buildId);
        User user = null;
        try {
            user = this.userService.currentUser();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        if (!buildRecord.getUser().equals((Object)user) && !this.userService.hasLoggedInUserRole("pnc-users-admin")) {
            throw new EJBAccessException("Only user who executed the build is allowed to get the SSH credentials");
        }
        return SSHCredentials.builder().command(buildRecord.getSshCommand()).password(buildRecord.getSshPassword()).build();
    }

    @Override
    public Page<Build> getAll(int pageIndex, int pageSize, String sort, String query) {
        BuildPageInfo pageInfo = new BuildPageInfo(pageIndex, pageSize, sort, query, false, false, "");
        return this.getBuilds(pageInfo);
    }

    @Override
    public Page<Build> getBuilds(BuildPageInfo pageInfo) {
        try {
            return this.getBuildList(pageInfo, _t -> true, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)((org.jboss.pnc.spi.datastore.repositories.api.Predicate)(_r, _q, cb) -> cb.conjunction()));
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<Build> getBuildsForMilestone(BuildPageInfo pageInfo, String milestoneId) {
        Predicate<BuildTask> predicate = t -> t.getProductMilestone() != null && Integer.valueOf(milestoneId).equals(t.getProductMilestone().getId());
        try {
            return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withPerformedInMilestone((Integer)Integer.valueOf(milestoneId)));
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<Build> getBuildsForProject(BuildPageInfo pageInfo, String projectId) {
        Set buildConfigIds = this.buildConfigurationRepository.queryWithPredicates(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[]{BuildConfigurationPredicates.withProjectId((Integer)Integer.valueOf(projectId))}).stream().map(BuildConfiguration::getId).collect(Collectors.toSet());
        Predicate<BuildTask> predicate = t -> Integer.valueOf(projectId).equals(t.getBuildConfigurationAudited().getProject().getId());
        try {
            return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withBuildConfigurationIds(buildConfigIds));
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<Build> getBuildsForArtifact(int pageIndex, int pageSize, String sortingRsql, String query, String artifactId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildRecordPredicates.withArtifactProduced((Integer)Integer.valueOf(artifactId)));
    }

    @Override
    public Page<Build> getDependantBuildsForArtifact(int pageIndex, int pageSize, String sortingRsql, String query, String artifactId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildRecordPredicates.withArtifactDependency((Integer)Integer.valueOf(artifactId)));
    }

    @Override
    public Page<Build> getBuildsForBuildConfiguration(BuildPageInfo pageInfo, String buildConfigurationId) {
        Predicate<BuildTask> predicate = t -> Integer.valueOf(buildConfigurationId).equals(t.getBuildConfigurationAudited().getId());
        try {
            return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withBuildConfigurationId((Integer)Integer.valueOf(buildConfigurationId)));
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<Build> getBuildsForUser(BuildPageInfo pageInfo, String userId) {
        Predicate<BuildTask> predicate = t -> Integer.valueOf(userId).equals(t.getUser().getId());
        try {
            return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withUserId((Integer)Integer.valueOf(userId)));
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<Build> getBuildsForGroupConfiguration(BuildPageInfo pageInfo, String groupConfigurationId) {
        Predicate<BuildTask> predicate = t -> t.getBuildSetTask() != null && t.getBuildSetTask().getBuildConfigSetRecord().map(gc -> Integer.valueOf(groupConfigurationId).equals(gc.getBuildConfigurationSet().getId())).orElse(false) != false;
        try {
            return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withBuildConfigSetId((Integer)Integer.valueOf(groupConfigurationId)));
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<Build> getBuildsForGroupBuild(BuildPageInfo pageInfo, String groupBuildId) {
        Predicate<BuildTask> predicate = t -> t.getBuildConfigSetRecordId() != null && t.getBuildConfigSetRecordId().equals(this.groupBuildMapper.getIdMapper().toEntity((Object)groupBuildId));
        try {
            return this.getBuildList(pageInfo, predicate, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)BuildRecordPredicates.withBuildConfigSetRecordId((Base32LongID)((Base32LongID)this.groupBuildMapper.getIdMapper().toEntity((Object)groupBuildId))));
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Graph<Build> getBuildGraphForGroupBuild(String groupBuildId) {
        Base32LongID id = (Base32LongID)this.groupBuildMapper.getIdMapper().toEntity((Object)groupBuildId);
        Set<Base32LongID> buildIDs = this.buildFetcher.getGroupBuildContent(id);
        this.buildFetcher.precacheAllBuildsDeps(buildIDs);
        org.jboss.util.graph.Graph buildGraph = new org.jboss.util.graph.Graph();
        for (Base32LongID buildId : buildIDs) {
            org.jboss.util.graph.Graph<BuildFetcher.BuildWithDeps> dependencyGraph = this.createBuildDependencyGraph(buildId.getId());
            GraphUtils.merge((org.jboss.util.graph.Graph)buildGraph, dependencyGraph);
            logger.trace("Merged graph from buildRecordId {} to BuildConfigSetRecordGraph {}; Edges {},", new Object[]{buildId, buildGraph, buildGraph.getEdges()});
        }
        return GraphDtoBuilder.from(buildGraph, Build.class, vertex -> ((BuildFetcher.BuildWithDeps)vertex.getData()).getBuild());
    }

    @Override
    public Graph<Build> getDependencyGraph(String buildId) {
        Base32LongID id = (Base32LongID)this.buildMapper.getIdMapper().toEntity((Object)buildId);
        if (!this.buildFetcher.buildExists(id)) {
            throw new EmptyEntityException("there is no record for given buildId.");
        }
        this.buildFetcher.precacheAllBuildsDeps(id);
        org.jboss.util.graph.Graph<BuildFetcher.BuildWithDeps> buildGraph = this.createBuildDependencyGraph(buildId);
        return GraphDtoBuilder.from(buildGraph, Build.class, vertex -> ((BuildFetcher.BuildWithDeps)vertex.getData()).getBuild());
    }

    private org.jboss.util.graph.Graph<BuildFetcher.BuildWithDeps> createBuildDependencyGraph(String buildId) {
        org.jboss.util.graph.Graph graph = new org.jboss.util.graph.Graph();
        GraphBuilder graphBuilder = new GraphBuilder(id -> this.buildFetcher.getBuildWithDeps((String)id), BuildFetcher.BuildWithDeps::getDependencies, BuildFetcher.BuildWithDeps::getDependants);
        graphBuilder.buildDependencyGraph(graph, (Object)buildId);
        graphBuilder.buildDependentGraph(graph, (Object)buildId);
        return graph;
    }

    @Override
    public URI getInternalScmArchiveLink(String buildId) {
        BuildRecord buildRecord = this.buildRecordRepository.findByIdFetchProperties((Base32LongID)this.parseId(buildId));
        if (buildRecord.getScmRevision() == null) {
            return null;
        }
        try {
            ScmUrlGeneratorProvider.SCMProvider provider = ScmUrlGeneratorProvider.determineScmProvider((String)buildRecord.getScmRepoURL(), (String)buildRecord.getBuildConfigurationAudited().getRepositoryConfiguration().getInternalUrl());
            return new URI(ScmUrlGeneratorProvider.getScmUrlGenerator((ScmUrlGeneratorProvider.SCMProvider)provider).generateTarballDownloadUrl(buildRecord.getScmRepoURL(), buildRecord.getScmRevision()));
        }
        catch (URISyntaxException | ScmException e) {
            throw new RepositoryViolationException(e);
        }
    }

    private BuildRecord getBuildRecord(String buildId) {
        BuildRecord buildRecord = (BuildRecord)this.repository.queryById((Serializable)((Base32LongID)this.parseId(buildId)));
        if (buildRecord == null) {
            throw new EmptyEntityException("Build with id: " + buildId + " does not exist!");
        }
        return buildRecord;
    }

    @Override
    public Build getSpecific(String buildId) {
        Build build = (Build)this.mapper.toDTO((GenericEntity)this.buildRecordRepository.findByIdFetchProperties((Base32LongID)this.parseId(buildId)));
        if (build == null) {
            try {
                build = this.buildCoordinator.getSubmittedBuildTask(buildId).map(arg_0 -> ((BuildMapper)this.buildMapper).fromBuildTask(arg_0)).orElse(null);
            }
            catch (MissingDataException | RemoteRequestException e) {
                throw new RuntimeException(e);
            }
        }
        return build;
    }

    @Override
    @RolesAllowed(value={"pnc-app-build-user", "pnc-users-admin"})
    public void setBuiltArtifacts(String buildId, List<String> artifactIds) {
        Set ids = artifactIds.stream().map(Integer::valueOf).collect(Collectors.toSet());
        List artifacts = this.artifactRepository.queryWithPredicates(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[]{ArtifactPredicates.withIds(ids)});
        if (ids.size() != artifacts.size()) {
            artifacts.stream().map(Artifact::getId).forEach(ids::remove);
            throw new InvalidEntityException("Artifacts not found, missing ids: " + ids);
        }
        Base32LongID id = (Base32LongID)this.parseId(buildId);
        BuildRecord buildRecord = (BuildRecord)this.repository.queryById((Serializable)id);
        for (Artifact artifact : artifacts) {
            if (artifact.getBuildRecord() != null && !id.equals((Object)artifact.getBuildRecord().getId())) {
                throw new ConflictedEntryException("Artifact " + artifact.getId() + " is already marked as built by different build.", BuildRecord.class, BuildMapper.idMapper.toDto(artifact.getBuildRecord().getId()));
            }
            artifact.setBuildRecord(buildRecord);
        }
        HashSet oldBuiltArtifacts = new HashSet(buildRecord.getBuiltArtifacts());
        oldBuiltArtifacts.stream().filter(a -> !ids.contains(a.getId())).forEach(a -> a.setBuildRecord(null));
    }

    @Override
    public Set<String> getBuiltArtifactIds(String buildId) {
        Base32LongID id = (Base32LongID)this.parseId(buildId);
        BuildRecord buildRecord = (BuildRecord)this.repository.queryById((Serializable)id);
        return StreamHelper.nullableStreamOf((Collection)buildRecord.getBuiltArtifacts()).map(builtArtifact -> builtArtifact.getId().toString()).collect(Collectors.toSet());
    }

    @Override
    @RolesAllowed(value={"pnc-app-build-user", "pnc-users-admin"})
    public void setDependentArtifacts(String buildId, List<String> artifactIds) {
        BuildRecord buildRecord = (BuildRecord)this.repository.queryById((Serializable)((Base32LongID)this.parseId(buildId)));
        Set artifacts = artifactIds.stream().map(aId -> Artifact.Builder.newBuilder().id(Integer.valueOf(aId)).build()).collect(Collectors.toSet());
        buildRecord.setDependencies(artifacts);
        this.repository.save((GenericEntity)buildRecord);
    }

    @Override
    public RunningBuildCount getRunningCount() {
        List x;
        try {
            x = this.buildCoordinator.getSubmittedBuildTasks();
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
        int waitingForDependencies = 0;
        int running = 0;
        int enqueued = 0;
        block7: for (BuildTask task : x) {
            switch (task.getStatus()) {
                case ENQUEUED: {
                    ++enqueued;
                    continue block7;
                }
                case BUILDING: {
                    ++running;
                    continue block7;
                }
                case WAITING_FOR_DEPENDENCIES: {
                    ++waitingForDependencies;
                    continue block7;
                }
            }
        }
        return new RunningBuildCount(running, enqueued, waitingForDependencies);
    }

    @Override
    public Page<Build> getByAttribute(BuildPageInfo buildPageInfo, Map<String, String> attributeConstraints) {
        HashSet<org.jboss.pnc.spi.datastore.repositories.api.Predicate> predicates = new HashSet<org.jboss.pnc.spi.datastore.repositories.api.Predicate>();
        for (Map.Entry<String, String> entry : attributeConstraints.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (key.startsWith("!")) {
                predicates.add(BuildRecordPredicates.withoutAttribute((String)key.substring(1)));
                continue;
            }
            predicates.add(BuildRecordPredicates.withAttribute((String)key, (String)value));
        }
        try {
            Predicate<BuildTask> none = _t -> false;
            return this.getBuildList(buildPageInfo, none, (org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>)org.jboss.pnc.spi.datastore.repositories.api.Predicate.and(predicates));
        }
        catch (MissingDataException | RemoteRequestException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Page<BuildRecordInsights> getAllBuildRecordInsightsNewerThanTimestamp(int pageIndex, int pageSize, Date lastupdatetime) {
        logger.debug("Executing getAllBuildRecordInsightsNewerThanTimestamp with parameters pageIndex: {}, pageSize: {}, lastupdatetime: {}", new Object[]{pageIndex, pageSize, lastupdatetime});
        int count = this.buildRecordRepository.countAllBuildRecordInsightsNewerThanTimestamp(lastupdatetime);
        logger.debug("BuildRecordInsightsCount: {}", (Object)count);
        int totalPages = pageSize == 0 ? 0 : (int)Math.ceil((double)count / (double)pageSize);
        logger.debug("TotalPages of BuildRecordInsightsCount: {}", (Object)totalPages);
        ArrayList<BuildRecordInsights> content = new ArrayList<BuildRecordInsights>();
        if (count > 0) {
            int offset = pageIndex * pageSize;
            logger.debug("offset: {}", (Object)offset);
            List rawBuildInsights = this.buildRecordRepository.getAllBuildRecordInsightsNewerThanTimestamp(lastupdatetime, pageSize, offset);
            for (Object[] rawBuildInsight : rawBuildInsights) {
                Long buildRecordId = ((BigInteger)rawBuildInsight[0]).longValue();
                String buildContentId = (String)rawBuildInsight[1];
                buildContentId = StringUtils.isEmpty((String)buildContentId) ? LongBase32IdConverter.toString((Long)buildRecordId) : buildContentId;
                Date submitTime = (Date)rawBuildInsight[2];
                Date startTime = (Date)rawBuildInsight[3];
                Date endTime = (Date)rawBuildInsight[4];
                Date lastTime = (Date)rawBuildInsight[5];
                Integer submitYear = (Integer)rawBuildInsight[6];
                Integer submitMonth = (Integer)rawBuildInsight[7];
                Integer submitQuarter = (Integer)rawBuildInsight[8];
                String status = (String)rawBuildInsight[9];
                Boolean temporaryBuild = (Boolean)rawBuildInsight[10];
                Boolean autoAlign = (Boolean)rawBuildInsight[11];
                Boolean brewPullActive = (Boolean)rawBuildInsight[12];
                String buildType = (String)rawBuildInsight[13];
                String executionRootName = (String)rawBuildInsight[14];
                String executionRootVersion = (String)rawBuildInsight[15];
                Integer userId = (Integer)rawBuildInsight[16];
                String username = (String)rawBuildInsight[17];
                Integer buildConfigurationId = (Integer)rawBuildInsight[18];
                Integer buildConfigurationRev = (Integer)rawBuildInsight[19];
                String buildConfigurationName = (String)rawBuildInsight[20];
                Integer buildConfigSetRecordId = (Integer)rawBuildInsight[21];
                Integer productMilestoneId = (Integer)rawBuildInsight[22];
                String productMilestoneVersion = (String)rawBuildInsight[23];
                Integer projectId = (Integer)rawBuildInsight[24];
                String projectName = (String)rawBuildInsight[25];
                Integer productVersionId = (Integer)rawBuildInsight[26];
                String productVersion = (String)rawBuildInsight[27];
                Integer productId = (Integer)rawBuildInsight[28];
                String productName = (String)rawBuildInsight[29];
                BuildRecordInsights buildRecordInsights = BuildRecordInsights.builder().buildId(buildRecordId).buildContentId(buildContentId).submitTime(TimeUtils.toInstant((Date)submitTime)).startTime(TimeUtils.toInstant((Date)startTime)).endTime(TimeUtils.toInstant((Date)endTime)).lastUpdateTime(TimeUtils.toInstant((Date)lastTime)).submitYear(submitYear).submitMonth(submitMonth).submitQuarter(submitQuarter).status(status).temporarybuild(temporaryBuild).autoalign(autoAlign).brewpullactive(brewPullActive).buildType(buildType).executionRootName(executionRootName).executionRootVersion(executionRootVersion).userId(userId).username(username).buildConfigurationId(buildConfigurationId).buildConfigurationRev(buildConfigurationRev).buildConfigurationName(buildConfigurationName).buildConfigSetRecordId(buildConfigSetRecordId).productMilestoneId(productMilestoneId).productMilestoneVersion(productMilestoneVersion).projectId(projectId).projectName(projectName).productVersionId(productVersionId).productVersionVersion(productVersion).productId(productId).productName(productName).build();
                content.add(buildRecordInsights);
            }
        }
        return new Page(pageIndex, pageSize, totalPages, count, content);
    }

    private DefaultPageInfo toPageInfo(BuildPageInfo buildPageInfo) {
        return new DefaultPageInfo(buildPageInfo.getPageIndex() * buildPageInfo.getPageSize(), buildPageInfo.getPageSize());
    }

    private Page<Build> getBuildList(BuildPageInfo pageInfo, Predicate<BuildTask> predicate, org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> dbPredicate) throws RemoteRequestException, MissingDataException {
        if (pageInfo.isRunning()) {
            if (pageInfo.isLatest()) {
                return this.getLatestRunningBuild(pageInfo.getQ(), predicate);
            }
            return this.getRunningBuilds(pageInfo, predicate);
        }
        if (pageInfo.isLatest()) {
            return this.getLatestBuild(pageInfo.getQ(), predicate, dbPredicate);
        }
        return this.getBuilds(pageInfo, predicate, dbPredicate);
    }

    private Page<Build> getLatestRunningBuild(String query, Predicate<BuildTask> predicate) throws RemoteRequestException, MissingDataException {
        List build = this.readLatestRunningBuild(query, predicate).map(Collections::singletonList).orElse(Collections.emptyList());
        return new Page(0, 1, build.size(), build.size(), build);
    }

    private Page<Build> getRunningBuilds(BuildPageInfo pageInfo, Predicate<BuildTask> predicate) throws RemoteRequestException, MissingDataException {
        List<Build> runningBuilds = this.readRunningBuilds(pageInfo, predicate);
        List builds = runningBuilds.stream().skip((long)pageInfo.getPageIndex() * (long)pageInfo.getPageSize()).limit(pageInfo.getPageSize()).collect(Collectors.toList());
        return new Page(pageInfo.getPageIndex(), pageInfo.getPageSize(), pageInfo.getPageSize() == 0 ? 0 : (int)Math.ceil((double)runningBuilds.size() / (double)pageInfo.getPageSize()), runningBuilds.size(), builds);
    }

    private Page<Build> getLatestBuild(String query, Predicate<BuildTask> predicate, org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> dbPredicate) throws RemoteRequestException, MissingDataException {
        TreeSet<Build> sorted = new TreeSet<Build>(Comparator.comparing(BuildRef::getSubmitTime).reversed());
        this.readLatestRunningBuild(query, predicate).ifPresent(sorted::add);
        this.readLatestFinishedBuild(query, dbPredicate).ifPresent(sorted::add);
        if (sorted.size() > 1) {
            sorted.pollLast();
        }
        return new Page(0, 1, sorted.size(), sorted.size(), sorted);
    }

    private Page<Build> getBuilds(BuildPageInfo pageInfo, Predicate<BuildTask> predicate, org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> dbPredicate) throws RemoteRequestException, MissingDataException {
        List<Build> runningBuilds = this.readRunningBuilds(pageInfo, predicate);
        org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>[] predicates = this.preparePredicates(dbPredicate, pageInfo.getQ(), pageInfo.getBuildConfigName());
        Comparator<Object> comparing = Comparator.comparing(BuildRef::getSubmitTime).reversed();
        SortInfo sortInfo = DefaultSortInfo.desc((SingularAttribute)BuildRecord_.submitTime);
        if (!StringUtils.isEmpty((String)pageInfo.getSort())) {
            comparing = this.rsqlPredicateProducer.getComparator(pageInfo.getSort());
            sortInfo = this.rsqlPredicateProducer.getSortInfo(this.type, pageInfo.getSort());
        }
        comparing = this.thenCompareByLongID(comparing);
        sortInfo = sortInfo.thenOrderBy((OrderInfo)DefaultOrderInfo.desc((SingularAttribute)BuildRecord_.id));
        List<Build> resultList = this.buildFetcher.getBuildPage(pageInfo.getPageIndex(), pageInfo.getPageSize(), runningBuilds, predicates, sortInfo, comparing);
        int hits = this.repository.count(predicates) + runningBuilds.size();
        return new Page(pageInfo.getPageIndex(), pageInfo.getPageSize(), pageInfo.getPageSize() == 0 ? 0 : (int)Math.ceil((double)hits / (double)pageInfo.getPageSize()), hits, resultList);
    }

    private Comparator<Build> thenCompareByLongID(Comparator<Build> comparing) {
        ToLongFunction<Build> longId = build -> ((Base32LongID)this.parseId(build.getId())).getLongId();
        Comparator<Build> sortByLongId = Comparator.comparingLong(longId).reversed();
        return comparing.thenComparing(sortByLongId);
    }

    private org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>[] preparePredicates(org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> dbPredicate, String query, String buildConfigName) {
        ArrayList<org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>> predicates = new ArrayList<org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord>>(3);
        predicates.add(dbPredicate);
        if (!StringUtils.isEmpty((String)query)) {
            predicates.add(this.rsqlPredicateProducer.getCriteriaPredicate(BuildRecord.class, query));
        }
        if (!StringUtils.isEmpty((String)buildConfigName)) {
            predicates.add(this.getPredicateWithBuildConfigName(buildConfigName));
        }
        return predicates.toArray(new org.jboss.pnc.spi.datastore.repositories.api.Predicate[0]);
    }

    private org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> getPredicateWithBuildConfigName(String buildConfigName) {
        Function<List, org.jboss.pnc.spi.datastore.repositories.api.Predicate> predicateFunction;
        String justBuildConfigName = buildConfigName;
        if (justBuildConfigName.startsWith("!")) {
            justBuildConfigName = justBuildConfigName.substring(1);
            predicateFunction = BuildRecordPredicates::exceptBuildConfigurationIdRev;
        } else {
            predicateFunction = BuildRecordPredicates::withBuildConfigurationIdRev;
        }
        String name = justBuildConfigName.replaceAll("[*]", "%").replaceAll("[?]", "_");
        List buildConfigurationsAudited = this.buildConfigurationAuditedRepository.searchForBuildConfigurationName(name);
        List buildConfigurationAuditedIdRevs = buildConfigurationsAudited.stream().filter(this.getBCAPredicateWithBuildConfigName(justBuildConfigName)).map(BuildConfigurationAudited::getIdRev).collect(Collectors.toList());
        if (!buildConfigurationAuditedIdRevs.isEmpty()) {
            return predicateFunction.apply(buildConfigurationAuditedIdRevs);
        }
        return org.jboss.pnc.spi.datastore.repositories.api.Predicate.nonMatching();
    }

    private List<Build> readRunningBuilds(BuildPageInfo pageInfo, Predicate<BuildTask> predicate) throws RemoteRequestException, MissingDataException {
        Predicate<Object> streamPredicate = f -> true;
        if (!StringUtils.isEmpty((String)pageInfo.getQ())) {
            streamPredicate = this.rsqlPredicateProducer.getStreamPredicate(pageInfo.getQ());
        }
        Comparator<Object> comparing = Comparator.comparing(BuildRef::getSubmitTime).reversed();
        if (!StringUtils.isEmpty((String)pageInfo.getSort())) {
            comparing = this.rsqlPredicateProducer.getComparator(pageInfo.getSort());
        }
        if (!StringUtils.isEmpty((String)pageInfo.getBuildConfigName())) {
            predicate = predicate.and(t -> this.getBCAPredicateWithBuildConfigName(pageInfo.getBuildConfigName()).test(t.getBuildConfigurationAudited()));
        }
        comparing = this.thenCompareByLongID(comparing);
        return StreamHelper.nullableStreamOf((Collection)this.buildCoordinator.getSubmittedBuildTasks()).filter(Objects::nonNull).filter(predicate).map(arg_0 -> ((BuildMapper)this.buildMapper).fromBuildTask(arg_0)).filter(streamPredicate).sorted(comparing).collect(Collectors.toList());
    }

    private Predicate<BuildConfigurationAudited> getBCAPredicateWithBuildConfigName(String buildConfigName) {
        Predicate<BuildConfigurationAudited> predicate;
        boolean negate = false;
        if (buildConfigName.startsWith("!")) {
            buildConfigName = buildConfigName.substring(1);
            negate = true;
        }
        if (buildConfigName.contains("*") || buildConfigName.contains("%") || buildConfigName.contains("?")) {
            String name = buildConfigName.replaceAll("[*%]", ".*").replaceAll("[?]", ".");
            predicate = bca -> bca.getName().matches(name);
        } else {
            String name = buildConfigName;
            predicate = bca -> name.equals(bca.getName());
        }
        if (negate) {
            predicate = predicate.negate();
        }
        return predicate;
    }

    private Optional<Build> readLatestRunningBuild(String query, Predicate<BuildTask> predicate) throws RemoteRequestException, MissingDataException {
        Predicate<Object> streamPredicate = StringUtils.isEmpty((String)query) ? f -> true : this.rsqlPredicateProducer.getStreamPredicate(query);
        Comparator<Build> comparator = Comparator.comparing(BuildRef::getSubmitTime).thenComparingLong(build -> ((Base32LongID)this.parseId(build.getId())).getLongId());
        return StreamHelper.nullableStreamOf((Collection)this.buildCoordinator.getSubmittedBuildTasks()).filter(Objects::nonNull).filter(predicate).map(arg_0 -> ((BuildMapper)this.buildMapper).fromBuildTask(arg_0)).filter(streamPredicate).max(comparator);
    }

    private Optional<Build> readLatestFinishedBuild(String query, org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> predicate) {
        org.jboss.pnc.spi.datastore.repositories.api.Predicate<BuildRecord> criteriaPredicate = (_r, _q, cb) -> cb.conjunction();
        if (!StringUtils.isEmpty((String)query)) {
            criteriaPredicate = this.rsqlPredicateProducer.getCriteriaPredicate(BuildRecord.class, query);
        }
        PageInfo pageInfo = this.pageInfoProducer.getPageInfo(0, 1);
        SortInfo sortInfo = DefaultSortInfo.desc((SingularAttribute[])new SingularAttribute[]{BuildRecord_.submitTime, BuildRecord_.id});
        List buildRecords = this.repository.queryWithPredicates(pageInfo, sortInfo, new org.jboss.pnc.spi.datastore.repositories.api.Predicate[]{criteriaPredicate, predicate});
        return buildRecords.stream().map(arg_0 -> ((EntityMapper)this.mapper).toDTO(arg_0)).findFirst();
    }
}

