/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.auth.KeycloakServiceClient;
import org.jboss.pnc.bpm.BpmEventType;
import org.jboss.pnc.bpm.Connector;
import org.jboss.pnc.bpm.model.RepositoryCreationProcess;
import org.jboss.pnc.bpm.task.RepositoryCreationTask;
import org.jboss.pnc.common.Configuration;
import org.jboss.pnc.common.concurrent.Sequence;
import org.jboss.pnc.common.json.ConfigurationParseException;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.json.moduleconfig.BpmModuleConfig;
import org.jboss.pnc.common.json.moduleconfig.ScmModuleConfig;
import org.jboss.pnc.common.json.moduleprovider.ConfigProvider;
import org.jboss.pnc.common.json.moduleprovider.PncConfigProvider;
import org.jboss.pnc.common.net.GitSCPUrl;
import org.jboss.pnc.common.scm.ScmException;
import org.jboss.pnc.common.scm.ScmUrlGeneratorProvider;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.common.util.UrlUtils;
import org.jboss.pnc.dto.BuildConfiguration;
import org.jboss.pnc.dto.SCMRepository;
import org.jboss.pnc.dto.notification.RepositoryCreationFailure;
import org.jboss.pnc.dto.notification.SCMRepositoryCreationSuccess;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.RepositoryCreationResponse;
import org.jboss.pnc.dto.tasks.RepositoryCreationResult;
import org.jboss.pnc.enums.JobNotificationType;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.BuildConfigurationProvider;
import org.jboss.pnc.facade.providers.api.SCMRepositoryProvider;
import org.jboss.pnc.facade.util.RepourClient;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.mapper.api.SCMRepositoryMapper;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.RepositoryConfiguration;
import org.jboss.pnc.spi.datastore.predicates.RepositoryConfigurationPredicates;
import org.jboss.pnc.spi.datastore.repositories.RepositoryConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.exception.CoreException;
import org.jboss.pnc.spi.exception.ProcessManagerException;
import org.jboss.pnc.spi.notifications.Notifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class SCMRepositoryProviderImpl
extends AbstractUpdatableProvider<Integer, RepositoryConfiguration, SCMRepository, SCMRepository>
implements SCMRepositoryProvider {
    private static final Logger log = LoggerFactory.getLogger(SCMRepositoryProviderImpl.class);
    private static final String RC_REPO_CREATION_CONFLICT = "RC_REPO_CREATION_CONFLICT";
    private ScmModuleConfig config;
    private static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("([\\/:][\\w\\.:\\~_-]+)+(\\.git)(?:\\/?|\\#[\\d\\w\\.\\-_]+?)$");
    @Inject
    private RepositoryConfigurationRepository repositoryConfigurationRepository;
    @Inject
    private KeycloakServiceClient keycloakServiceClient;
    @Inject
    private Notifier notifier;
    @Inject
    private BpmModuleConfig bpmConfig;
    @Inject
    private GlobalModuleGroup globalConfig;
    @Inject
    private RepourClient repour;
    @Inject
    private BuildConfigurationProvider buildConfigurationProvider;
    @Inject
    Connector connector;

    @Inject
    public SCMRepositoryProviderImpl(RepositoryConfigurationRepository repository, SCMRepositoryMapper mapper, Configuration configuration) throws ConfigurationParseException {
        super(repository, mapper, RepositoryConfiguration.class);
        this.config = (ScmModuleConfig)configuration.getModuleConfig((ConfigProvider)new PncConfigProvider(ScmModuleConfig.class));
    }

    @Override
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting scm repositories is prohibited!");
    }

    @Override
    public Page<SCMRepository> getAllWithMatchAndSearchUrl(int pageIndex, int pageSize, String sortingRsql, String query, String matchUrl, String searchUrl) {
        ArrayList<Predicate<Predicate>> predicates = new ArrayList<Predicate<Predicate>>();
        this.validateAndAddPredicate(predicates, matchUrl, RepositoryConfigurationPredicates::matchByScmUrl);
        this.validateAndAddPredicate(predicates, searchUrl, RepositoryConfigurationPredicates::searchByScmUrl);
        Predicate[] predicatesArray = new Predicate[predicates.size()];
        predicatesArray = predicates.toArray(predicatesArray);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, predicatesArray);
    }

    private <T> void validateAndAddPredicate(List<Predicate<T>> list, String str, Function<String, Predicate<T>> item) {
        if (str != null && !str.isEmpty()) {
            try {
                list.add(item.apply(str));
            }
            catch (IllegalArgumentException ex) {
                throw new InvalidEntityException(ex.getMessage());
            }
        }
    }

    @Override
    public RepositoryCreationResponse createSCMRepository(String scmUrl, Boolean preBuildSyncEnabled) {
        RepositoryCreationResponse scmRepository = this.createSCMRepository(scmUrl, preBuildSyncEnabled, JobNotificationType.SCM_REPOSITORY_CREATION, Optional.empty());
        if (scmRepository.getTaskId() == null) {
            this.notifySCMRepositoryCreated(new SCMRepositoryProvider.RepositoryCreated(null, Integer.valueOf(scmRepository.getRepository().getId())));
        }
        return scmRepository;
    }

    private void notifySCMRepositoryCreated(SCMRepositoryProvider.RepositoryCreated event) {
        String taskId;
        SCMRepository repository = (SCMRepository)this.getSpecific(Integer.toString(event.getRepositoryId()));
        String string = taskId = event.getTaskId() == null ? null : event.getTaskId().toString();
        if (taskId != null) {
            this.notifier.sendMessage((Object)new SCMRepositoryCreationSuccess(repository, taskId));
        }
    }

    @Override
    public RepositoryCreationResponse createSCMRepository(String scmUrl, Boolean preBuildSyncEnabled, JobNotificationType jobType, Optional<BuildConfiguration> buildConfiguration) {
        return this.createSCMRepository(scmUrl, null, preBuildSyncEnabled, jobType, buildConfiguration);
    }

    @Override
    public RepositoryCreationResponse createSCMRepository(String scmUrl, String revision, Boolean preBuildSyncEnabled, JobNotificationType jobType, Optional<BuildConfiguration> buildConfiguration) {
        log.trace("Received request to start RC creation with url autodetect: " + scmUrl + " (sync enabled? " + preBuildSyncEnabled + ")");
        if (StringUtils.isEmpty((String)scmUrl)) {
            throw new InvalidEntityException("You must specify the SCM URL.");
        }
        String secondaryAuthority = this.config.getSecondaryInternalScmAuthority();
        if (scmUrl.contains(this.config.getInternalScmAuthority()) || secondaryAuthority != null && scmUrl.contains(secondaryAuthority)) {
            this.validateInternalRepository(scmUrl);
            this.validateRepositoryWithInternalURLDoesNotExist(scmUrl, null);
            SCMRepository scmRepository = this.createSCMRepositoryFromValues(null, scmUrl, false);
            return new RepositoryCreationResponse(scmRepository);
        }
        this.validateRepositoryWithExternalURLDoesNotExist(scmUrl, null);
        boolean sync = preBuildSyncEnabled == null || preBuildSyncEnabled != false;
        Long taskId = this.startRCreationTask(scmUrl, revision, sync, jobType, buildConfiguration);
        return new RepositoryCreationResponse(taskId.longValue());
    }

    @Override
    public void validateBeforeUpdating(Integer id, SCMRepository restEntity) {
        super.validateBeforeUpdating(id, restEntity);
        RepositoryConfiguration entityInDb = (RepositoryConfiguration)this.findInDB(id);
        if (!entityInDb.getInternalUrl().equals(restEntity.getInternalUrl())) {
            throw new InvalidEntityException("Updating internal URL is prohibited. SCMRepo: " + id);
        }
        if (restEntity.getExternalUrl() != null && !restEntity.getExternalUrl().equals(entityInDb.getExternalUrl())) {
            this.validateRepositoryWithExternalURLDoesNotExist(restEntity.getExternalUrl(), id);
        }
    }

    private SCMRepository createSCMRepositoryFromValues(String externalScmUrl, String internalScmUrl, boolean preBuildSyncEnabled) {
        RepositoryConfiguration.Builder rcBuilder = RepositoryConfiguration.Builder.newBuilder().internalUrl(internalScmUrl).preBuildSyncEnabled(preBuildSyncEnabled);
        if (externalScmUrl != null) {
            rcBuilder.externalUrl(externalScmUrl);
        }
        RepositoryConfiguration entity = (RepositoryConfiguration)this.repository.save((GenericEntity)rcBuilder.build());
        log.info("Created SCM repository: {}.", (Object)entity.toString());
        return (SCMRepository)this.mapper.toDTO((GenericEntity)entity);
    }

    public void validateInternalRepository(String internalRepoUrl) throws InvalidEntityException {
        String secondaryInternalScmAuthority;
        String internalScmAuthority = this.config.getInternalScmAuthority();
        if (!SCMRepositoryProviderImpl.isInternalRepository(internalScmAuthority, secondaryInternalScmAuthority = this.config.getSecondaryInternalScmAuthority(), internalRepoUrl).booleanValue()) {
            log.info("Invalid internal repo url: " + internalRepoUrl);
            throw new InvalidEntityException("Internal repository url has to start with: <protocol>://" + internalScmAuthority + " followed by a repository name or match the pattern: " + REPOSITORY_NAME_PATTERN);
        }
        if (SCMRepositoryProviderImpl.usingGitlabButNotScpFormat(internalRepoUrl)) {
            log.info("Invalid internal repo url: We only allow internal gitlab repo url in scp format");
            throw new InvalidEntityException("Internal Gitlab repository url has to follow format: git@<server>:<path to git repo>.git");
        }
        if (internalRepoUrl.contains("/gerrit/")) {
            log.info("Invalid internal repo url: " + internalRepoUrl);
            throw new InvalidEntityException("Incorrect format of internal repository. Internal repository url should not contain '/gerrit/' part of the url");
        }
        if (internalRepoUrl.split("://")[0].contains("http")) {
            log.info("Invalid internal repo url: " + internalRepoUrl);
            throw new InvalidEntityException("Incorrect url protocol. Http and https protocols are not supported for internal repository. Try using 'git+ssh'");
        }
    }

    protected static Boolean isInternalRepository(String internalScmAuthority, String secondaryInternalScmAuthority, String internalRepoUrl) {
        if (StringUtils.isEmpty((String)internalRepoUrl) || internalScmAuthority == null) {
            throw new IllegalArgumentException("InternalScmAuthority and internalRepoUrl parameters must be set.");
        }
        String internalRepoUrlNoProto = internalRepoUrl.startsWith("git@") ? internalRepoUrl.substring(4) : UrlUtils.stripProtocol((String)internalRepoUrl);
        String internalRepoName = internalRepoUrlNoProto.replace(internalScmAuthority, "");
        boolean isInternal = internalRepoUrlNoProto.startsWith(internalScmAuthority);
        if (isInternal) {
            internalRepoName = internalRepoUrlNoProto.replace(internalScmAuthority, "");
        } else if (!StringUtils.isEmpty((String)secondaryInternalScmAuthority) && (isInternal = internalRepoUrlNoProto.startsWith(secondaryInternalScmAuthority))) {
            internalRepoName = internalRepoUrlNoProto.replace(secondaryInternalScmAuthority, "");
        }
        return isInternal && REPOSITORY_NAME_PATTERN.matcher(internalRepoName).matches();
    }

    private void validateRepositoryWithInternalURLDoesNotExist(String internalUrl, Integer ignoreId) throws ConflictedEntryException {
        RepositoryConfiguration repositoryConfiguration = this.repositoryConfigurationRepository.queryByInternalScm(internalUrl);
        if (repositoryConfiguration != null && !repositoryConfiguration.getId().equals(ignoreId)) {
            String message = "SCM Repository with internal URL '" + internalUrl + "'already exists (id: " + repositoryConfiguration.getId() + ")";
            throw new ConflictedEntryException(message, RepositoryConfiguration.class, repositoryConfiguration.getId().toString());
        }
    }

    private void validateRepositoryWithExternalURLDoesNotExist(String externalUrl, Integer ignoreId) throws ConflictedEntryException {
        RepositoryConfiguration repositoryConfiguration = this.repositoryConfigurationRepository.queryByExternalScm(externalUrl);
        if (repositoryConfiguration != null && !repositoryConfiguration.getId().equals(ignoreId)) {
            String message = "SCM Repository with external URL '" + externalUrl + "' already exists (id: " + repositoryConfiguration.getId() + ")";
            throw new ConflictedEntryException(message, RepositoryConfiguration.class, repositoryConfiguration.getId().toString());
        }
        String internalUrl = this.repour.translateExternalUrl(externalUrl);
        this.validateRepositoryWithInternalURLDoesNotExist(internalUrl, ignoreId);
    }

    private Long startRCreationTask(String externalURL, String revision, boolean preBuildSyncEnabled, JobNotificationType jobType, Optional<BuildConfiguration> buildConfiguration) {
        String authToken = this.keycloakServiceClient.getAuthToken();
        org.jboss.pnc.bpm.model.RepositoryConfiguration repositoryConfiguration = org.jboss.pnc.bpm.model.RepositoryConfiguration.builder().externalUrl(externalURL).preBuildSyncEnabled(Boolean.valueOf(preBuildSyncEnabled)).build();
        RepositoryCreationProcess.RepositoryCreationProcessBuilder repositoryCreationProcess = RepositoryCreationProcess.builder().repositoryConfiguration(repositoryConfiguration).revision(revision);
        buildConfiguration.ifPresent(arg_0 -> ((RepositoryCreationProcess.RepositoryCreationProcessBuilder)repositoryCreationProcess).buildConfiguration(arg_0));
        RepositoryCreationTask task = new RepositoryCreationTask(repositoryCreationProcess.build(), jobType, this.globalConfig);
        long id = Sequence.nextId();
        try {
            HashMap<String, Serializable> parameters = new HashMap<String, Serializable>();
            parameters.put("processParameters", task.getProcessParameters());
            parameters.put("taskId", Long.valueOf(id));
            this.connector.startProcess(this.bpmConfig.getNewBcCreationProcessId(), parameters, Objects.toString(id), authToken);
        }
        catch (CoreException e) {
            throw new RuntimeException("Could not get process parameters: " + task, e);
        }
        catch (ProcessManagerException e) {
            throw new RuntimeException("Could not start BPM task using REST connector: " + task, e);
        }
        return id;
    }

    @Override
    public void repositoryCreationCompleted(RepositoryCreationResult result) {
        if (result.getStatus().isSuccess()) {
            RepositoryConfiguration existing = (RepositoryConfiguration)this.repository.queryByPredicates(new Predicate[]{RepositoryConfigurationPredicates.withExactInternalScmRepoUrl((String)result.getInternalScmUrl())});
            if (existing != null) {
                RepositoryCreationFailure error = new RepositoryCreationFailure(result.getJobType(), RC_REPO_CREATION_CONFLICT, (Object)existing, result.getTaskId().toString());
                this.notifier.sendMessage((Object)error);
            } else {
                SCMRepository scmRepo = this.createSCMRepositoryFromValues(result.getExternalUrl(), result.getInternalScmUrl(), result.isPreBuildSyncEnabled());
                SCMRepositoryProvider.RepositoryCreated notification = new SCMRepositoryProvider.RepositoryCreated(result.getTaskId(), Integer.parseInt(scmRepo.getId()));
                log.debug("Repository created: {}", (Object)notification);
                if (result.getJobType().equals((Object)JobNotificationType.BUILD_CONFIG_CREATION)) {
                    this.buildConfigurationProvider.createBuildConfigurationWithRepository(result.getTaskId().toString(), notification.getRepositoryId(), result.getBuildConfiguration());
                }
                this.notifySCMRepositoryCreated(notification);
            }
        } else {
            String eventType = !result.isRepoCreatedSuccessfully() ? BpmEventType.RC_REPO_CREATION_ERROR.toString() : BpmEventType.RC_REPO_CLONE_ERROR.toString();
            org.jboss.pnc.bpm.model.RepositoryConfiguration repositoryConfiguration = org.jboss.pnc.bpm.model.RepositoryConfiguration.builder().externalUrl(result.getExternalUrl()).preBuildSyncEnabled(Boolean.valueOf(result.isPreBuildSyncEnabled())).build();
            RepositoryCreationProcess repositoryCreationProcess = RepositoryCreationProcess.builder().repositoryConfiguration(repositoryConfiguration).build();
            this.notifier.sendMessage((Object)new RepositoryCreationFailure(result.getJobType(), eventType, (Object)repositoryCreationProcess, result.getTaskId().toString()));
        }
    }

    static boolean usingGitlabButNotScpFormat(String internalRepoUrl) {
        try {
            ScmUrlGeneratorProvider.SCMProvider provider = ScmUrlGeneratorProvider.determineInternalScmProvider((String)internalRepoUrl);
            if (ScmUrlGeneratorProvider.SCMProvider.GITLAB != provider) {
                return false;
            }
        }
        catch (ScmException e) {
            return false;
        }
        try {
            GitSCPUrl.parse((String)internalRepoUrl);
            return false;
        }
        catch (MalformedURLException e) {
            return true;
        }
    }
}

