/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.deliverables;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.ObservesAsync;
import javax.inject.Inject;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.coordinator.notifications.buildTask.MessageSenderProvider;
import org.jboss.pnc.facade.deliverables.DeliverableAnalysisStatusChangedEvent;
import org.jboss.pnc.messaging.spi.AnalysisStatusMessage;
import org.jboss.pnc.messaging.spi.Message;
import org.jboss.pnc.messaging.spi.MessageSender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
public class DeliverableAnalysisStatusMQNotifications {
    private final String ATTRIBUTE_NAME = "deliverable-analysis-state-change";
    private final Logger logger = LoggerFactory.getLogger(DeliverableAnalysisStatusMQNotifications.class);
    private final Optional<MessageSender> messageSender;

    @Inject
    public DeliverableAnalysisStatusMQNotifications(MessageSenderProvider messageSenderProvider) {
        this.messageSender = messageSenderProvider.getMessageSender();
    }

    public void observeEvent(@ObservesAsync DeliverableAnalysisStatusChangedEvent event) {
        this.logger.debug("Observed new analysis status changed event {}.", (Object)event);
        this.messageSender.ifPresent(ms -> this.send((MessageSender)ms, event));
        this.logger.debug("Analysis status changed event processed {}.", (Object)event);
    }

    private void send(MessageSender ms, DeliverableAnalysisStatusChangedEvent event) {
        OperationResult result = event.getResult();
        AnalysisStatusMessage message = new AnalysisStatusMessage(event.getOperationId(), "deliverable-analysis-state-change", event.getMilestoneId(), event.getStatus().toString(), result == null ? null : result.toString(), event.getDeliverablesUrls());
        ms.sendToTopic((Message)message, this.prepareHeaders(message));
    }

    private Map<String, String> prepareHeaders(AnalysisStatusMessage message) {
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("type", "DeliverableAnalysisStateChange");
        headers.put("attribute", "deliverable-analysis-state-change");
        headers.put("milestoneId", message.getMilestoneId());
        headers.put("status", message.getStatus());
        headers.put("result", message.getResult());
        headers.put("operationId", message.getOperationId());
        return headers;
    }
}

