/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import javax.annotation.security.PermitAll;
import lombok.Generated;
import org.jboss.pnc.dto.DTOEntity;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.facade.validation.ValidationBuilder;
import org.jboss.pnc.mapper.api.UpdatableEntityMapper;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.api.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
public abstract class AbstractUpdatableProvider<ID extends Serializable, DB extends GenericEntity<ID>, DTO extends REF, REF extends DTOEntity>
extends AbstractProvider<ID, DB, DTO, REF> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractUpdatableProvider.class);

    public AbstractUpdatableProvider(Repository<DB, ID> repository, UpdatableEntityMapper<ID, DB, DTO, REF> mapper, Class<DB> type) {
        super(repository, mapper, type);
    }

    @Override
    public UpdatableEntityMapper<ID, DB, DTO, REF> mapper() {
        return (UpdatableEntityMapper)this.mapper;
    }

    @Override
    public DTO update(String stringId, DTO restEntity) {
        Object id = this.parseId(stringId);
        this.validateBeforeUpdating(id, restEntity);
        log.debug("Updating entity: " + restEntity.toString());
        GenericEntity dbEntity = this.repository.queryById(id);
        log.debug("Updating existing entity: " + dbEntity);
        this.preUpdate(dbEntity, restEntity);
        this.mapper().updateEntity(restEntity, dbEntity);
        this.onUpdate(dbEntity);
        log.debug("Updated entity: " + dbEntity);
        return (DTO)this.mapper().toDTO(dbEntity);
    }

    protected DB findInDB(ID id) {
        GenericEntity dbEntity = this.repository.queryById(id);
        if (dbEntity == null) {
            throw new RepositoryViolationException("Entity should exist in the DB.");
        }
        return (DB)dbEntity;
    }

    protected void validateBeforeUpdating(ID id, DTO restEntity) {
        ValidationBuilder.validateObject(restEntity, WhenUpdating.class).validateNotEmptyArgument().validateAnnotations().validateAgainstRepository(this.repository, id, true);
    }

    protected void onUpdate(DB dbEntity) {
    }

    protected void preUpdate(DB dbEntity, DTO restEntity) {
    }
}

