/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.persistence.metamodel.SingularAttribute;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.core.Context;
import org.jboss.pnc.auth.KeycloakServiceClient;
import org.jboss.pnc.common.util.HttpUtils;
import org.jboss.pnc.coordinator.maintenance.TemporaryBuildsCleanerAsyncInvoker;
import org.jboss.pnc.dto.GroupBuild;
import org.jboss.pnc.dto.GroupBuildRef;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.GroupBuildPageInfo;
import org.jboss.pnc.facade.providers.api.GroupBuildProvider;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.mapper.api.EntityMapper;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.mapper.api.GroupConfigurationMapper;
import org.jboss.pnc.mapper.api.ResultMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildConfigSetRecord;
import org.jboss.pnc.model.BuildConfigSetRecord_;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.coordinator.Result;
import org.jboss.pnc.spi.datastore.predicates.BuildConfigSetRecordPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.DefaultPageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.impl.DefaultSortInfo;
import org.jboss.pnc.spi.exception.CoreException;
import org.jboss.pnc.spi.exception.ValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class GroupBuildProviderImpl
extends AbstractProvider<Base32LongID, BuildConfigSetRecord, GroupBuild, GroupBuildRef>
implements GroupBuildProvider {
    private static final Logger logger = LoggerFactory.getLogger(GroupBuildProviderImpl.class);
    @Inject
    private BuildConfigurationSetRepository buildConfigSetRecordRepository;
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;
    @Inject
    private TemporaryBuildsCleanerAsyncInvoker temporaryBuildsCleanerAsyncInvoker;
    @Inject
    private BuildCoordinator buildCoordinator;
    @Inject
    private GroupConfigurationMapper groupConfigurationMapper;
    @Context
    private HttpServletRequest httpServletRequest;
    @Inject
    private KeycloakServiceClient keycloakServiceClient;
    private UserService userService;
    private ResultMapper resultMapper;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    @Inject
    public GroupBuildProviderImpl(BuildConfigSetRecordRepository repository, GroupBuildMapper mapper, UserService userService, ResultMapper resultMapper) {
        super(repository, mapper, BuildConfigSetRecord.class);
        this.userService = userService;
        this.resultMapper = resultMapper;
    }

    @Override
    public GroupBuild store(GroupBuild restEntity) throws DTOValidationException {
        throw new UnsupportedOperationException("Direct GroupBuilds creation is not available.");
    }

    @Override
    @RolesAllowed(value={"pnc-app-build-user", "pnc-users-admin"})
    public GroupBuild update(String id, GroupBuild restEntity) {
        return super.update(id, restEntity);
    }

    @Override
    public boolean delete(String id, String callback) {
        try {
            String accessToken = this.keycloakServiceClient.getAuthToken();
            return this.temporaryBuildsCleanerAsyncInvoker.deleteTemporaryBuildConfigSetRecord((Base32LongID)this.mapper.getIdMapper().toEntity((Object)id), accessToken, this.notifyOnDeletionCompletion(callback, accessToken));
        }
        catch (ValidationException e) {
            throw new RepositoryViolationException(e);
        }
    }

    private Consumer<Result> notifyOnDeletionCompletion(String callbackUrl, String accessToken) {
        return result -> {
            if (callbackUrl != null && !callbackUrl.isEmpty()) {
                try {
                    HttpUtils.performHttpPostRequest((String)callbackUrl, (String)OBJECT_MAPPER.writeValueAsString((Object)this.resultMapper.toDTO(result)), (String)accessToken);
                }
                catch (JsonProcessingException e) {
                    logger.error("Failed to perform a callback of BuildConfigSetRecord delete operation.", (Throwable)e);
                }
            }
        };
    }

    @Override
    public Page<GroupBuild> getGroupBuilds(GroupBuildPageInfo groupBuildPageInfo, String groupConfigId) {
        Integer groupConfigIdModel = (Integer)this.groupConfigurationMapper.getIdMapper().toEntity((Object)groupConfigId);
        if (groupBuildPageInfo.isLatest()) {
            DefaultPageInfo firstPageInfo = new DefaultPageInfo(0, 1);
            SortInfo sortInfo = DefaultSortInfo.desc((SingularAttribute)BuildConfigSetRecord_.startTime);
            List groupBuildsEntities = this.repository.queryWithPredicates((PageInfo)firstPageInfo, sortInfo, new Predicate[]{BuildConfigSetRecordPredicates.withBuildConfigSetId((Integer)groupConfigIdModel)});
            List groupBuilds = groupBuildsEntities.stream().map(arg_0 -> ((EntityMapper)this.mapper).toDTO(arg_0)).collect(Collectors.toList());
            return new Page(0, 1, groupBuilds.size(), groupBuilds.size(), groupBuilds);
        }
        return this.queryForCollection(groupBuildPageInfo.getPageIndex(), groupBuildPageInfo.getPageSize(), groupBuildPageInfo.getSort(), groupBuildPageInfo.getQ(), BuildConfigSetRecordPredicates.withBuildConfigSetId((Integer)groupConfigIdModel));
    }

    @Override
    public void cancel(String id) {
        try {
            this.buildCoordinator.cancelSet((Base32LongID)this.mapper.getIdMapper().toEntity((Object)id));
        }
        catch (CoreException e) {
            throw new RuntimeException("Error when canceling buildConfigSetRecord with id: " + id, e);
        }
    }
}

