/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.enterprise.event.ObservesAsync;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.Tuple;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.SetJoin;
import org.apache.commons.collections.ListUtils;
import org.commonjava.atlas.maven.ident.ref.SimpleArtifactRef;
import org.commonjava.atlas.npm.ident.ref.NpmPackageRef;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.auth.KeycloakServiceClient;
import org.jboss.pnc.common.graph.UndirectedGraphBuilder;
import org.jboss.pnc.common.graph.VertexNeighbor;
import org.jboss.pnc.common.util.ArtifactCoordinatesUtils;
import org.jboss.pnc.datastore.repositories.internal.SortInfoConverter;
import org.jboss.pnc.dto.ProductMilestone;
import org.jboss.pnc.dto.ProductMilestoneRef;
import org.jboss.pnc.dto.requests.BuildPushParameters;
import org.jboss.pnc.dto.response.DeliveredArtifactInMilestones;
import org.jboss.pnc.dto.response.Graph;
import org.jboss.pnc.dto.response.MilestoneInfo;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.response.ParsedArtifact;
import org.jboss.pnc.dto.response.ValidationResponse;
import org.jboss.pnc.dto.response.statistics.ProductMilestoneDeliveredArtifactsStatistics;
import org.jboss.pnc.dto.response.statistics.ProductMilestoneStatistics;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.enums.RepositoryType;
import org.jboss.pnc.enums.ValidationErrorType;
import org.jboss.pnc.facade.BrewPusher;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.ArtifactProvider;
import org.jboss.pnc.facade.providers.api.ProductMilestoneProvider;
import org.jboss.pnc.facade.rsql.mapper.MilestoneInfoRSQLMapper;
import org.jboss.pnc.facade.util.GraphDtoBuilder;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.validation.AlreadyRunningException;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.ConflictedEntryValidator;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.facade.validation.ValidationBuilder;
import org.jboss.pnc.mapper.api.BuildPushOperationMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.Artifact;
import org.jboss.pnc.model.Artifact_;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildPushOperation;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.BuildRecord_;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.ProductMilestone_;
import org.jboss.pnc.model.ProductRelease_;
import org.jboss.pnc.model.ProductVersion;
import org.jboss.pnc.model.ProductVersion_;
import org.jboss.pnc.model.Product_;
import org.jboss.pnc.spi.datastore.predicates.BuildPushPredicates;
import org.jboss.pnc.spi.datastore.predicates.OperationPredicates;
import org.jboss.pnc.spi.datastore.predicates.ProductMilestonePredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildPushOperationRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;
import org.jboss.pnc.spi.events.OperationChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class ProductMilestoneProviderImpl
extends AbstractUpdatableProvider<Integer, org.jboss.pnc.model.ProductMilestone, ProductMilestone, ProductMilestoneRef>
implements ProductMilestoneProvider {
    private static final Logger log = LoggerFactory.getLogger(ProductMilestoneProviderImpl.class);
    private static final Logger userLog = LoggerFactory.getLogger((String)"org.jboss.pnc._userlog_.milestone");
    private final MilestoneInfoRSQLMapper milestoneInfoRSQLMapper;
    @Inject
    private KeycloakServiceClient keycloakServiceClient;
    private final ProductMilestoneRepository milestoneRepository;
    private final DeliverableArtifactRepository deliverableArtifactRepository;
    private final BrewPusher brewPusher;
    private final BuildPushOperationRepository buildPushOperationRepository;
    @Inject
    private ArtifactProvider artifactProvider;
    private BuildPushOperationMapper buildPushOperationMapper;
    @Inject
    private EntityManager em;
    @Inject
    private UserService userService;

    @Inject
    public ProductMilestoneProviderImpl(ProductMilestoneRepository repository, DeliverableArtifactRepository deliverableArtifactRepository, ProductMilestoneMapper mapper, MilestoneInfoRSQLMapper milestoneInfoRSQLMapper, BrewPusher brewPusher, BuildPushOperationRepository buildPushOperationRepository, BuildPushOperationMapper buildPushOperationMapper) {
        super(repository, mapper, org.jboss.pnc.model.ProductMilestone.class);
        this.milestoneRepository = repository;
        this.deliverableArtifactRepository = deliverableArtifactRepository;
        this.milestoneInfoRSQLMapper = milestoneInfoRSQLMapper;
        this.brewPusher = brewPusher;
        this.buildPushOperationRepository = buildPushOperationRepository;
        this.buildPushOperationMapper = buildPushOperationMapper;
    }

    @Override
    protected void validateBeforeSaving(ProductMilestone restEntity) {
        super.validateBeforeSaving(restEntity);
        this.validateDoesNotConflict(restEntity);
    }

    @Override
    protected void validateBeforeUpdating(Integer id, ProductMilestone restEntity) {
        super.validateBeforeUpdating(id, restEntity);
        org.jboss.pnc.model.ProductMilestone milestoneInDb = (org.jboss.pnc.model.ProductMilestone)this.findInDB(id);
        if (milestoneInDb.getEndDate() != null) {
            log.info("Milestone is already closed: no more modifications allowed");
            throw new RepositoryViolationException("Milestone is already closed! No more modifications allowed");
        }
        this.validateDoesNotConflict(restEntity);
    }

    private void validateDoesNotConflict(ProductMilestone restEntity) throws ConflictedEntryException, InvalidEntityException {
        ValidationBuilder.validateObject(restEntity, WhenUpdating.class).validateConflict(() -> {
            org.jboss.pnc.model.ProductMilestone milestoneFromDB = (org.jboss.pnc.model.ProductMilestone)this.milestoneRepository.queryByPredicates(new Predicate[]{ProductMilestonePredicates.withProductVersionIdAndVersion((Integer)Integer.valueOf(restEntity.getProductVersion().getId()), (String)restEntity.getVersion())});
            Integer restEntityId = null;
            if (restEntity.getId() != null) {
                restEntityId = Integer.valueOf(restEntity.getId());
            }
            if (milestoneFromDB != null && !milestoneFromDB.getId().equals(restEntityId)) {
                return new ConflictedEntryValidator.ConflictedEntryValidationError<Integer>(milestoneFromDB.getId(), org.jboss.pnc.model.ProductMilestone.class, "Product milestone with the same product version and version already exists");
            }
            return null;
        });
    }

    @Override
    public void closeMilestone(String id, boolean skipPush) {
        org.jboss.pnc.model.ProductMilestone milestoneInDb = (org.jboss.pnc.model.ProductMilestone)this.milestoneRepository.queryById((Serializable)Integer.valueOf(id));
        if (milestoneInDb.getEndDate() != null) {
            throw new RepositoryViolationException("Milestone is already closed! No more modifications allowed");
        }
        if (milestoneInDb.getPerformedBuilds().isEmpty()) {
            throw new InvalidEntityException("No builds were performed in milestone!");
        }
        if (skipPush) {
            this.close(milestoneInDb);
            return;
        }
        Set<Base32LongID> buildIds = ProductMilestoneProviderImpl.buildsToPush(milestoneInDb);
        List<BuildPushOperation> runningOperations = this.runningBuildPushes(buildIds);
        if (!runningOperations.isEmpty()) {
            List runningOperationsDTO = runningOperations.stream().map(arg_0 -> ((BuildPushOperationMapper)this.buildPushOperationMapper).toDTO(arg_0)).collect(Collectors.toList());
            throw new AlreadyRunningException("Build push for builds in milestone already in progress.", runningOperationsDTO);
        }
        this.doCloseMilestone(milestoneInDb, buildIds);
    }

    private static Set<Base32LongID> buildsToPush(org.jboss.pnc.model.ProductMilestone milestoneInDb) {
        return milestoneInDb.getPerformedBuilds().stream().filter(build -> build.getStatus() == BuildStatus.SUCCESS).map(BuildRecord::getId).collect(Collectors.toSet());
    }

    private void close(org.jboss.pnc.model.ProductMilestone milestone) {
        milestone.setEndDate(new Date());
        this.milestoneRepository.save((GenericEntity)milestone);
        this.removeCurrentFlagFromMilestone(milestone);
    }

    private void removeCurrentFlagFromMilestone(org.jboss.pnc.model.ProductMilestone milestone) {
        ProductVersion productVersion = milestone.getProductVersion();
        if (productVersion.getCurrentProductMilestone() != null && productVersion.getCurrentProductMilestone().getId().equals(milestone.getId())) {
            productVersion.setCurrentProductMilestone(null);
        }
    }

    private void doCloseMilestone(org.jboss.pnc.model.ProductMilestone milestone, Set<Base32LongID> buildIds) {
        String tagPrefix = (String)milestone.getProductVersion().getAttributes().get("BREW_TAG_PREFIX");
        if (tagPrefix == null) {
            throw new InvalidEntityException("Product version for this milestone is missing attribute BREW_TAG_PREFIX");
        }
        BuildPushParameters buildPushParameters = BuildPushParameters.builder().tagPrefix(tagPrefix).reimport(false).build();
        String milestoneId = (String)this.mapper.getIdMapper().toDto((Object)milestone.getId());
        for (Base32LongID buildId : buildIds) {
            this.brewPusher.pushBuild(buildId, buildPushParameters, milestoneId);
        }
    }

    @Override
    public void observeEvent(@ObservesAsync OperationChangedEvent event) {
        if (event.getOperationClass() != BuildPushOperation.class) {
            return;
        }
        if (event.getStatus() != ProgressStatus.FINISHED || event.getPreviousStatus() == ProgressStatus.FINISHED) {
            return;
        }
        BuildPushOperation operation = (BuildPushOperation)this.buildPushOperationRepository.queryById((Serializable)event.getId());
        String milestoneId = (String)operation.getOperationParameters().get("milestoneClose");
        if (milestoneId == null) {
            return;
        }
        log.debug("Observed build push operation status (with linked milestone {}) changed event {}.", (Object)milestoneId, (Object)event);
        this.onBuildPushOperationFinished(milestoneId, operation);
    }

    private void onBuildPushOperationFinished(String milestoneId, BuildPushOperation operation) {
        if (operation.getResult() != OperationResult.SUCCESSFUL) {
            return;
        }
        Integer id = (Integer)this.mapper.getIdMapper().toEntity((Object)milestoneId);
        org.jboss.pnc.model.ProductMilestone milestone = (org.jboss.pnc.model.ProductMilestone)this.repository.queryById((Serializable)id);
        if (milestone == null) {
            throw new IllegalStateException("Product milestone with id " + id + " not found.");
        }
        Set<Base32LongID> buildIds = ProductMilestoneProviderImpl.buildsToPush(milestone);
        List runningOperations = this.runningBuildPushes(buildIds).stream().filter(o -> milestoneId.equals(o.getOperationParameters().get("milestoneClose"))).collect(Collectors.toList());
        if (!runningOperations.isEmpty()) {
            log.debug("Wanting to close milestone {}, but waiting for {} other build pushes to finish.", (Object)milestoneId, (Object)runningOperations.size());
            return;
        }
        Set successfullyPushed = this.buildPushOperationRepository.queryWithPredicates(new Predicate[]{BuildPushPredicates.withBuilds(buildIds), OperationPredicates.withResult((OperationResult)OperationResult.SUCCESSFUL)}).stream().map(o -> o.getBuild().getId()).collect(Collectors.toSet());
        if (successfullyPushed.containsAll(buildIds)) {
            log.debug("Last build push {} finished, closing milestone.", (Object)operation.getId());
            this.close(milestone);
        }
    }

    public List<BuildPushOperation> runningBuildPushes(Set<Base32LongID> buildIds) {
        return this.buildPushOperationRepository.queryWithPredicates(new Predicate[]{BuildPushPredicates.withBuilds(buildIds), OperationPredicates.inProgress()});
    }

    @Override
    public void cancelMilestoneCloseProcess(String id) throws RepositoryViolationException, EmptyEntityException {
        org.jboss.pnc.model.ProductMilestone milestoneInDb = (org.jboss.pnc.model.ProductMilestone)this.milestoneRepository.queryById((Serializable)Integer.valueOf(id));
        if (milestoneInDb.getEndDate() != null) {
            userLog.info("Milestone is already closed.");
            throw new RepositoryViolationException("Milestone is already closed!");
        }
        this.brewPusher.cancelPushOfMilestone(id);
    }

    @Override
    public Page<ProductMilestone> getProductMilestonesForProductVersion(int pageIndex, int pageSize, String sortingRsql, String query, String productVersionId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, ProductMilestonePredicates.withProductVersionId((Integer)Integer.valueOf(productVersionId)));
    }

    @Override
    public Page<MilestoneInfo> getMilestonesOfArtifact(String artifactId, int pageIndex, int pageSize, String sortingRsql, String queryRsql) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        Optional<Integer> builtIn = this.getMilestoneIdByBuildRecord(cb, artifactId);
        List<Integer> dependencyOf = this.getDependentMilestoneIds(cb, artifactId);
        HashSet<Integer> milestoneIds = new HashSet<Integer>(dependencyOf);
        builtIn.ifPresent(milestoneIds::add);
        milestoneIds.remove(null);
        if (milestoneIds.isEmpty()) {
            return new Page();
        }
        Predicate<org.jboss.pnc.model.ProductMilestone> rsqlPredicate = this.rsqlPredicateProducer.getCriteriaPredicate(this.milestoneInfoRSQLMapper, queryRsql);
        SortInfo<org.jboss.pnc.model.ProductMilestone> sortInfo = this.rsqlPredicateProducer.getSortInfo(this.milestoneInfoRSQLMapper, sortingRsql);
        CriteriaQuery<Tuple> query = this.milestoneInfoQuery(cb, milestoneIds, rsqlPredicate, sortInfo);
        int offset = pageIndex * pageSize;
        List milestones = this.em.createQuery(query).setMaxResults(pageSize).setFirstResult(offset).getResultList().stream().map(m -> this.mapTupleToMilestoneInfo((Tuple)m, builtIn)).collect(Collectors.toList());
        int totalHits = this.getMatchingArtifactMilestonesCount(milestoneIds, rsqlPredicate);
        return new Page(pageIndex, pageSize, totalHits, milestones);
    }

    @Override
    public ValidationResponse validateVersion(String productVersionId, String version) {
        boolean matches = Pattern.matches("^[0-9]+\\.[0-9]+(\\.\\w[\\w-]*)+$", version);
        ValidationResponse.Builder builder = ValidationResponse.builder().isValid(Boolean.valueOf(matches));
        if (!matches) {
            return builder.errorType(ValidationErrorType.FORMAT).hints(Collections.singletonList("Allowed format consists of 2 or 3 numeric components (separated by a dot) followed by a string qualifier starting with a character, eg. 3.0.0.GA, 1.0.11.CR2.ER1, 3.0.CR2")).build();
        }
        org.jboss.pnc.model.ProductMilestone duplicate = (org.jboss.pnc.model.ProductMilestone)this.milestoneRepository.queryByPredicates(new Predicate[]{ProductMilestonePredicates.withProductVersionIdAndVersion((Integer)Integer.parseInt(productVersionId), (String)version)});
        if (duplicate != null) {
            return builder.isValid(Boolean.valueOf(false)).errorType(ValidationErrorType.DUPLICATION).hints(Collections.singletonList("Product Milestone version already exists")).build();
        }
        return builder.isValid(Boolean.valueOf(matches)).build();
    }

    @Override
    public ProductMilestoneStatistics getStatistics(String id) {
        Integer milestoneId = (Integer)this.mapper.getIdMapper().toEntity((Object)id);
        return ProductMilestoneStatistics.builder().artifactsInMilestone(this.milestoneRepository.countBuiltArtifactsInMilestone(milestoneId)).deliveredArtifactsSource(ProductMilestoneDeliveredArtifactsStatistics.builder().thisMilestone(this.deliverableArtifactRepository.countMilestoneDeliveredArtifactsBuiltInThisMilestone(milestoneId)).otherMilestones(this.deliverableArtifactRepository.countMilestoneDeliveredArtifactsBuiltInOtherMilestones(milestoneId)).otherProducts(this.deliverableArtifactRepository.countMilestoneDeliveredArtifactsBuiltByOtherProducts(milestoneId)).noMilestone(this.deliverableArtifactRepository.countMilestoneDeliveredArtifactsBuiltInNoMilestone(milestoneId)).noBuild(this.deliverableArtifactRepository.countMilestoneDeliveredArtifactsNotBuilt(milestoneId)).build()).artifactQuality(this.deliverableArtifactRepository.getArtifactQualitiesCounts(milestoneId)).repositoryType(this.deliverableArtifactRepository.getRepositoryTypesCounts(milestoneId)).build();
    }

    @Override
    public List<DeliveredArtifactInMilestones> getArtifactsDeliveredInMilestonesGroupedByPrefix(List<String> milestoneIds) {
        List<Integer> milestoneIntIds = milestoneIds.stream().map(Integer::valueOf).collect(Collectors.toList());
        List artifactsDeliveredInMilestonesTuples = this.milestoneRepository.getArtifactsDeliveredInMilestones(milestoneIntIds);
        return this.parseDeliveredArtifactsInMilestoneTuples(artifactsDeliveredInMilestonesTuples, milestoneIntIds);
    }

    private List<DeliveredArtifactInMilestones> parseDeliveredArtifactsInMilestoneTuples(List<Tuple> tuples, List<Integer> milestoneId) {
        Map<String, Map<String, List>> artifactsDeliveredInMilestonesMap = tuples.stream().collect(Collectors.groupingBy(this::parseArtifactNameFromTuple, Collectors.flatMapping(tuple -> this.parseMilestonePresencesFromTuple((Tuple)tuple, milestoneId), Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> ListUtils.union((List)existing, (List)replacement)))));
        int ARTIFACT_PREFIX_SHARED_IN_MIN_MILESTONES_COUNT = 2;
        return artifactsDeliveredInMilestonesMap.entrySet().stream().filter(entry -> ((Map)entry.getValue()).size() >= 2).map(entry -> DeliveredArtifactInMilestones.builder().artifactIdentifierPrefix((String)entry.getKey()).productMilestoneArtifacts((Map)entry.getValue()).build()).collect(Collectors.toList());
    }

    private String parseArtifactNameFromTuple(Tuple tuple) {
        String deployPath = (String)tuple.get(1, String.class);
        RepositoryType repositoryType = (RepositoryType)tuple.get(2, RepositoryType.class);
        return this.parseArtifactNameFromDeployPath(deployPath, repositoryType);
    }

    private String parseArtifactNameFromDeployPath(String deployPath, RepositoryType repositoryType) {
        switch (repositoryType) {
            case MAVEN: {
                SimpleArtifactRef mavenCoordinates = ArtifactCoordinatesUtils.parseMavenCoordinates((String)deployPath);
                if (mavenCoordinates == null) break;
                return mavenCoordinates.getGroupId() + ":" + mavenCoordinates.getArtifactId();
            }
            case NPM: {
                NpmPackageRef npmCoordinates = ArtifactCoordinatesUtils.parseNPMCoordinates((String)deployPath);
                if (npmCoordinates == null) break;
                return npmCoordinates.getName();
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository type: " + repositoryType);
            }
        }
        return "";
    }

    private Stream<Map.Entry<String, List<ParsedArtifact>>> parseMilestonePresencesFromTuple(Tuple tuple, List<Integer> milestoneIds) {
        String id = ((Integer)tuple.get(0, Integer.class)).toString();
        String deployPath = (String)tuple.get(1, String.class);
        RepositoryType repositoryType = (RepositoryType)tuple.get(2, RepositoryType.class);
        String version = this.parseArtifactVersionFromDeployPath(deployPath, repositoryType);
        String type = this.parseArtifactTypeFromDeployPath(deployPath, repositoryType);
        String classifier = this.parseArtifactClassifierFromDeployPath(deployPath, repositoryType);
        ParsedArtifact parsedArtifact = ParsedArtifact.builder().id(id).artifactVersion(version).type(type).classifier(classifier).build();
        return milestoneIds.stream().filter(milestoneId -> {
            Boolean milestonePresence = (Boolean)tuple.get(3 + milestoneIds.indexOf(milestoneId), Boolean.class);
            return milestonePresence;
        }).map(milestoneId -> Map.entry(milestoneId.toString(), List.of(parsedArtifact)));
    }

    private String parseArtifactVersionFromDeployPath(String deployPath, RepositoryType repositoryType) {
        switch (repositoryType) {
            case MAVEN: {
                SimpleArtifactRef mavenCoordinates = ArtifactCoordinatesUtils.parseMavenCoordinates((String)deployPath);
                if (mavenCoordinates == null) break;
                return mavenCoordinates.getVersionString();
            }
            case NPM: {
                NpmPackageRef npmCoordinates = ArtifactCoordinatesUtils.parseNPMCoordinates((String)deployPath);
                if (npmCoordinates == null) break;
                return npmCoordinates.getVersionString();
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository type: " + repositoryType);
            }
        }
        return "";
    }

    private String parseArtifactTypeFromDeployPath(String deployPath, RepositoryType repositoryType) {
        switch (repositoryType) {
            case MAVEN: {
                SimpleArtifactRef mavenCoordinates = ArtifactCoordinatesUtils.parseMavenCoordinates((String)deployPath);
                if (mavenCoordinates == null) break;
                return mavenCoordinates.getType();
            }
            case NPM: {
                return "tgz";
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository type: " + repositoryType);
            }
        }
        return "";
    }

    private String parseArtifactClassifierFromDeployPath(String deployPath, RepositoryType repositoryType) {
        switch (repositoryType) {
            case MAVEN: {
                SimpleArtifactRef mavenCoordinates = ArtifactCoordinatesUtils.parseMavenCoordinates((String)deployPath);
                if (mavenCoordinates == null) break;
                return mavenCoordinates.getClassifier();
            }
            case NPM: {
                return null;
            }
            default: {
                throw new IllegalArgumentException("Unsupported repository type: " + repositoryType);
            }
        }
        return null;
    }

    @Override
    public Graph<ProductMilestone> getMilestonesSharingDeliveredArtifactsGraph(String milestoneId, Integer depthLimit) {
        org.jboss.util.graph.Graph<ProductMilestone> milestoneInterconnectionGraph = this.createMilestoneInterconnectionGraph(milestoneId, depthLimit);
        return GraphDtoBuilder.from(milestoneInterconnectionGraph, ProductMilestone.class, vertex -> (ProductMilestone)vertex.getData());
    }

    private org.jboss.util.graph.Graph<ProductMilestone> createMilestoneInterconnectionGraph(String milestoneId, Integer depthLimit) {
        org.jboss.util.graph.Graph graph = new org.jboss.util.graph.Graph();
        UndirectedGraphBuilder graphBuilder = new UndirectedGraphBuilder(id -> (ProductMilestone)this.getSpecific((String)id), node -> {
            List tuples = this.milestoneRepository.getMilestonesSharingDeliveredArtifacts(Integer.valueOf(node.getId()));
            return this.parseVertexNeighborsFromTuples(tuples);
        });
        graphBuilder.buildGraph(graph, (Object)milestoneId, depthLimit.intValue());
        return graph;
    }

    private List<VertexNeighbor<String>> parseVertexNeighborsFromTuples(List<Tuple> tuples) {
        return tuples.stream().map(tuple -> VertexNeighbor.builder().neighborId((Object)((Integer)tuple.get(0, Integer.class)).toString()).cost((Integer)tuple.get(1, Integer.class)).build()).collect(Collectors.toList());
    }

    private int getMatchingArtifactMilestonesCount(Set<Integer> milestoneIds, Predicate<org.jboss.pnc.model.ProductMilestone> rsqlPredicate) {
        CriteriaBuilder cb = this.em.getCriteriaBuilder();
        CriteriaQuery query = cb.createQuery(Long.class);
        Root milestone = query.from(org.jboss.pnc.model.ProductMilestone.class);
        query.select((Selection)cb.count((Expression)milestone.get(ProductMilestone_.id)));
        query.where((Expression)cb.and((Expression)milestone.get(ProductMilestone_.id).in(milestoneIds), (Expression)rsqlPredicate.apply(milestone, query, cb)));
        return ((Long)this.em.createQuery(query).getSingleResult()).intValue();
    }

    private CriteriaQuery<Tuple> milestoneInfoQuery(CriteriaBuilder cb, Set<Integer> milestoneIds, Predicate<org.jboss.pnc.model.ProductMilestone> rsqlPredicate, SortInfo<org.jboss.pnc.model.ProductMilestone> sortInfo) {
        CriteriaQuery query = cb.createTupleQuery();
        Root milestone = query.from(org.jboss.pnc.model.ProductMilestone.class);
        Join version = milestone.join(ProductMilestone_.productVersion);
        Join release = milestone.join(ProductMilestone_.productRelease, JoinType.LEFT);
        Join product = version.join(ProductVersion_.product);
        List orders = SortInfoConverter.toOrders(sortInfo, (Root)milestone, (CriteriaBuilder)cb);
        query.multiselect(new Selection[]{product.get(Product_.id), product.get(Product_.name), version.get(ProductVersion_.id), version.get(ProductVersion_.version), milestone.get(ProductMilestone_.id), milestone.get(ProductMilestone_.version), milestone.get(ProductMilestone_.endDate), release.get(ProductRelease_.id), release.get(ProductRelease_.version), release.get(ProductRelease_.releaseDate)});
        query.where((Expression)cb.and((Expression)milestone.get(ProductMilestone_.id).in(milestoneIds), (Expression)rsqlPredicate.apply(milestone, query, cb)));
        query.orderBy(orders);
        return query;
    }

    private MilestoneInfo mapTupleToMilestoneInfo(Tuple tuple, Optional<Integer> buildIn) {
        Integer milestoneId = (Integer)tuple.get(4);
        return MilestoneInfo.builder().productId(tuple.get(0).toString()).productName(tuple.get(1).toString()).productVersionId(tuple.get(2).toString()).productVersionVersion(tuple.get(3).toString()).milestoneId(milestoneId.toString()).milestoneVersion(tuple.get(5).toString()).milestoneEndDate(ProductMilestoneProviderImpl.toInstant(tuple.get(6))).releaseId(tuple.get(7) == null ? null : tuple.get(7).toString()).releaseVersion(tuple.get(8) == null ? null : tuple.get(8).toString()).releaseReleaseDate(ProductMilestoneProviderImpl.toInstant(tuple.get(9))).built(buildIn.map(milestoneId::equals).orElse(false).booleanValue()).build();
    }

    private static Instant toInstant(Object object) {
        if (object == null) {
            return null;
        }
        return ((Date)object).toInstant();
    }

    private Optional<Integer> getMilestoneIdByBuildRecord(CriteriaBuilder cb, String id) {
        Optional<Integer> singleResult;
        CriteriaQuery buildQuery = cb.createQuery(Integer.class);
        Root artifact = buildQuery.from(Artifact.class);
        Join buildRecords = artifact.join(Artifact_.buildRecord);
        buildQuery.select((Selection)buildRecords.get(BuildRecord_.productMilestone).get(ProductMilestone_.id));
        buildQuery.where((Expression)cb.equal((Expression)artifact.get(Artifact_.id), (Object)Integer.valueOf(id)));
        buildQuery.distinct(true);
        try {
            singleResult = Optional.ofNullable((Integer)this.em.createQuery(buildQuery).getSingleResult());
        }
        catch (NoResultException e) {
            return Optional.empty();
        }
        return singleResult;
    }

    private List<Integer> getDependentMilestoneIds(CriteriaBuilder cb, String id) {
        CriteriaQuery buildQuery = cb.createQuery(Integer.class);
        Root artifact = buildQuery.from(Artifact.class);
        SetJoin build = artifact.join(Artifact_.dependantBuildRecords);
        buildQuery.where((Expression)cb.equal((Expression)artifact.get(Artifact_.id), (Object)Integer.valueOf(id)));
        buildQuery.select((Selection)build.get(BuildRecord_.productMilestone).get(ProductMilestone_.id));
        buildQuery.distinct(true);
        return this.em.createQuery(buildQuery).getResultList();
    }
}

