/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class MergeIterator<T>
implements Iterator<T> {
    private final Iterator<T> itA;
    private final Iterator<T> itB;
    private final Comparator<T> comparator;
    private T objectA;
    private T objectB;

    public MergeIterator(Iterator<T> a, Iterator<T> b, Comparator<T> comparator) {
        this.itA = a;
        this.itB = b;
        this.comparator = comparator;
        if (this.itA.hasNext()) {
            this.objectA = this.itA.next();
        }
        if (this.itB.hasNext()) {
            this.objectB = this.itB.next();
        }
    }

    @Override
    public boolean hasNext() {
        return this.objectA != null || this.objectB != null || this.itA.hasNext() || this.itB.hasNext();
    }

    @Override
    public T next() {
        T object;
        if (this.objectA != null && this.objectB != null) {
            if (this.comparator.compare(this.objectA, this.objectB) < 0) {
                object = this.objectA;
                this.objectA = this.provideNext(this.itA);
            } else {
                object = this.objectB;
                this.objectB = this.provideNext(this.itB);
            }
        } else if (this.objectA != null) {
            object = this.objectA;
            this.objectA = this.provideNext(this.itA);
        } else if (this.objectB != null) {
            object = this.objectB;
            this.objectB = this.provideNext(this.itB);
        } else {
            throw new NoSuchElementException();
        }
        return object;
    }

    private T provideNext(Iterator<T> it) {
        if (it.hasNext()) {
            return it.next();
        }
        return null;
    }
}

