/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.HashSet;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.facade.providers.OperationProviderImpl;
import org.jboss.pnc.facade.providers.api.BuildPushOperationProvider;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.BuildPushOperationMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildPushOperation;
import org.jboss.pnc.spi.coordinator.BuildCoordinator;
import org.jboss.pnc.spi.datastore.predicates.BuildPushPredicates;
import org.jboss.pnc.spi.datastore.predicates.BuildRecordPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildPushOperationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.exception.MissingDataException;
import org.jboss.pnc.spi.exception.RemoteRequestException;

@PermitAll
@Stateless
public class BuildPushOperationProviderImpl
extends OperationProviderImpl<BuildPushOperation, org.jboss.pnc.dto.BuildPushOperation>
implements BuildPushOperationProvider {
    @Inject
    BuildRecordRepository buildRecordRepository;
    @Inject
    ProductMilestoneRepository productMilestoneRepository;
    @Inject
    BuildCoordinator buildCoordinator;

    @Inject
    public BuildPushOperationProviderImpl(BuildPushOperationRepository repository, BuildPushOperationMapper mapper) {
        super(repository, mapper, BuildPushOperation.class);
    }

    @Override
    public Page<org.jboss.pnc.dto.BuildPushOperation> getOperationsForBuild(int pageIndex, int pageSize, String sortingRsql, String query, String buildId) {
        this.validateBuildExists(buildId);
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildPushPredicates.withBuild((Base32LongID)id));
    }

    private void validateBuildExists(String buildId) {
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        if (this.buildRecordRepository.queryById((Serializable)id) == null) {
            try {
                this.buildCoordinator.getSubmittedBuildTask(buildId).orElseThrow(() -> new EmptyEntityException("Build with id " + buildId + " not found"));
            }
            catch (MissingDataException | RemoteRequestException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public Page<org.jboss.pnc.dto.BuildPushOperation> getOperationsForMilestone(int pageIndex, int pageSize, String sortingRsql, String query, boolean latest, String milestoneId) {
        Integer id = ProductMilestoneMapper.idMapper.toEntity(milestoneId);
        if (this.productMilestoneRepository.queryById((Serializable)id) == null) {
            throw new EmptyEntityException("Milestone with id " + milestoneId + " not found");
        }
        HashSet buildIds = new HashSet(this.buildRecordRepository.queryIdsWithPredicates(new Predicate[]{BuildRecordPredicates.withStatus((BuildStatus)BuildStatus.SUCCESS), BuildRecordPredicates.withPerformedInMilestone((Integer)id)}));
        Predicate predicate = latest ? BuildPushPredicates.latestWithBuilds(buildIds) : BuildPushPredicates.withBuilds(buildIds);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, predicate);
    }
}

