/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.dto.DeliverableAnalyzerOperation;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.facade.providers.OperationProviderImpl;
import org.jboss.pnc.facade.providers.api.DeliverableAnalyzerOperationProvider;
import org.jboss.pnc.facade.validation.ValidationBuilder;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerOperationMapper;
import org.jboss.pnc.mapper.api.ProductMilestoneMapper;
import org.jboss.pnc.spi.datastore.predicates.OperationPredicates;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerOperationRepository;
import org.jboss.pnc.spi.datastore.repositories.ProductMilestoneRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class DeliverableAnalyzerOperationProviderImpl
extends OperationProviderImpl<org.jboss.pnc.model.DeliverableAnalyzerOperation, DeliverableAnalyzerOperation>
implements DeliverableAnalyzerOperationProvider {
    private final Logger logger = LoggerFactory.getLogger(DeliverableAnalyzerOperationProviderImpl.class);
    private ProductMilestoneRepository productMilestoneRepository;
    private ProductMilestoneMapper milestoneMapper;

    @Inject
    public DeliverableAnalyzerOperationProviderImpl(ProductMilestoneRepository productMilestoneRepository, DeliverableAnalyzerOperationRepository repository, DeliverableAnalyzerOperationMapper mapper, ProductMilestoneMapper milestoneMapper) {
        super(repository, mapper, org.jboss.pnc.model.DeliverableAnalyzerOperation.class);
        this.productMilestoneRepository = productMilestoneRepository;
        this.milestoneMapper = milestoneMapper;
    }

    @Override
    public Page<DeliverableAnalyzerOperation> getAllDeliverableAnalyzerOperations(int pageIndex, int pageSize, String sortingRsql, String query) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, new Predicate[0]);
    }

    @Override
    public Page<DeliverableAnalyzerOperation> getAllDeliverableAnalyzerOperationsForMilestone(int pageIndex, int pageSize, String sortingRsql, String query, String milestoneId) {
        ValidationBuilder.validateObject(null).validateAgainstRepository(this.productMilestoneRepository, Integer.valueOf(milestoneId), true);
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, OperationPredicates.withMilestoneId((Integer)Integer.valueOf(milestoneId)));
    }
}

