/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.api.deliverablesanalyzer.dto.LicenseInfo;
import org.jboss.pnc.api.enums.DeliverableAnalyzerReportLabel;
import org.jboss.pnc.common.util.StringUtils;
import org.jboss.pnc.dto.DeliverableAnalyzerLabelEntry;
import org.jboss.pnc.dto.requests.labels.DeliverableAnalyzerReportLabelRequest;
import org.jboss.pnc.dto.response.AnalyzedArtifact;
import org.jboss.pnc.dto.response.AnalyzedDistribution;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.DeliverableAnalyzerReportProvider;
import org.jboss.pnc.facade.util.labels.DeliverableAnalyzerLabelSaver;
import org.jboss.pnc.facade.util.labels.DeliverableAnalyzerReportLabelModifier;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.mapper.api.ArtifactMapper;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerLabelEntryMapper;
import org.jboss.pnc.mapper.api.DeliverableAnalyzerReportMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.DeliverableAnalyzerReport;
import org.jboss.pnc.model.DeliverableArtifact;
import org.jboss.pnc.spi.datastore.predicates.DeliverableAnalyzerLabelEntryPredicates;
import org.jboss.pnc.spi.datastore.predicates.DeliverableArtifactPredicates;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerLabelEntryRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerReportRepository;
import org.jboss.pnc.spi.datastore.repositories.DeliverableArtifactRepository;
import org.jboss.pnc.spi.datastore.repositories.api.PageInfo;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.jboss.pnc.spi.datastore.repositories.api.SortInfo;

@PermitAll
@Stateless
public class DeliverableAnalyzerReportProviderImpl
extends AbstractProvider<Base32LongID, DeliverableAnalyzerReport, org.jboss.pnc.dto.DeliverableAnalyzerReport, org.jboss.pnc.dto.DeliverableAnalyzerReport>
implements DeliverableAnalyzerReportProvider {
    private final DeliverableAnalyzerReportRepository deliverableAnalyzerReportRepository;
    private final DeliverableArtifactRepository deliverableArtifactRepository;
    private final DeliverableAnalyzerLabelEntryRepository deliverableAnalyzerLabelEntryRepository;
    private final DeliverableAnalyzerLabelEntryMapper deliverableAnalyzerLabelEntryMapper;
    private final ArtifactMapper artifactMapper;
    private final DeliverableAnalyzerReportLabelModifier labelModifier;
    private final DeliverableAnalyzerLabelSaver labelSaver;

    @Inject
    public DeliverableAnalyzerReportProviderImpl(DeliverableAnalyzerReportRepository repository, DeliverableArtifactRepository deliverableArtifactRepository, DeliverableAnalyzerLabelEntryRepository deliverableAnalyzerLabelEntryRepository, DeliverableAnalyzerReportMapper mapper, DeliverableAnalyzerLabelEntryMapper deliverableAnalyzerLabelEntryMapper, ArtifactMapper artifactMapper, DeliverableAnalyzerReportLabelModifier labelModifier, DeliverableAnalyzerLabelSaver labelSaver) {
        super(repository, mapper, DeliverableAnalyzerReport.class);
        this.deliverableAnalyzerReportRepository = repository;
        this.deliverableArtifactRepository = deliverableArtifactRepository;
        this.deliverableAnalyzerLabelEntryRepository = deliverableAnalyzerLabelEntryRepository;
        this.deliverableAnalyzerLabelEntryMapper = deliverableAnalyzerLabelEntryMapper;
        this.artifactMapper = artifactMapper;
        this.labelModifier = labelModifier;
        this.labelSaver = labelSaver;
    }

    @Override
    public Page<AnalyzedArtifact> getAnalyzedArtifacts(int pageIndex, int pageSize, String query, String sort, String id) {
        Base32LongID entityId = (Base32LongID)this.parseId(id);
        Predicate<DeliverableArtifact> rsqlPredicate = this.rsqlPredicateProducer.getCriteriaPredicate(DeliverableArtifact.class, query);
        PageInfo pageInfo = this.pageInfoProducer.getPageInfo(pageIndex, pageSize);
        SortInfo<DeliverableArtifact> sortInfo = this.rsqlPredicateProducer.getSortInfo(DeliverableArtifact.class, sort);
        List analyzedArtifacts = this.deliverableArtifactRepository.queryWithPredicates(pageInfo, sortInfo, new Predicate[]{rsqlPredicate, DeliverableArtifactPredicates.withReportId((Base32LongID)entityId)}).stream().map(this::deliverableArtifactToDto).collect(Collectors.toList());
        return new Page(pageIndex, pageSize, this.deliverableArtifactRepository.count(new Predicate[]{rsqlPredicate, DeliverableArtifactPredicates.withReportId((Base32LongID)entityId)}), analyzedArtifacts);
    }

    @Override
    public Page<DeliverableAnalyzerLabelEntry> getLabelHistory(String id, int pageIndex, int pageSize, String sort, String query) {
        Base32LongID reportId = (Base32LongID)this.parseId(id);
        Predicate<org.jboss.pnc.model.DeliverableAnalyzerLabelEntry> rsqlPredicate = this.rsqlPredicateProducer.getCriteriaPredicate(org.jboss.pnc.model.DeliverableAnalyzerLabelEntry.class, query);
        PageInfo pageInfo = this.pageInfoProducer.getPageInfo(pageIndex, pageSize);
        SortInfo<org.jboss.pnc.model.DeliverableAnalyzerLabelEntry> sortInfo = this.rsqlPredicateProducer.getSortInfo(org.jboss.pnc.model.DeliverableAnalyzerLabelEntry.class, sort);
        List labelHistory = this.deliverableAnalyzerLabelEntryRepository.queryWithPredicates(pageInfo, sortInfo, new Predicate[]{rsqlPredicate, DeliverableAnalyzerLabelEntryPredicates.withReportId((Base32LongID)reportId)}).stream().map(arg_0 -> ((DeliverableAnalyzerLabelEntryMapper)this.deliverableAnalyzerLabelEntryMapper).toDto(arg_0)).collect(Collectors.toList());
        int totalHits = this.deliverableAnalyzerLabelEntryRepository.count(new Predicate[]{rsqlPredicate, DeliverableAnalyzerLabelEntryPredicates.withReportId((Base32LongID)reportId)});
        return new Page(pageIndex, pageSize, totalHits, labelHistory);
    }

    @Override
    public void addLabel(String id, DeliverableAnalyzerReportLabelRequest request) {
        Base32LongID reportId = (Base32LongID)this.parseId(id);
        DeliverableAnalyzerReport report = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.queryById((Serializable)reportId);
        if (report == null) {
            throw new EmptyEntityException("Deliverable analyzer report with id: " + id + " does not exist!");
        }
        this.labelSaver.init(report, request.getReason());
        this.labelModifier.validateAndAddLabel((DeliverableAnalyzerReportLabel)request.getLabel(), report.getLabels());
    }

    @Override
    public void removeLabel(String id, DeliverableAnalyzerReportLabelRequest request) {
        Base32LongID reportId = (Base32LongID)this.parseId(id);
        DeliverableAnalyzerReport report = (DeliverableAnalyzerReport)this.deliverableAnalyzerReportRepository.queryById((Serializable)reportId);
        if (report == null) {
            throw new EmptyEntityException("Deliverable analyzer report with id: " + id + " does not exist!");
        }
        this.labelSaver.init(report, request.getReason());
        this.labelModifier.validateAndRemoveLabel((DeliverableAnalyzerReportLabel)request.getLabel(), report.getLabels());
    }

    private AnalyzedArtifact deliverableArtifactToDto(DeliverableArtifact deliverableArtifact) {
        AnalyzedDistribution distribution = deliverableArtifact.getDistribution() != null ? AnalyzedDistribution.builder().distributionUrl(deliverableArtifact.getDistribution().getDistributionUrl()).creationTime(deliverableArtifact.getDistribution().getCreationTime()).md5(deliverableArtifact.getDistribution().getMd5()).sha1(deliverableArtifact.getDistribution().getSha1()).sha256(deliverableArtifact.getDistribution().getSha256()).build() : null;
        Set licenses = Optional.ofNullable(deliverableArtifact.getLicenses()).orElse(Collections.emptySet()).stream().map(license -> LicenseInfo.builder().comments(license.getComments()).distribution(license.getDistribution()).name(license.getName()).spdxLicenseId(license.getSpdxLicenseId()).url(license.getUrl()).sourceUrl(license.getSourceUrl()).build()).collect(Collectors.toSet());
        return AnalyzedArtifact.builder().builtFromSource(deliverableArtifact.isBuiltFromSource()).brewId(deliverableArtifact.getBrewBuildId()).artifact(this.artifactMapper.toDTO(deliverableArtifact.getArtifact())).archiveFilenames(StringUtils.splitString((String)deliverableArtifact.getArchiveFilenames())).archiveUnmatchedFilenames(StringUtils.splitString((String)deliverableArtifact.getArchiveUnmatchedFilenames())).distribution(distribution).licenses(licenses).build();
    }
}

