/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.annotation.security.RolesAllowed;
import javax.ejb.Stateless;
import javax.inject.Inject;
import org.jboss.pnc.dto.Environment;
import org.jboss.pnc.facade.providers.AbstractProvider;
import org.jboss.pnc.facade.providers.api.EnvironmentProvider;
import org.jboss.pnc.facade.validation.ConflictedEntryException;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.InvalidEntityException;
import org.jboss.pnc.mapper.api.EnvironmentMapper;
import org.jboss.pnc.model.BuildEnvironment;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.predicates.EnvironmentPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildEnvironmentRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;

@PermitAll
@Stateless
public class EnvironmentProviderImpl
extends AbstractProvider<Integer, BuildEnvironment, Environment, Environment>
implements EnvironmentProvider {
    @Inject
    public EnvironmentProviderImpl(BuildEnvironmentRepository repository, EnvironmentMapper mapper) {
        super(repository, mapper, BuildEnvironment.class);
    }

    @Override
    @RolesAllowed(value={"pnc-app-environment-user", "pnc-users-admin"})
    public Environment store(Environment restEntity) throws DTOValidationException {
        Environment storedEntity = super.store(restEntity);
        this.deprecateActiveEnvironmentsWithSameName(storedEntity);
        return storedEntity;
    }

    @Override
    public void delete(String id) {
        throw new UnsupportedOperationException("Deleting Environments is prohibited");
    }

    @Override
    protected void validateBeforeSaving(Environment restEntity) {
        super.validateBeforeSaving(restEntity);
        if (restEntity.isDeprecated()) {
            throw new InvalidEntityException("New environment cannot be created as deprecated.", "deprecated");
        }
        if (restEntity.getAttributes() != null && restEntity.getAttributes().containsKey("DEPRECATION_REPLACEMENT")) {
            throw new InvalidEntityException("New environment cannot contain attribute 'DEPRECATION_REPLACEMENT'.", "attributes");
        }
    }

    private void deprecateActiveEnvironmentsWithSameName(Environment restEntity) throws ConflictedEntryException {
        List buildEnvironments = this.repository.queryWithPredicates(new Predicate[]{EnvironmentPredicates.withEnvironmentNameAndActive((String)restEntity.getName())});
        for (BuildEnvironment env : buildEnvironments) {
            if (env.getId().equals(this.mapper.getIdMapper().toEntity((Object)restEntity.getId()))) continue;
            env.setDeprecated(true);
            env.putAttribute("DEPRECATION_REPLACEMENT", restEntity.getId());
            this.shortenTransitivePath(env.getId().toString(), restEntity.getId());
        }
    }

    @Override
    @RolesAllowed(value={"pnc-app-environment-user", "pnc-users-admin"})
    public Environment deprecateEnvironment(String id, String replacementId) {
        BuildEnvironment deprecatedEnvironment = (BuildEnvironment)this.repository.queryById((Serializable)((Integer)this.mapper.getIdMapper().toEntity((Object)id)));
        if (deprecatedEnvironment == null) {
            throw new EmptyEntityException("Environment with id " + id + " doesn't exist");
        }
        BuildEnvironment replacementEnvironment = (BuildEnvironment)this.repository.queryById((Serializable)((Integer)this.mapper.getIdMapper().toEntity((Object)replacementId)));
        if (replacementEnvironment == null) {
            throw new EmptyEntityException("Replacement environment with id " + replacementId + " doesn't exist");
        }
        if (replacementEnvironment.isDeprecated()) {
            throw new InvalidEntityException("Replacement environment with id " + replacementId + " is itself deprecated.");
        }
        deprecatedEnvironment.setDeprecated(true);
        deprecatedEnvironment.putAttribute("DEPRECATION_REPLACEMENT", replacementId);
        this.shortenTransitivePath(id, replacementId);
        return (Environment)this.mapper.toDTO((GenericEntity)deprecatedEnvironment);
    }

    private void shortenTransitivePath(String deprecatedId, String replacementId) {
        for (BuildEnvironment environment : this.repository.queryWithPredicates(new Predicate[]{EnvironmentPredicates.replacedBy((String)deprecatedId)})) {
            environment.putAttribute("DEPRECATION_REPLACEMENT", replacementId);
        }
    }
}

