/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.providers;

import java.io.Serializable;
import java.util.List;
import javax.annotation.security.PermitAll;
import javax.ejb.Stateless;
import javax.inject.Inject;
import lombok.Generated;
import org.jboss.pnc.dto.GroupConfiguration;
import org.jboss.pnc.dto.GroupConfigurationRef;
import org.jboss.pnc.dto.response.Page;
import org.jboss.pnc.dto.validation.groups.WhenCreatingNew;
import org.jboss.pnc.dto.validation.groups.WhenUpdating;
import org.jboss.pnc.facade.providers.AbstractUpdatableProvider;
import org.jboss.pnc.facade.providers.api.GroupConfigurationProvider;
import org.jboss.pnc.facade.validation.ConflictedEntryValidator;
import org.jboss.pnc.facade.validation.DTOValidationException;
import org.jboss.pnc.facade.validation.RepositoryViolationException;
import org.jboss.pnc.facade.validation.ValidationBuilder;
import org.jboss.pnc.mapper.api.GroupConfigurationMapper;
import org.jboss.pnc.model.BuildConfiguration;
import org.jboss.pnc.model.BuildConfigurationSet;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.predicates.BuildConfigurationSetPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigSetRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildConfigurationSetRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PermitAll
@Stateless
public class GroupConfigurationProviderImpl
extends AbstractUpdatableProvider<Integer, BuildConfigurationSet, GroupConfiguration, GroupConfigurationRef>
implements GroupConfigurationProvider {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(GroupConfigurationProviderImpl.class);
    @Inject
    private BuildConfigSetRecordRepository buildConfigSetRecordRepository;
    @Inject
    private BuildConfigurationRepository buildConfigurationRepository;

    @Inject
    public GroupConfigurationProviderImpl(BuildConfigurationSetRepository repository, GroupConfigurationMapper mapper) {
        super(repository, mapper, BuildConfigurationSet.class);
    }

    @Override
    public Page<GroupConfiguration> getAll(int pageIndex, int pageSize, String sortingRsql, String query) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationSetPredicates.isNotArchived());
    }

    @Override
    public GroupConfiguration getSpecific(String id) {
        BuildConfigurationSet dbEntity = (BuildConfigurationSet)this.repository.queryById((Serializable)Integer.valueOf(id));
        if (dbEntity != null && dbEntity.isArchived()) {
            return null;
        }
        return (GroupConfiguration)this.mapper.toDTO((GenericEntity)dbEntity);
    }

    @Override
    protected void validateBeforeUpdating(Integer id, GroupConfiguration restEntity) {
        super.validateBeforeUpdating(id, restEntity);
        BuildConfigurationSet dbEntity = (BuildConfigurationSet)this.findInDB(id);
        if (dbEntity.isArchived()) {
            throw new RepositoryViolationException("The Group Config " + id + " is already deleted.");
        }
        ValidationBuilder.validateObject(restEntity, WhenUpdating.class).validateConflict(() -> {
            BuildConfigurationSet groupConfigurationFromDB = (BuildConfigurationSet)this.repository.queryByPredicates(new Predicate[]{BuildConfigurationSetPredicates.withName((String)restEntity.getName()), BuildConfigurationSetPredicates.isNotArchived()});
            if (!(groupConfigurationFromDB == null || restEntity.getId() != null && groupConfigurationFromDB.getId().equals(Integer.valueOf(restEntity.getId())))) {
                return new ConflictedEntryValidator.ConflictedEntryValidationError<Integer>(groupConfigurationFromDB.getId(), BuildConfigurationSet.class, "Group configuration with the same name already exists");
            }
            return null;
        });
    }

    @Override
    public void delete(String id) {
        if (this.hasLink((BuildConfigurationSet)this.repository.queryById((Serializable)Integer.valueOf(id)))) {
            this.archive(id);
        } else {
            super.delete(id);
        }
    }

    @Override
    public GroupConfiguration store(GroupConfiguration restEntity) throws DTOValidationException {
        ValidationBuilder.validateObject(restEntity, WhenCreatingNew.class).validateConflict(() -> {
            List groupConfigurations = this.repository.queryWithPredicates(new Predicate[]{BuildConfigurationSetPredicates.withName((String)restEntity.getName())});
            if (groupConfigurations.size() > 0) {
                BuildConfigurationSet conflicted = (BuildConfigurationSet)groupConfigurations.get(0);
                return new ConflictedEntryValidator.ConflictedEntryValidationError<Integer>(conflicted.getId(), BuildConfigurationSet.class, "Group Configuration with the same name already exist");
            }
            return null;
        });
        return super.store(restEntity);
    }

    @Override
    public Page<GroupConfiguration> getGroupConfigurationsForProductVersion(int pageIndex, int pageSize, String sortingRsql, String query, String productVersionId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationSetPredicates.withProductVersionId((Integer)Integer.valueOf(productVersionId)), BuildConfigurationSetPredicates.isNotArchived());
    }

    @Override
    public Page<GroupConfiguration> getGroupConfigurationsForBuildConfiguration(int pageIndex, int pageSize, String sortingRsql, String query, String bcId) {
        return this.queryForCollection(pageIndex, pageSize, sortingRsql, query, BuildConfigurationSetPredicates.withBuildConfigurationId((Integer)Integer.valueOf(bcId)), BuildConfigurationSetPredicates.isNotArchived());
    }

    private boolean hasLink(BuildConfigurationSet buildConfigurationSet) {
        return !buildConfigurationSet.getBuildConfigSetRecords().isEmpty();
    }

    private void archive(String groupConfigurationId) throws DTOValidationException {
        ValidationBuilder.validateObject(WhenUpdating.class).validateAgainstRepository(this.repository, Integer.valueOf(groupConfigurationId), true);
        BuildConfigurationSet buildConfigurationSet = (BuildConfigurationSet)this.repository.queryById((Serializable)Integer.valueOf(groupConfigurationId));
        buildConfigurationSet.setArchived(true);
        for (BuildConfiguration bc : buildConfigurationSet.getBuildConfigurations()) {
            bc.removeBuildConfigurationSet(buildConfigurationSet);
            this.buildConfigurationRepository.save((GenericEntity)bc);
            buildConfigurationSet.removeBuildConfiguration(bc);
        }
        this.repository.save((GenericEntity)buildConfigurationSet);
    }

    @Override
    public void addConfiguration(String id, String configId) throws DTOValidationException {
        BuildConfigurationSet buildConfigSet = (BuildConfigurationSet)this.repository.queryById((Serializable)Integer.valueOf(id));
        BuildConfiguration buildConfig = (BuildConfiguration)this.buildConfigurationRepository.queryById((Serializable)Integer.valueOf(configId));
        ValidationBuilder.validateObject(buildConfigSet, WhenUpdating.class).validateCondition(buildConfigSet != null, "No build configuration set exists with id: " + id).validateCondition(buildConfig != null, "No build configuration exists with id: " + configId);
        if (!buildConfigSet.getBuildConfigurations().contains(buildConfig)) {
            buildConfigSet.addBuildConfiguration(buildConfig);
            this.repository.save((GenericEntity)buildConfigSet);
        }
    }

    @Override
    public void removeConfiguration(String id, String configId) {
        BuildConfigurationSet buildConfigSet = (BuildConfigurationSet)this.repository.queryById((Serializable)Integer.valueOf(id));
        BuildConfiguration buildConfig = (BuildConfiguration)this.buildConfigurationRepository.queryById((Serializable)Integer.valueOf(configId));
        ValidationBuilder.validateObject(buildConfigSet, WhenUpdating.class).validateCondition(buildConfigSet != null, "No build configuration set exists with id: " + id).validateCondition(buildConfig != null, "No build configuration exists with id: " + configId);
        if (buildConfigSet.getBuildConfigurations().contains(buildConfig)) {
            buildConfigSet.removeBuildConfiguration(buildConfig);
            this.repository.save((GenericEntity)buildConfigSet);
        }
    }
}

