/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.util.labels;

import java.util.EnumSet;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import org.jboss.pnc.api.enums.DeliverableAnalyzerReportLabel;
import org.jboss.pnc.api.enums.LabelOperation;
import org.jboss.pnc.facade.util.labels.AbstractLabelModifier;
import org.jboss.pnc.facade.util.labels.DeliverableAnalyzerLabelSaver;
import org.jboss.pnc.facade.util.labels.DeliverableAnalyzerReportLabelModifier;
import org.jboss.pnc.facade.validation.InvalidLabelOperationException;

@RequestScoped
public class DeliverableAnalyzerReportLabelModifierImpl
extends AbstractLabelModifier<DeliverableAnalyzerReportLabel>
implements DeliverableAnalyzerReportLabelModifier {
    private final DeliverableAnalyzerLabelSaver deliverableAnalyzerLabelSaver;
    public static final String ERR_DELETED_ADD_RELEASED = "cannot mark as RELEASED the report which is already marked DELETED";
    public static final String ERR_SCRATCH_ADD_RELEASED = "cannot mark as RELEASED the report which is already marked SCRATCH";
    public static final String ERR_ADD_SCRATCH = "label can be marked as SCRATCH only when the analysis is executed";
    public static final String ERR_REMOVE_SCRATCH = "label marked SCRATCH cannot be removed";

    @Inject
    public DeliverableAnalyzerReportLabelModifierImpl(DeliverableAnalyzerLabelSaver deliverableAnalyzerLabelSaver) {
        this.deliverableAnalyzerLabelSaver = deliverableAnalyzerLabelSaver;
    }

    @Override
    public void addLabel(DeliverableAnalyzerReportLabel label, EnumSet<DeliverableAnalyzerReportLabel> activeLabels) throws InvalidLabelOperationException {
        switch (label) {
            case DELETED: {
                if (activeLabels.contains(DeliverableAnalyzerReportLabel.RELEASED)) {
                    this.deliverableAnalyzerLabelSaver.removeLabel(DeliverableAnalyzerReportLabel.RELEASED);
                }
                this.deliverableAnalyzerLabelSaver.addLabel(label);
                break;
            }
            case RELEASED: {
                if (activeLabels.contains(DeliverableAnalyzerReportLabel.DELETED)) {
                    DeliverableAnalyzerReportLabelModifierImpl.invalid(label, activeLabels, LabelOperation.ADDED, ERR_DELETED_ADD_RELEASED);
                } else if (activeLabels.contains(DeliverableAnalyzerReportLabel.SCRATCH)) {
                    DeliverableAnalyzerReportLabelModifierImpl.invalid(label, activeLabels, LabelOperation.ADDED, ERR_SCRATCH_ADD_RELEASED);
                }
                this.deliverableAnalyzerLabelSaver.addLabel(label);
                break;
            }
            case SCRATCH: {
                DeliverableAnalyzerReportLabelModifierImpl.invalid(label, activeLabels, LabelOperation.ADDED, ERR_ADD_SCRATCH);
            }
            default: {
                throw new UnsupportedOperationException("Adding of label " + label + " is not supported");
            }
        }
    }

    @Override
    public void removeLabel(DeliverableAnalyzerReportLabel label, EnumSet<DeliverableAnalyzerReportLabel> activeLabels) {
        switch (label) {
            case SCRATCH: {
                throw new InvalidLabelOperationException((Enum<?>)label, (EnumSet<? extends Enum<?>>)activeLabels, LabelOperation.REMOVED, ERR_REMOVE_SCRATCH);
            }
            case DELETED: 
            case RELEASED: {
                this.deliverableAnalyzerLabelSaver.removeLabel(label);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Deleting of label " + label + " is not supported");
            }
        }
    }

    private static void invalid(DeliverableAnalyzerReportLabel label, EnumSet<DeliverableAnalyzerReportLabel> labels, LabelOperation labelOperation, String reason) {
        throw new InvalidLabelOperationException((Enum<?>)label, (EnumSet<? extends Enum<?>>)labels, labelOperation, reason);
    }
}

