/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.impl;

import java.io.Serializable;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import lombok.Generated;
import org.jboss.pnc.api.causeway.dto.push.BuildPushCompleted;
import org.jboss.pnc.api.enums.OperationResult;
import org.jboss.pnc.api.enums.ProgressStatus;
import org.jboss.pnc.common.json.GlobalModuleGroup;
import org.jboss.pnc.common.logging.MDCUtils;
import org.jboss.pnc.dingroguclient.DingroguBuildPushDTO;
import org.jboss.pnc.dingroguclient.DingroguClient;
import org.jboss.pnc.dto.BuildPushReport;
import org.jboss.pnc.dto.requests.BuildPushParameters;
import org.jboss.pnc.enums.BuildStatus;
import org.jboss.pnc.facade.BrewPusher;
import org.jboss.pnc.facade.OperationsManager;
import org.jboss.pnc.facade.validation.EmptyEntityException;
import org.jboss.pnc.facade.validation.OperationNotAllowedException;
import org.jboss.pnc.mapper.api.BuildMapper;
import org.jboss.pnc.mapper.api.BuildPushOperationMapper;
import org.jboss.pnc.mapper.api.BuildPushReportMapper;
import org.jboss.pnc.mapper.api.GroupBuildMapper;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.BuildPushOperation;
import org.jboss.pnc.model.BuildRecord;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.model.Operation;
import org.jboss.pnc.spi.datastore.InconsistentDataException;
import org.jboss.pnc.spi.datastore.predicates.BuildPushPredicates;
import org.jboss.pnc.spi.datastore.predicates.BuildRecordPredicates;
import org.jboss.pnc.spi.datastore.predicates.OperationPredicates;
import org.jboss.pnc.spi.datastore.repositories.BuildPushOperationRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildPushReportRepository;
import org.jboss.pnc.spi.datastore.repositories.BuildRecordRepository;
import org.jboss.pnc.spi.datastore.repositories.api.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ApplicationScoped
public class BrewPusherImpl
implements BrewPusher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BrewPusherImpl.class);
    @Inject
    private BuildRecordRepository buildRecordRepository;
    @Inject
    private OperationsManager operationsManager;
    @Inject
    private BuildPushOperationMapper buildPushOperationMapper;
    @Inject
    private BuildPushReportMapper buildPushReportMapper;
    @Inject
    private BuildPushOperationRepository buildPushOperationRepository;
    @Inject
    private BuildPushReportRepository buildPushReportRepository;
    @Inject
    private DingroguClient dingroguClient;
    @Inject
    private GlobalModuleGroup globalConfig;
    private static final Logger userLog = LoggerFactory.getLogger((String)"org.jboss.pnc._userlog_.brewpush");

    @Override
    public Set<org.jboss.pnc.dto.BuildPushOperation> pushGroup(String buildGroupId, String tagPrefix) {
        BuildPushParameters buildPushParameters = BuildPushParameters.builder().tagPrefix(tagPrefix).reimport(false).build();
        Base32LongID id = GroupBuildMapper.idMapper.toEntity(buildGroupId);
        List buildRecords = this.buildRecordRepository.queryIdsWithPredicates(new Predicate[]{BuildRecordPredicates.withBuildConfigSetRecordId((Base32LongID)id)});
        HashSet<org.jboss.pnc.dto.BuildPushOperation> results = new HashSet<org.jboss.pnc.dto.BuildPushOperation>();
        for (Base32LongID buildId : buildRecords) {
            BuildRecord build = this.getLatestSuccessfullyExecutedBuildRecord(buildId);
            org.jboss.pnc.dto.BuildPushOperation buildPushOperation = this.doPushBuild(build, buildPushParameters, null);
            results.add(buildPushOperation);
            MDCUtils.removeProcessContext();
        }
        return results;
    }

    @Override
    public org.jboss.pnc.dto.BuildPushOperation pushBuild(String buildId, BuildPushParameters buildPushParameters) {
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        return this.pushBuild(id, buildPushParameters, null);
    }

    @Override
    public org.jboss.pnc.dto.BuildPushOperation pushBuild(Base32LongID id, BuildPushParameters buildPushParameters, String milestoneId) {
        BuildRecord build = (BuildRecord)this.buildRecordRepository.queryById((Serializable)id);
        if (build == null) {
            throw new EmptyEntityException("Build with id: " + id + " does not exist!");
        }
        if (build.getStatus().equals((Object)BuildStatus.NO_REBUILD_REQUIRED)) {
            throw new OperationNotAllowedException("Build has NO_REBUILD_REQUIRED status, push last successful build or use force-rebuild.");
        }
        if (!build.getStatus().equals((Object)BuildStatus.SUCCESS)) {
            throw new OperationNotAllowedException("You can push only successful builds.");
        }
        return this.doPushBuild(build, buildPushParameters, milestoneId);
    }

    private org.jboss.pnc.dto.BuildPushOperation doPushBuild(BuildRecord build, BuildPushParameters buildPushParameters, String milestoneId) {
        HashMap<String, String> inputParams = new HashMap<String, String>();
        inputParams.put("tagPrefix", buildPushParameters.getTagPrefix());
        inputParams.put("reimport", buildPushParameters.isReimport() ? "true" : "false");
        if (milestoneId != null) {
            inputParams.put("milestoneClose", milestoneId);
        }
        BuildPushOperation operation = this.operationsManager.newBuildPushOperation(build, inputParams);
        try {
            log.info("Starting brew push of build {}.", (Object)build.getId());
            this.startPush(operation, buildPushParameters.getTagPrefix(), buildPushParameters.isReimport());
            return this.buildPushOperationMapper.toDTO((BuildPushOperation)this.operationsManager.updateProgress(operation.getId(), ProgressStatus.IN_PROGRESS));
        }
        catch (RuntimeException ex) {
            this.operationsManager.setResult(operation.getId(), OperationResult.SYSTEM_ERROR);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPush(BuildPushOperation operation, String tagPrefix, boolean reimport) {
        try {
            MDCUtils.addProcessContext((String)operation.getId().getId());
            MDCUtils.addCustomContext((String)"buildId", (Object)operation.getBuild().getId().getId());
            this.dingroguClient.submitBuildPush(DingroguBuildPushDTO.builder().operationId(operation.getId().getId()).buildId(operation.getBuild().getId().getId()).tagPrefix(tagPrefix).reimport(reimport).orchUrl(this.globalConfig.getPncUrl()).causewayUrl(this.globalConfig.getExternalCausewayUrl()).username(operation.getUser().getUsername()).build());
        }
        finally {
            MDCUtils.removeProcessContext();
            MDCUtils.removeCustomContext((String)"buildId");
        }
    }

    private BuildRecord getLatestSuccessfullyExecutedBuildRecord(Base32LongID buildRecordId) {
        BuildRecord buildRecord = this.buildRecordRepository.findByIdFetchProperties(buildRecordId);
        if (buildRecord == null) {
            throw new EmptyEntityException("Build record not found.");
        }
        switch (buildRecord.getStatus()) {
            case SUCCESS: {
                return buildRecord;
            }
            case NO_REBUILD_REQUIRED: {
                BuildRecord noRebuildCause = buildRecord.getNoRebuildCause();
                if (noRebuildCause != null) {
                    return noRebuildCause;
                }
                String message = "There is no SUCCESS build before NO_REBUILD_REQUIRED.";
                log.error(message);
                throw new InconsistentDataException(message);
            }
        }
        throw new OperationNotAllowedException("Not allowed to push failed build.");
    }

    @Override
    public void cancelPushOfBuild(String buildId) {
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        List buildPushOperations = this.buildPushOperationRepository.queryWithPredicates(new Predicate[]{OperationPredicates.inProgress(), BuildPushPredicates.withBuild((Base32LongID)id)});
        if (buildPushOperations.isEmpty()) {
            throw new EmptyEntityException("There is no running push operation for build id: " + buildId);
        }
        buildPushOperations.forEach(operation -> this.dingroguClient.cancelProcessInstance(List.of(), operation.getId().getId()));
    }

    @Override
    public void cancelPushOfMilestone(String milestoneId) {
        List<BuildPushOperation> buildPushOperations = this.buildPushOperationRepository.queryWithPredicates(new Predicate[]{OperationPredicates.inProgress()}).stream().filter(o -> milestoneId.equals(o.getOperationParameters().get("milestoneClose"))).collect(Collectors.toList());
        if (buildPushOperations.isEmpty()) {
            throw new EmptyEntityException("There is no running push operation for milestone: " + milestoneId);
        }
        buildPushOperations.forEach(operation -> this.dingroguClient.cancelProcessInstance(List.of(), operation.getId().getId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void brewPushComplete(String buildId, BuildPushCompleted buildPushCompletion) {
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        MDCUtils.addProcessContext((String)buildPushCompletion.getOperationId());
        Base32LongID operationId = (Base32LongID)this.buildPushOperationMapper.getIdMapper().toEntity((Object)buildPushCompletion.getOperationId());
        BuildPushOperation buildPushOperation = (BuildPushOperation)this.buildPushOperationRepository.queryById((Serializable)operationId);
        if (buildPushOperation == null) {
            throw new EmptyEntityException("Build push operation with id " + operationId + " not found.");
        }
        MDCUtils.addCustomContext((String)"buildId", (Object)id.getLongId());
        try {
            log.info("Received completion notification for BuildRecord.id: {}. Object received: {}.", (Object)buildId, (Object)buildPushCompletion);
            org.jboss.pnc.model.BuildPushReport report = org.jboss.pnc.model.BuildPushReport.builder().id(id).operation(buildPushOperation).brewBuildId(buildPushCompletion.getBrewBuildId()).brewBuildUrl(buildPushCompletion.getBrewBuildUrl()).build();
            this.buildPushReportRepository.save((GenericEntity)report);
            userLog.info("Brew push completed.");
        }
        finally {
            MDCUtils.removeProcessContext();
            MDCUtils.removeCustomContext((String)"buildId");
        }
    }

    @Override
    public BuildPushReport getBrewPushResult(String buildId) {
        Base32LongID id = BuildMapper.idMapper.toEntity(buildId);
        List buildPushOperations = this.buildPushOperationRepository.queryWithPredicates(new Predicate[]{BuildPushPredicates.withBuild((Base32LongID)id)});
        Optional<BuildPushOperation> latestOperation = buildPushOperations.stream().filter(o -> o.getProgressStatus() != ProgressStatus.FINISHED).max(Comparator.comparing(Operation::getSubmitTime));
        if (latestOperation.isPresent()) {
            return this.buildPushReportMapper.fromOperation(latestOperation.get());
        }
        latestOperation = buildPushOperations.stream().filter(o -> o.getProgressStatus() == ProgressStatus.FINISHED).max(Comparator.comparing(Operation::getEndTime));
        if (latestOperation.isPresent()) {
            BuildPushOperation operation = latestOperation.get();
            if (operation.getResult() == OperationResult.SUCCESSFUL) {
                org.jboss.pnc.model.BuildPushReport buildPushReport = (org.jboss.pnc.model.BuildPushReport)this.buildPushReportRepository.queryById((Serializable)operation.getId());
                return this.buildPushReportMapper.toRef(buildPushReport);
            }
            return this.buildPushReportMapper.fromOperation(operation);
        }
        return null;
    }

    @Override
    public BuildPushReport getBrewPushReport(String operationId) {
        Base32LongID id = BuildMapper.idMapper.toEntity(operationId);
        org.jboss.pnc.model.BuildPushReport buildPushReport = (org.jboss.pnc.model.BuildPushReport)this.buildPushReportRepository.queryById((Serializable)id);
        if (buildPushReport != null) {
            return this.buildPushReportMapper.toRef(buildPushReport);
        }
        BuildPushOperation buildPushOperation = (BuildPushOperation)this.buildPushOperationRepository.queryById((Serializable)id);
        return this.buildPushReportMapper.fromOperation(buildPushOperation);
    }
}

