/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.pnc.facade.util.labels;

import java.time.Instant;
import java.util.Date;
import javax.enterprise.context.RequestScoped;
import javax.inject.Inject;
import javax.transaction.Transactional;
import org.jboss.pnc.api.enums.DeliverableAnalyzerReportLabel;
import org.jboss.pnc.api.enums.LabelOperation;
import org.jboss.pnc.facade.util.UserService;
import org.jboss.pnc.facade.util.labels.AbstractLabelSaver;
import org.jboss.pnc.facade.util.labels.DeliverableAnalyzerLabelSaver;
import org.jboss.pnc.model.Base32LongID;
import org.jboss.pnc.model.DeliverableAnalyzerLabelEntry;
import org.jboss.pnc.model.DeliverableAnalyzerReport;
import org.jboss.pnc.model.GenericEntity;
import org.jboss.pnc.spi.datastore.repositories.DeliverableAnalyzerLabelEntryRepository;

@RequestScoped
public class DeliverableAnalyzerLabelSaverImpl
extends AbstractLabelSaver<Base32LongID, Base32LongID, DeliverableAnalyzerReportLabel, DeliverableAnalyzerLabelEntry, DeliverableAnalyzerReport>
implements DeliverableAnalyzerLabelSaver {
    private final UserService userService;

    @Inject
    public DeliverableAnalyzerLabelSaverImpl(DeliverableAnalyzerLabelEntryRepository repository, UserService userService) {
        super(repository);
        this.userService = userService;
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void addLabel(DeliverableAnalyzerReportLabel label) {
        ((DeliverableAnalyzerReport)this.labeledObject).getLabels().add(label);
        this.labelEntryRepository.save((GenericEntity)this.createAddLabelHistoryEntry(label));
    }

    @Override
    @Transactional(value=Transactional.TxType.MANDATORY)
    public void removeLabel(DeliverableAnalyzerReportLabel label) {
        ((DeliverableAnalyzerReport)this.labeledObject).getLabels().remove(label);
        this.labelEntryRepository.save((GenericEntity)this.createRemoveLabelHistoryEntry(label));
    }

    private DeliverableAnalyzerLabelEntry createAddLabelHistoryEntry(DeliverableAnalyzerReportLabel labelToAdd) {
        return this.createLabelHistoryWithChange(labelToAdd, LabelOperation.ADDED);
    }

    private DeliverableAnalyzerLabelEntry createRemoveLabelHistoryEntry(DeliverableAnalyzerReportLabel labelToRemove) {
        return this.createLabelHistoryWithChange(labelToRemove, LabelOperation.REMOVED);
    }

    private DeliverableAnalyzerLabelEntry createLabelHistoryWithChange(DeliverableAnalyzerReportLabel label, LabelOperation change) {
        return DeliverableAnalyzerLabelEntry.builder().report((DeliverableAnalyzerReport)this.labeledObject).changeOrder(Integer.valueOf(++this.nextChangeOrder)).user(this.userService.currentUser()).entryTime(Date.from(Instant.now())).reason(this.reason).label(label).change(change).build();
    }
}

